.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "VACUUM" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
VACUUM \- garbage-collect and optionally analyze a database
.SH SYNOPSIS
.sp
.nf
VACUUM [ FULL ] [ FREEZE ] [ VERBOSE ] [ \fItable\fR ]
VACUUM [ FULL ] [ FREEZE ] [ VERBOSE ] ANALYZE [ \fItable\fR [ (\fIcolumn\fR [, ...] ) ] ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBFULL\fR
Selects ``full'' vacuum, which may reclaim more space,
but takes much longer and exclusively locks the table.
.TP
\fBFREEZE\fR
Selects aggressive ``freezing'' of tuples.
.TP
\fBVERBOSE\fR
Prints a detailed vacuum activity report for each table.
.TP
\fBANALYZE\fR
Updates statistics used by the optimizer to
determine the most efficient way to execute a query.
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of a specific table to
vacuum. Defaults to all tables in the current database.
.TP
\fB\fIcolumn\fB\fR
The name of a specific column to analyze. Defaults to all columns.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBVACUUM\fR
The command is complete.
.TP
\fBINFO: --Relation \fItable\fB--\fR
The report header for \fItable\fR.
.TP
\fBINFO: Pages 98: Changed 25, Reapped 74, Empty 0, New 0;\fR
The analysis for \fItable\fR itself.
.TP
\fBINFO: Index \fIindex\fB: Pages 28;\fR
The analysis for an index on the target table.
.PP
.SH "DESCRIPTION"
.PP
\fBVACUUM\fR reclaims storage occupied by deleted tuples.
In normal PostgreSQL operation, tuples that
are deleted or obsoleted by UPDATE are not physically removed from
their table; they remain present until a \fBVACUUM\fR is
done. Therefore it's necessary to do \fBVACUUM\fR
periodically, especially on frequently-updated tables.
.PP
With no parameter, \fBVACUUM\fR processes every table in the
current database. With a parameter, \fBVACUUM\fR processes
only that table.
.PP
\fBVACUUM ANALYZE\fR performs a \fBVACUUM\fR
and then an \fBANALYZE\fR for each selected table. This
is a handy combination form for routine maintenance scripts. See
ANALYZE [\fBanalyze\fR(l)]
for more details about its processing.
.PP
Plain \fBVACUUM\fR (without FULL) simply reclaims
space and makes it
available for re-use. This form of the command can operate in parallel
with normal reading and writing of the table, as an exclusive lock
is not obtained. \fBVACUUM
FULL\fR does more extensive processing, including moving of tuples
across blocks to try to compact the table to the minimum number of disk
blocks. This form is much slower and requires an exclusive lock on each
table while it is being processed.
.PP
\fBFREEZE\fR is a special-purpose option that
causes tuples to be marked ``frozen'' as soon as possible,
rather than waiting until they are quite old. If this is done when there
are no other open transactions in the same database, then it is guaranteed
that all tuples in the database are ``frozen'' and will not be
subject to transaction ID wraparound problems, no matter how long the
database is left un-vacuumed.
\fBFREEZE\fR is not recommended for routine use. Its only
intended usage is in connection with preparation of user-defined template
databases, or other databases that are completely read-only and will not
receive routine maintenance \fBVACUUM\fR operations.
See the \fIAdministrator's Guide\fR for details.
.SS "NOTES"
.PP
We recommend that active production databases be
\fBVACUUM\fR-ed frequently (at least nightly), in order to
remove expired rows. After adding or deleting a large number
of records, it may be a good idea to issue a \fBVACUUM
ANALYZE\fR command for the affected table. This will update the
system catalogs with
the results of all recent changes, and allow the
PostgreSQL query optimizer to make better
choices in planning user queries.
.PP
The \fBFULL\fR option is not recommended for routine use,
but may be useful in special cases. An example is when you have deleted
most of the rows in a table and would like the table to physically shrink
to occupy less disk space. \fBVACUUM FULL\fR will usually
shrink the table more than a plain \fBVACUUM\fR would.
.SH "USAGE"
.PP
The following is an example from running \fBVACUUM\fR on a table
in the regression database:
.sp
.nf
regression=> VACUUM VERBOSE ANALYZE onek;
INFO:  --Relation onek--
INFO:  Index onek_unique1: Pages 14; Tuples 1000: Deleted 3000.
        CPU 0.00s/0.11u sec elapsed 0.12 sec.
INFO:  Index onek_unique2: Pages 16; Tuples 1000: Deleted 3000.
        CPU 0.00s/0.10u sec elapsed 0.10 sec.
INFO:  Index onek_hundred: Pages 13; Tuples 1000: Deleted 3000.
        CPU 0.00s/0.10u sec elapsed 0.10 sec.
INFO:  Index onek_stringu1: Pages 31; Tuples 1000: Deleted 3000.
        CPU 0.01s/0.09u sec elapsed 0.10 sec.
INFO:  Removed 3000 tuples in 70 pages.
        CPU 0.02s/0.04u sec elapsed 0.07 sec.
INFO:  Pages 94: Changed 0, Empty 0; Tup 1000: Vac 3000, Keep 0, UnUsed 0.
        Total CPU 0.05s/0.45u sec elapsed 0.59 sec.
INFO:  Analyzing onek
VACUUM
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBVACUUM\fR statement in SQL92.
