.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "UNLISTEN" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
UNLISTEN \- stop listening for a notification
.SH SYNOPSIS
.sp
.nf
UNLISTEN { \fInotifyname\fR | * }
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fInotifyname\fB\fR
Name of previously registered notify condition.
.TP
\fB*\fR
All current listen registrations for this backend are cleared.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBUNLISTEN\fR
Acknowledgment that statement has executed.
.PP
.SH "DESCRIPTION"
.PP
\fBUNLISTEN\fR
is used to remove an existing \fBNOTIFY\fR registration.
\fBUNLISTEN\fR cancels any existing registration of the current
PostgreSQL session as a listener on the notify
condition \fInotifyname\fR.
The special condition wildcard * cancels all listener registrations
for the current session.
.PP
NOTIFY [\fBnotify\fR(l)]
contains a more extensive
discussion of the use of \fBLISTEN\fR and
\fBNOTIFY\fR.
.SS "NOTES"
.PP
\fInotifyname\fR
need not be a valid class name but can be any string valid
as a name up to 64 characters long.
.PP
The backend does not complain if you unlisten something you were not
listening for.
Each backend will automatically execute \fBUNLISTEN *\fR when
exiting.
.SH "USAGE"
.PP
To subscribe to an existing registration:
.sp
.nf
LISTEN virtual;
LISTEN
NOTIFY virtual;
NOTIFY
Asynchronous NOTIFY 'virtual' from backend with pid '8448' received
.sp
.fi
.PP
Once \fBUNLISTEN\fR has been executed, further \fBNOTIFY\fR commands will be
ignored:
.sp
.nf
UNLISTEN virtual;
UNLISTEN
NOTIFY virtual;
NOTIFY
-- notice no NOTIFY event is received
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBUNLISTEN\fR in SQL92.
