
#include<stdio.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<stdlib.h>
#include<string.h>
#include<pthread.h>
#include<time.h>
#include<errno.h>

#include"zither.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"

#ifdef POSTGRES_IN
  #include<libpq-fe.h>
  PGconn * conn;
  PGresult * res;
#endif

global_data_t gd;




int main(int argc, char * argv[])
{
pthread_t t1;
long int fdcount;

malloc_set();
set_data();
optin(argc, argv);
conf_set(gd.fp.conf_path);

printf("main(): neg=%s, lock=%s, conf=%s\n", gd.fp.neg_conf, gd.fp.lock_path, gd.fp.file_conf);
lockfile_remove(gd.fp.neg_conf, gd.fp.lock_path, gd.fp.file_conf);
malloc_set2();

if(gd.exid.uid <= 0){
   fprintf(stderr,"main(): Not exec user id. %d\n", gd.exid.uid);
   exit(-1);
   }
if(setuid(gd.exid.uid)){
   fprintf(stderr,"main(): Not setuid err %d\n", gd.exid.uid);
   exit(-1);
   }

#ifdef ERR_OUT
pthread_mutex_init(&err_mutex, NULL);
gd.fp.err_fd = fd_outopen(gd.fp.errlog, gd.fp.err_fp);
#endif
#ifdef LOG_OUT
pthread_mutex_init(&con_mutex, NULL);
gd.fp.con_fd = fd_outopen(gd.fp.connectlog, gd.fp.con_fp);
#endif

#ifdef POSTGRES_IN
pthread_mutex_init(&pg_mutex, NULL);
gd.pg.stat = pqconnect();
#endif

if(-1 == (socket_bind(&gd.ms.my_addr, gd.ms.port, gd.ms.ip_addr, &gd.ms.ls))){
   fprintf(stderr,"zither(): IP%sをバインド出来ない為、致し方なく死亡します \n", gd.ms.ip_addr);
   exit(1);
   }

/* client stop checker thread */
pthread_create( &t1, NULL, (void *)clockfile_check, NULL);

for(;;){
   for(fdcount = 0; fdcount < gd.ms.max_count; fdcount++){
      if(gd.ms.fdstat[fdcount] != 1){
         gd.ms.fdstat[fdcount] = 1;
         break;
         }
      } 
   #ifdef DEBUG
   fprintf(stderr,"DEBUG: main(): new connection fdno = %d\n",fdcount); 
   #endif
   if(fdcount < gd.ms.max_count){
      if((socket_accept(&gd.ms.my_addr, &gd.ms.ls, &gd.ms.sk[fdcount]))!=-1){
         gd.ms.fdno = fdcount;
         memcpy(gd.ms.inip_addr[fdcount],&gd.ms.my_addr.sin_addr.s_addr,sizeof(gd.ms.inip_addr[fdcount]));
         pthread_create( &gd.pt[fdcount], NULL, (void *)connect_open, (long int *)gd.ms.fdno);
         #ifdef THREAD_BUG
         fprintf(stderr,"THREAD_BUG: main(): 新しいスレッドが生成されました. 番号 %ld\n", fdcount);
         #endif
         }
      else{
         #ifdef THREAD_BUG
         fprintf(stderr,"THREAD_BUG: main() accept()に何らかのエラー. 番号 %ld\n", fdcount);
         #endif
         }
      }
   else {
      fprintf(stderr,"main(): スレッド生成数の上限に達しています、10秒ほど待ってみます.%ld\n",fdcount);
      sleep(10); 
      }
   }

/* --- It doesn't reach. ---*/
close(gd.ms.ls);
return 0;
}





