
#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<pthread.h>
#include<stdlib.h>

#include"zither.h"
#include<almemsys/almemsys.h>


/*
cahr * diff_send(char *, char *, int *, int);
*/




/*---------------- FILE SEND2 --------------------*/
char * file_send2(int sock_fd, char * filename, char * data, int * stat, int interval, char delim)
{
FILE * fp;
FILE * lfp;
int fd, count, ch, counts;

ch = 0;
counts = 0;

char * lock_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));
char * backup_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));
char * swap = (char *)calloc(BUF_DEFLEN, sizeof(char));

// lockfile 名を作る
lock_filename = safe_memcpy(lock_filename, filename, BUF_MAX);
lock_filename = safe_strncat(lock_filename, "_lock", BUF_MAX);

// backupfile 名を作る
backup_filename = safe_memcpy(backup_filename, filename, BUF_MAX);
backup_filename = safe_strncat(backup_filename, "_backup", BUF_MAX);


for(count = 0; count < 15; count++){
   if((lfp = fopen(lock_filename, "r"))==NULL){                      // lock_file が無い場合
      if((lfp = fopen(lock_filename, "w+"))!=NULL){                  // lock_file を作れた場合

         if((fp = fopen(filename, "r"))!=NULL){                      // file が読めた場合
            fd = fileno(fp); 

            if(0 > (file_copy(filename, backup_filename))){          // file の服制を作る
               fprintf(stderr,"file_send2(): file copy err. <%s -> %s>\n",
                 filename, backup_filename);
               }
            #ifdef FILESEND_DEBUG
            else{
               fprintf(stdout,"FILESEND_DEBUG: file_send2(): OK file copy: %s -> %s \n", filename, backup_filename);
               }
            #endif

            * stat = alget_write(sock_fd, fp, interval, (char)delim, FILE_LEN, 0);

            fclose(fp);                                       // file のclose
            }                                                 // file が読めた場合の終わり

         else{                                                // file が読めない場合 
            /* * stat = -1; */
            data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
            fprintf(stderr,"file_send2(): CONF FILE NOT OPEN: filename = <%s>\n", filename);
            * stat = socket_send(sock_fd, "500 NG file_send2(): not open.\n", interval);
            }                                                // fileが読めない場合の終わり

         lock_remove(lock_filename);                         // lock_file 削除
         fclose(lfp);
         break;
         }
      else{                                                  // lock_file が作れない場合
         data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
         fprintf(stderr,"file_send2(): config lockfile is not open!. %s\n", lock_filename);
         * stat = socket_send(sock_fd, "500 NG  lock file not open.\n", interval);
         break;
         }
      }
   else{                                                     // lock_fileがすでにあった場合
      fprintf(stderr,"file_send2(): config lockfile extas wait 1sec %s\n", lock_filename);
      fclose(lfp);
      sleep(1);
      }
   }                                                         // for() loop

if(count >= 5){
   data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
   fprintf(stderr,"file_send2(): config lockfile exeitas wait 5sec. loop out. %s\n", lock_filename);
   * stat = socket_send(sock_fd, "500 NG  lock file not open.\n", interval);
   }

free(lock_filename);
free(backup_filename);
free(swap);

return data;
}





