

#include<stdio.h>
#include<unistd.h>
#include<sys/wait.h>
#include<netinet/in.h>
#include<string.h>
#include<stdlib.h>
#include<pthread.h>

#include"sitar.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"
#include<file_comp/file_comp.h>

extern global_data_t gd;

extern pthread_mutex_t fd_mutex;




// 1.1.7以降のファイルGET用、−1を返す場合は再起動。
int get_alget(char * bat_filename, char * senddata)
{
FILE * fp;
int stat, interval, fd;

char * rec = (char *)calloc(IP_LEN, sizeof(char));
char * intr = (char *)calloc(IP_LEN, sizeof(char));
char * comdata = (char *)calloc(IP_LEN, sizeof(char));

interval = (gd.bf.life_int + gd.bf.life_los + INT_PLUS);

intr = safe_sprintf(intr, BUF_MAX, "%s :: COM: ALGET DATA: %s\n", gd.bf.c_name, senddata);

pthread_mutex_lock(&fd_mutex);      // socket mutex 開始

if((stat = socket_send(gd.ip.sk, intr, interval)) > 0){   // ALGET の送信
   rec = alget_read(bat_filename, rec, gd.ip.sk, interval, &stat, (char)0x05, FILE_LEN, 0);
   }
else{
   fprintf(stderr, "get_alget(): send data err. %s\n", bat_filename);
   }

pthread_mutex_unlock(&fd_mutex);    // socket mutex 終了


// 送信コマンドが"COMAND"であり、ステータスが400の場合、受け取ったファイルを/sample_bin 以下に展開
if(0 == self_memcmp(senddata, "COMAND") && 0 == memcmp(rec, "400", 3)){

   if((fp = fopen(bat_filename, "r"))!=NULL){
      fd = fileno(fp);
      comdata = safe_filefdcat(fd, comdata, &stat, BUF_MAX, interval);
      #ifdef FILE_COMP_BUG
      printf("FILE_COMP_BUG: file_alget(): comand %s\n", senddata);
      printf("FILE_COMP_BUG: file_alget(): comand %s\n", rec);
      printf("FILE_COMP_BUG: file_alget(): comand %s\n", comdata);
      #endif
      if(0 == unlinkdir(gd.fi.command_path)){
         if(file_comp(comdata, gd.fi.command_path)){
            fprintf(stdout,"get_alget(): file_comp()がエラーを返してます\n");
            }
         }
      else{
         fprintf(stdout,"get_alget(): unlink_dir(%s)がエラーを返してます\n", gd.fi.command_path);
         }

      close(fd);
      }
   else{
      fprintf(stdout,"get_alget(): command file <%s> が開けないです\n", bat_filename);
      }
   }

// 送信コマンドが"CRONFILE"であり、ステータスが400の場合、受け取ったファイルを/cron 以下に展開
if(0 == self_memcmp(senddata, "CRONFILE") && 0 == memcmp(rec, "400", 3)){

   if((fp = fopen(bat_filename, "r"))!=NULL){
      fd = fileno(fp);
      comdata = safe_filefdcat(fd, comdata, &stat, BUF_MAX, interval);
      #ifdef FILE_COMP_BUG
      printf("FILE_COMP_BUG: file_alget(): cron %s\n", senddata);
      printf("FILE_COMP_BUG: file_alget(): cron %s\n", rec);
      printf("FILE_COMP_BUG: file_alget(): cron %s\n", comdata);
      #endif
      if(0 == unlinkdir(gd.fi.cron_path)){
         if(file_comp(comdata, gd.fi.cron_path)){
            fprintf(stdout,"get_alget(): file_comp()がエラーを返してます\n");
            }
         }
      else{
         fprintf(stdout,"get_alget(): unlink_dir(%s)がエラーを返してます\n", gd.fi.cron_path);
         }

      close(fd);
      }
   else{
      fprintf(stdout,"get_alget(): command file <%s> が開けないです\n", bat_filename);
      }
   }



if(0 == (memcmp(rec, "500 NG", 6)) && stat != -1){
   fprintf(stderr,"get_alget(): server side comand or list file not open.\n");

   if(0 == (memcmp(senddata, "COMAND", 6))){
      intr = safe_sprintf(intr, BUF_MAX,
        "%s :: COM: AUPL DATA: COMAND\n", gd.bf.c_name);
      }
   if(0 == (memcmp(senddata, "PORT", 4))){
      intr = safe_sprintf(intr, BUF_MAX,
        "%s :: COM: AUPL DATA: PORT\n", gd.bf.c_name);
      }


   if((fp = fopen(bat_filename, "r"))!=NULL){
      fd = fileno(fp);

      pthread_mutex_lock(&fd_mutex);

      if((stat = socket_send(gd.ip.sk, intr, interval)) > 0){
         rec = select_fdcat(gd.ip.sk, rec, &stat, BUF_MAX, interval); 
         if(0 == memcmp(rec, "200", 3) && stat > 0){

            stat = alget_write(gd.ip.sk, fp, interval, (char)0x05, FILE_LEN, 1);

            }
         else{
            fprintf(stderr,"get_alget(): client side file not stat.\n");
            }

         }
      else{
         safe_exit("get_alget(2): socket err exit \n");
         }

      pthread_mutex_unlock(&fd_mutex);


      fclose(fp);
      }
   else{
      fprintf(stderr,"get_alget(): client side file not open.\n");
      }
   }

free(rec);
free(intr);
free(comdata);

return stat;
}







