// scan_dhwport.c
// $Id: scan_dhwport.c,v 1.1.1.1 2007/09/19 05:49:54 sendan Exp $
// masashi shimakura

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<netdb.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<fcntl.h>

#include<sys/stat.h>
#include<errno.h>

#include"sitar_scan.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"


/* 0-> dhw exc command line 1-> port No' 2-> Ipsddr 3-> return data,, return status code 0=open or=close
int scan_smtp_connect(int, char *, char *, int);
*/


/*----------------- SCAN DHW CONNECT --------------------*/
char * scan_dhw_connect(char * comand, int port, char * url_dom, char * backdata, int timeout, int * pst)
{
int sk, re, ret, retval, arglen, dcount;
char ipa[IP_LEN];
char * ip_addr = ipa;
unsigned long resoip;
struct sockaddr_in my_addr;
fd_set rfds;
struct timeval tv;
char * recvdata = NULL;
char * senddata = NULL;

ret = -1;
errno = 0;
arglen = sizeof(int);
dcount = 0;

#ifdef DHW_BUG
printf("DHW: scan_dhw_connect(1): DHW COMMAND %s\n", comand);
#endif

if((recvdata = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}
if((senddata = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}

if((sk = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"scan_dhw URL=%s Port=%d tcp %s", url_dom, port, SOCK_1);
   backdata=safe_sprintf(backdata, BUF_MAX,
    "URL=%s Port=%d tcp %s", url_dom, port, SOCK_1);
   * pst = -1;
   free(recvdata);
   free(senddata);
   return backdata;
   }

my_addr.sin_family = AF_INET;
my_addr.sin_port = htons(port);

backdata = resolvename(backdata, url_dom, timeout, &resoip);
my_addr.sin_addr.s_addr = resoip;

if(0 == (int)my_addr.sin_addr.s_addr || resoip == (int)NULL){
   backdata=safe_sprintf(backdata,BUF_MAX,"%s %s %d\n",
    SOCK_2, url_dom, (int)my_addr.sin_addr.s_addr);
   close(sk);
   * pst = -1;
   free(recvdata);
   free(senddata);
   return backdata;
   }

ip_addr = inet_ntoa(my_addr.sin_addr);

#ifdef DHW_BUG
printf("DHW: scan_dhw_connect(2): connect start %s %s %d\n", url_dom, ip_addr, port);
#endif

// 非同期通信の開始、TCPポートにコネクション
fcntl(sk, F_SETFL, O_NONBLOCK);
re = connect(sk, (struct sockaddr *)(long int)&my_addr, sizeof(my_addr));

// 速攻で繋がった場合の処理
if(re >= 0){
   // 非同期通信から同期通信に
   fcntl(sk, F_SETFL, 0);
   backdata=safe_sprintf(backdata,BUF_MAX,
    "URL=%s Port=%d %s", url_dom, port, SOCK_5);
   #ifdef URL_BUG
   printf("URL: scan_url_connect(4): CONNECT SUCCESS %s\n", backdata);
   #endif
   goto notselect;
   }

// errnoが EINPROGRESS な場合
if(errno == EINPROGRESS){
   tv.tv_sec = timeout;
   tv.tv_usec = 0;
   while(1){
      FD_ZERO(&rfds);
      FD_SET(sk, &rfds);
      retval = select(sk + 1, NULL, &rfds, NULL, &tv);
      // select 異常終了
      if(retval < 0){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s %s", url_dom, port, SOCK_15, SOCK_5);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(3): select err BREAK- %d - %s\n", retval, backdata);
         #endif
         // 非同期通信から同期通信に
         fcntl(sk, F_SETFL, 0);
         close(sk);
         * pst = -1;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      // select のタイムアウト
      else if(retval == 0){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s %s", url_dom, port, SOCK_16, SOCK_5);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(4): select time out BREAK- %d - %s\n",
           retval, backdata);
         #endif
         // 非同期通信から同期通信に
         fcntl(sk, F_SETFL, 0);
         close(sk);
         * pst = -1;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      // 時間内に接続出来たのでLoopOut
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_dom, port, SOCK_3);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(5): select time succes BREAK- %d - %s\n", retval, backdata);
         #endif
         break;
         }
      }


   // 非同期通信から同期通信に
   fcntl(sk, F_SETFL, 0);

   // select を省いたGOTO
   notselect :;

   // ソケットに関するペンディングエラーを返す
   if(getsockopt(sk, SOL_SOCKET, SO_ERROR, (void *)&retval, (void *)&arglen) < 0){
      backdata=safe_sprintf(backdata,BUF_MAX,
       "URL=%s Port=%d %s", url_dom, port, SOCK_13);
      #ifdef DHW_BUG
      fprintf(stderr,"getsockopt(6) Errors!\n");
      #endif
      close(sk);
      * pst = -1;
      free(recvdata);
      free(senddata);
      return backdata;
      }

   else{
      // エラーがある
      if(retval){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s: TCP %s", url_dom, port, (retval != 0) ? strerror(retval): "0", SOCK_5);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(7): 1 SO_ERROR %d -%s\n", retval, backdata);
         #endif
         close(sk);
         * pst = -1;
         free(recvdata);
         free(senddata);
         return backdata;
         }

      // エラーが無い場合
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_dom, port, SOCK_3);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(8): 1 SO_ERROR else %d -%s\n", retval, backdata);
         #endif
         senddata=safe_sprintf(senddata, BUF_MAX, "%s\n\n", comand);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(9): set_request*send-- %s --\n", senddata);
         #endif 

         // 再度非同期通信の開始
         fcntl(sk, F_SETFL, O_NONBLOCK);

         // DHW コマンドの送信
         send(sk, senddata, strlen(senddata), 0);

         tv.tv_sec = timeout;
         tv.tv_usec = 0;
         while(1){
            FD_ZERO(&rfds);
            FD_SET(sk, &rfds);
            retval = select(sk + 1, &rfds, NULL, NULL, &tv);

            // select の異常終了
            if(retval < 0){
               #ifdef DHW_BUG
               printf("DHW: scan_dhw_connect(10): retval 0 ERR\n");
               #endif 
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s %s", url_dom, port, SOCK_15, URL_2);
               // 非同期通信から同期通信に
               fcntl(sk, F_SETFL, 0);
               close(sk);
               * pst = -1;
               free(recvdata);
               free(senddata);
               return backdata;
               }

            // selectのタイムアウト
            else if(retval == 0){
               #ifdef DHW_BUG
               printf("DHW: scan_dhw_connect(11): retval 1 ERR\n"); 
               #endif 
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s %s" , url_dom, port, SOCK_16, URL_3);
               // 非同期通信から同期通信に
               fcntl(sk, F_SETFL, 0);
               close(sk);
               * pst = -1;
               free(recvdata);
               free(senddata);
               return backdata;
               }

            // select正常
            else{
               dcount = recv(sk, recvdata, BUF_LEN, 0);
               #ifdef DHW_BUG
               printf("DHW: scan_dhw_connect(12): recv-- %s --\n", recvdata);
               #endif

               // 受信量がゼロ、エラーではない。
               if(dcount < 1){
                  backdata = safe_sprintf(backdata,BUF_MAX,
                    "DHW COMMAND SUCCESS %s" , comand);
                  ret = 0;
                  #ifdef DHW_BUG
                  printf("DHW: scan_dhw_connect(13): <%d>\n", ret);
                  #endif
                  }

            // 何らかのエラーを取得
               else{
               ret = -1;
                  #ifdef DHW_BUG
                  printf("DHW: scan_dhw_connect(14): <%d><2> %s\n", ret, backdata);
                  #endif
                  }

               if(ret == -1){
                  backdata=safe_memcpy(backdata, recvdata, BUF_LEN);
                  }

               #ifdef DHW_BUG
               printf("DHW: scan_dhw_connect(15): %d <2> %s\n", ret, backdata);
               #endif
               // 非同期通信から同期通信に
               fcntl(sk, F_SETFL, 0);
               close(sk);
               * pst = ret;
               free(recvdata);
               free(senddata);
               return backdata;
               }
            }

         // 非同期通信から同期通信に
         fcntl(sk, F_SETFL, 0);
         // 非同期通信から同期通信に
         fcntl(sk, F_SETFL, 0);
         close(sk);
         * pst = ret;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      }
   }


// host IP 等が存在すらしない場合の処理
// 非同期通信から同期通信に
fcntl(sk, F_SETFL, 0);
backdata=safe_sprintf(backdata,BUF_MAX,
 "URL=%s Port=%d %s", url_dom, port, SOCK_14);
#ifdef DHW_BUG
printf("DHW: scan_dhw_connect(16): not connection last out\n");
#endif

close(sk);
* pst = -1;

free(recvdata);
free(senddata);
return backdata;

}







