// malloc_set.c
// $Id: malloc_set.c,v 1.3 2007/08/21 03:14:28 sendan Exp $
// masashi shimakura

#include<stdio.h>
#include<unistd.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<string.h>
#include<stdlib.h>
#include<pthread.h>

#include"zither.h"

extern global_data_t gd;

int malloc_set(void)
{

/*  postgres socket */
if((gd.pg.postgres_data=(char*)calloc(IP_LEN, sizeof(char)))==NULL){exit(1);}
if((gd.pg.pg_webserver=(char*)calloc(IP_LEN, sizeof(char)))==NULL){exit(1);}

/*  my_sock */
if((gd.ms.ip_addr=(char*)calloc(IP_LEN, sizeof(char)))==NULL){exit(1);}

/*  file_path */
if((gd.fp.lock_path=(char*)calloc(BUF_SLEN, sizeof(char)))==NULL){exit(1);}
if((gd.fp.clock_path=(char*)calloc(BUF_SLEN, sizeof(char)))==NULL){exit(1);}
if((gd.fp.file_conf=(char*)calloc(BUF_SLEN, sizeof(char)))==NULL){exit(1);}
if((gd.fp.errlog=(char*)calloc(BUF_SLEN, sizeof(char)))==NULL){exit(1);}
if((gd.fp.connectlog=(char*)calloc(BUF_SLEN, sizeof(char)))==NULL){exit(1);}

/*  mail_data */
if((gd.md.ch_MailFrom=(char*)calloc(BUF_SLEN, sizeof(char)))==NULL){exit(1);}
if((gd.md.ch_MailRcptTo=(char*)calloc(BUF_SLEN, sizeof(char)))==NULL){exit(1);}
if((gd.md.ch_MailServ=(char*)calloc(BUF_SLEN, sizeof(char)))==NULL){exit(1);}
if((gd.md.ch_MailCc=(char*)calloc(BUF_SLEN, sizeof(char)))==NULL){exit(1);}

return 0;
}




int malloc_set2(void)
{
int count = 0;

if((gd.ms.fdstat=(int*)malloc(sizeof(int)*(gd.ms.max_count)))==NULL){exit(1);}
if((gd.ms.sk=(int*)malloc(sizeof(int)*(gd.ms.max_count)))==NULL){exit(1);}
if((gd.pt=(pthread_t *)malloc(sizeof(pthread_t)*(gd.ms.max_count)))==NULL){exit(1);}
if((gd.ms.inip_addr=(unsigned char**)malloc(sizeof(unsigned char*)*(gd.ms.max_count)))==NULL){exit(1);}

for(count = 0; count < gd.ms.max_count; count ++){
   gd.ms.fdstat[count] = 0;
   gd.ms.sk[count] = 0;
   gd.pt[count] = 0;
   if((gd.ms.inip_addr[count]=(unsigned char *)calloc(4, sizeof(unsigned char)))==NULL){exit(1);}
   }

return 0;
}





int private_malloc_set(private_data_t *pd)
{
int count = 0;

if((pd->getdata = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}

if((pd->rec.user = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->rec.user_org = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->rec.com = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->rec.data = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->rec.def_user = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->rec.info = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->rec.minfo = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->rec.tinfo = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->rec.ver = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}

if((pd->file.lock_filename = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->file.clock_filename = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->file.bat_filename = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->file.scan_filename = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->file.conf_filename = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->file.stat_filename = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}

if((pd->mail.server = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->mail.block = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->mail.from = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->mail.rcptto = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->mail.cc = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->mail.rcptto_org = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->mail.cc_org = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}

if((pd->life.swap1 = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->life.swap4 = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->life.bat_stat=(char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->life.scan_stat=(char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->life.conf_stat=(char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->life.stat_stat=(char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){exit(1);}
if((pd->life.in_life = (long int *)malloc(LIFE_HI * sizeof(long int)))==NULL){exit(1);}

for(count = 0; count < LIFE_HI; count++){
   pd->life.in_life[count] = 0; 
   }

pd->life.cancel = 0;

return 0;
}



int private_malloc_free(private_data_t *pd)
{

free(pd->getdata);

free(pd->rec.user);
free(pd->rec.user_org);
free(pd->rec.com);
free(pd->rec.data);
free(pd->rec.def_user);
free(pd->rec.info);
free(pd->rec.minfo);
free(pd->rec.tinfo);
free(pd->rec.ver);

free(pd->file.lock_filename);
free(pd->file.clock_filename);
free(pd->file.bat_filename);
free(pd->file.scan_filename);
free(pd->file.conf_filename);
free(pd->file.stat_filename);

free(pd->mail.server);
free(pd->mail.block);
free(pd->mail.from);
free(pd->mail.rcptto);
free(pd->mail.cc);
free(pd->mail.rcptto_org);
free(pd->mail.cc_org);

free(pd->life.swap1);
free(pd->life.swap4);
free(pd->life.bat_stat);
free(pd->life.scan_stat);
free(pd->life.conf_stat); 
free(pd->life.stat_stat);

free(pd->life.in_life);

return 0;
}



