// difference_on.c
// $Id: difference_on.c,v 1.1.1.1 2007/06/26 07:58:40 sendan Exp $
// masashi shimakura


#include<stdio.h>
#include<stdlib.h>

#include "almemsys.h"
#include "difference.h"



char * difference_on(char * difference_data, char * diff_filename, char * old_filename, int * ret, int len)
{
int diff_count, diff_stat, old_count, old_stat;
FILE * fp_old;
FILE * fp_diff;
char * swap_data;
char * old_data;
char * diff_data;

// バッファーのセット
* ret = 0;

diff_count = 0, diff_stat = 0, old_count = 0, old_stat = 0;

if((swap_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}
if((old_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}
if((diff_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}


// 編集前ファイルを一次元バッファーに入れる (OLD)
if((fp_old = fopen(old_filename, "r"))!=NULL){
   #ifdef ON_DEBUG_1
   fprintf(stderr,"difference_on(1): open old filename <%s>:\n", old_filename);
   #endif
   for(old_count = 0; old_count < len && old_stat > -1; old_count++){
      swap_data = safe_fpcat(fp_old, swap_data, &old_stat, MAX_BUFF_COUNT);
      old_data = safe_strncat(old_data, swap_data, MAX_BUFF_COUNT);
      old_data = safe_strncat(old_data, "\n", MAX_BUFF_COUNT);
      }
   fclose(fp_old);
   old_count = old_count - 1;
   }
else{
   #ifdef ON_DEBUG_1
   fprintf(stderr,"difference_on(2): old filename not open. <%s>:\n", old_filename);
   #endif
   free(swap_data);
   free(diff_data);
   free(old_data);
   difference_data = safe_memcpy(difference_data, "\n", MAX_BUFF_COUNT);
   * ret = -1;
   return (difference_data);
   }


// 差分ファイルを一次元バッファーに入れる (DIFF)
if((fp_diff = fopen(diff_filename, "r"))!=NULL){
   #ifdef ON_DEBUG_1
   fprintf(stderr,"difference_on(1): open diff filename <%s>:\n", diff_filename);
   #endif
   for(diff_count = 0; diff_count < len && diff_stat > -1; diff_count++){
      swap_data = safe_fpcat(fp_diff, swap_data, &diff_stat, MAX_BUFF_COUNT);
      diff_data = safe_strncat(diff_data, swap_data, MAX_BUFF_COUNT);
      diff_data = safe_strncat(diff_data, "\n", MAX_BUFF_COUNT);
      }
   fclose(fp_diff);
   diff_count = diff_count - 1;
   }
else{
   #ifdef ON_DEBUG_1
   fprintf(stderr,"difference_on(2): diff filename not open. <%s>:\n", diff_filename);
   #endif
   free(swap_data);
   free(diff_data);
   free(old_data);
   difference_data = safe_memcpy(difference_data, "\n", MAX_BUFF_COUNT);
   * ret = -1;
   return (difference_data);
   }

// 圧縮された差分を展開
diff_data = diff_uncomp(diff_data);

//printf("==%s==\n", diff_data);


// 差分と旧ファイルを結合し戻りバッファに書き込む
difference_data = diff_onset(difference_data, diff_data, old_data, ret, len);


// バッファーの開放
free(swap_data);
free(old_data);
free(diff_data);

return(difference_data);
}




