// scan_smtpport.c
// $Id: scan_smtpport.c,v 1.1.1.1 2007/06/26 07:58:40 sendan Exp $
// masashi shimakura

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<netdb.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<fcntl.h>

#include<sys/stat.h>
#include<errno.h>

#include "sitar_scan.h"
#include "sitar_com.h"
#include "almemsys.h"
#include "jpreturn.h"

// struct buf_data bd;


/* 1-> port No' 2-> Ipsddr 3-> return data,, return status code 0=open or=close
int scan_smtp_connect(int, char *, char *, int);
*/

char * set_smrequest(char *);
int check_smrecvdata(char *);


 

char * set_smrequest(char * backdata)
{

backdata = safe_sprintf(backdata, BUF_MAX, "HELO localhost\r\n");
#ifdef SMTP_BUG
printf("SMTP: set_smrequest(): %s", backdata);
#endif

return backdata;
}



int check_smrecvdata(char * recvdata)
{
int ret;
int max = 0;

max = (int)strlen(recvdata);

ret = -1;
if(max > 3){
   if(recvdata[0] == '2'){
      ret = 0;
      }
   else {
      ret = -1;
      } 
   }
else{
   ret = -1;
   }

return(ret);
}




/*----------------- SCAN TCP CONNECT --------------------*/
char * scan_smtp_connect(int port, char * url_dom, char * backdata, int timeout, int * pst)
{
int sk, re, ret;
char ipa[IP_LEN];
char * ip_addr = ipa;
struct sockaddr_in my_addr;
fd_set rfds;
struct timeval tv;
int retval;
int arglen = sizeof(int);
int dcount = 0;
char * recvdata = NULL;
char * senddata = NULL;

// struct buf_data bd;

ret = -1;
errno = 0;

if((recvdata = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}
if((senddata = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}

if((sk = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"scan_smtp URL=%s Port=%d tcp %s", url_dom, port, SOCK_1);
   backdata=safe_sprintf(backdata, BUF_MAX,
    "URL=%s Port=%d tcp %s", url_dom, port, SOCK_1);
   * pst = -1;
   free(recvdata);
   free(senddata);
   return backdata;
   }

my_addr.sin_family = AF_INET;
my_addr.sin_port = htons(port);
if((my_addr.sin_addr.s_addr = resolvename(url_dom,timeout))== (int)NULL){
   backdata=safe_sprintf(backdata,BUF_MAX,"%s %s %d\n",
    SOCK_2, url_dom, (int)my_addr.sin_addr.s_addr);
   close(sk);
   * pst = -1;
   free(recvdata);
   free(senddata);
   return backdata;
   }

ip_addr = inet_ntoa(my_addr.sin_addr);

fcntl(sk, F_SETFL, O_NONBLOCK);
re = connect(sk, (struct sockaddr *)(long int)&my_addr, sizeof(my_addr));

#ifdef SMTP_BUG
printf("SMTP: scan_smtp_connect(): %d %s %s %d\n", re, url_dom, ip_addr, port);
#endif

/* success */
if(re >= 0){
   #ifdef SMTP_BUG
   printf("SMTP: scan_smtp_connect(): CONNECT SUCCESS\n");
   #endif
   backdata=safe_sprintf(backdata,BUF_MAX,
    "URL=%s Port=%d %s", url_dom, port, SOCK_3);
   close(sk);
   * pst = 0;
   free(recvdata);
   free(senddata);
   return backdata;
   }


/* error EINPROGRESS */
if(errno == EINPROGRESS){
   tv.tv_sec = timeout;
   tv.tv_usec = 0;
   while(1){
      FD_ZERO(&rfds);
      FD_SET(sk, &rfds);
      retval = select(sk + 1, NULL, &rfds, NULL, &tv);
      if(retval == 0){
         #ifdef SMTP_BUG
         printf("SMTP: scan_smtp_connect(): select time out BREAK- %d -\n", retval);
         #endif
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_dom, port, SOCK_4);
         close(sk);
         * pst = -1;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      if(retval >= 1){
         #ifdef SMTP_BUG
         printf("SMTP: scan_smtp_connect(): select time succes BREAK- %d -\n", retval);
         #endif
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_dom, port, SOCK_3);
         break;
         }
      }

/* error */
   if(getsockopt(sk, SOL_SOCKET, SO_ERROR, (void *)&retval, (void *)&arglen) < 0){
      fprintf(stderr,"getsockopt() Errors!\n");
      }
   else{
      if(retval){
         #ifdef SMTP_BUG
         printf("SMTP: scan_smtp_connect(): 1 SO_ERROR %d -\n", retval);
         #endif
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d Error! %s", url_dom, port, SOCK_5);
         close(sk);
         * pst = -1;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_dom, port, SOCK_3);
         senddata = set_smrequest(senddata);
         #ifdef SMTP_BUG
         printf("SMTP: scan_smtp_connect(): set_request*send-- %s --\n", senddata);
         #endif 
         send(sk, senddata, strlen(senddata), 0);

         tv.tv_sec = timeout;
         tv.tv_usec = 0;
         while(1){
            FD_ZERO(&rfds);
            FD_SET(sk, &rfds);
            retval = select(sk + 1, &rfds, NULL, NULL, &tv);

            if(retval < 0){
               #ifdef SMTP_BUG
               printf("SMTP: scan_smtp_connect(): retval 0 ERR ===\n");
               #endif 
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s", url_dom, port, URL_2);
               close(sk);
               * pst = -1;
               free(recvdata);
               free(senddata);
               return backdata;
               }
            if(retval == 0){
               #ifdef SMTP_BUG
               printf("SMTP: scan_smtp_connect(): retval 1 ERR\n"); 
               #endif 
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s"
                , url_dom, port, URL_3);

               close(sk);
               * pst = -1;
               free(recvdata);
               free(senddata);
               return backdata;
               }
            if(retval >= 1){
               dcount = recv(sk, recvdata, BUF_LEN, 0);
               #ifdef SMTP_BUG
               printf("SMTP: scan_smtp_connect(): recv-- %s --\n", recvdata);
               #endif

               if(dcount < 1){
                  backdata = safe_sprintf(backdata,BUF_MAX,
                   "URL=%s Port=%d %s"
                   , url_dom, port, URL_2);
                  ret = -1;
                  }
               else{
                  ret = check_smrecvdata(recvdata);
                  #ifdef SMTP_BUG
                  printf("SMTP: scan_smtp_bug(): <2> %s\n", backdata);
                  #endif
                  }

               if(ret == -1){
                  backdata=safe_memcpy(backdata, recvdata, BUF_LEN);
                  }
               #ifdef SMTP_BUG
               printf("SMTP: scan_smtp_bug(): <2> %s %d\n", backdata, ret);
               #endif
               close(sk);
               * pst = ret;
               free(recvdata);
               free(senddata);
               return backdata;
               }
            }

         close(sk);
         * pst = ret;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      }
   }

backdata=safe_sprintf(backdata,BUF_MAX,
 "URL=%s Port=%d %s", url_dom, port, SOCK_3);

close(sk);
* pst = -1;

free(recvdata);
free(senddata);
return backdata;

}







