// scan_icmp.c
// $Id: scan_icmp.c,v 1.1.1.1 2007/06/26 07:58:40 sendan Exp $
// masashi shimakura

#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<sys/socket.h>
#include<sys/time.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<netinet/ip_icmp.h>
#include<arpa/inet.h>

#include<sys/stat.h> 
#include<sys/un.h>

#include "sitar_scan.h"
#include "sitar_com.h"
#include "almemsys.h"
#include "jpreturn.h"

/* 1-> Ipsddr 2-> return data,, return status code 0=open or=close */
/* int scan_icmp(char [], char *);
int make_icmp8_packet(struct icmp *, int, int);
int tvsub(struct timeval *, struct timeval *); 
u_short checksum(u_short *, int);
int scan_icmp(char [], char *, int);
*/



/* ------------ TVSUB --------------- */
int tvsub(struct timeval *out, struct timeval *in) 
{
if((out->tv_usec -= in->tv_usec) < 0){
   out->tv_sec--;
   out->tv_usec += 1000000;
   }
out->tv_sec -= in->tv_sec;
return 0;
}


/* ------------- CHECKSUM --------------- */
u_short checksum(u_short *data, int len)
{
// static long sum;
long sum;

sum = 0;
for(; len > 1; len -=2){
   sum += *data++;
   if(sum & 0x80000000){
      sum = (sum & 0xffff) + (sum >> 16);
      }
   }

if(len == 1){
   u_short i = 0; 
   *(u_char*)(&i) = *(u_char *)data;
   sum += i;
   }

while(sum >> 16){
   sum = (sum & 0xffff) + (sum >> 16);
   }

return ~sum;
}



/*--------------- MAKE ICMP8 PACKET --------------*/
int make_icmp8_packet(struct icmp *icmp, int len, int n)
{
memset((char *) icmp, 0, len);
gettimeofday((struct timeval *) (icmp->icmp_data), (struct timezone *) 0);

icmp->icmp_type = ICMP_ECHO;
icmp->icmp_code = 0;
icmp->icmp_id = 0;
icmp->icmp_seq = n;
icmp->icmp_cksum =0;
icmp->icmp_cksum = checksum((u_short *) icmp, len);

return 0;
}



/*----------------- SCAN ICMP --------------------*/
char * scan_icmp(char ip_addr[], char * backdata, int timeout, int * stat)
{
float rtt;
char send_buff[1024];
char recv_buff[1024];
int send_sk;
struct sockaddr_in send_addr;
struct timeval tv;
fd_set select_fd;
struct ip *ip;
int hlen;
int i =0;
rtt = 0.0;

memset((char *)&send_addr, 0, sizeof(struct sockaddr_in));
send_addr.sin_family = AF_INET;
/* send_addr.sin_addr.s_addr = inet_addr(ip_addr); */
send_addr.sin_addr.s_addr = resolvename(ip_addr,timeout);
if(0 == (int)send_addr.sin_addr.s_addr){
   backdata = safe_sprintf(backdata,BUF_MAX,
    "%s %s %d\n",
    SOCK_2, ip_addr, (int)send_addr.sin_addr.s_addr);
   #ifdef ICMP_BUG
   printf("ICMP: scan_icmp(): START %s\n", backdata);
   #endif
   * stat = -1;
   return backdata;
   }

#ifdef ICMP_BUG
printf("ICMP: scan_icmp(): ICMP ip_addr = %s\n", ip_addr);
#endif

/* SEND RAW SOCKET */
if((send_sk = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP)) < 0){
   backdata=safe_sprintf(backdata, BUF_MAX,
    "IP=%s %s", ip_addr, ICMP_1);
   #ifdef ICMP_BUG
   printf("ICMP: scan_icmp(): SOCKET CREATE %s\n", backdata);
   #endif
   * stat = -10;
   return backdata;
   }

make_icmp8_packet((struct icmp *)(long int)send_buff, 72, i);
if(sendto(send_sk, (char *)&send_buff, 72, 0, (struct sockaddr *)(long int)&send_addr, sizeof(send_addr)) < 0){
   backdata=safe_sprintf(backdata, BUF_MAX,"IP=%s %s",
    ip_addr, ICMP_2);
   #ifdef ICMP_BUG
   printf("ICMP: scan_icmp(): SEND RAW SOCKET %s\n", backdata);
   #endif
   close(send_sk);
   * stat = -10;
   return backdata;
   }

// tv.tv_sec = timeout;
// tv.tv_usec =(timeout * 100000);
// tv.tv_usec = 0;
tv.tv_sec = 0;
tv.tv_usec =(timeout * 100000);

while(1){
   FD_ZERO(&select_fd);
   FD_SET(send_sk, &select_fd);

   if(select(send_sk + 1, &select_fd, NULL, NULL, &tv) <= 0){
      break;
      }

   if(recvfrom(send_sk, recv_buff, 1024, 0, NULL, NULL) < 0){
      backdata=safe_sprintf(backdata, BUF_MAX,"IP=%s %s",
       ip_addr, ICMP_3);
      #ifdef ICMP_BUG
      printf("ICMP: RECV RAW SOCKET %s\n", backdata);
      #endif
      close(send_sk);
      * stat = -10;
      return backdata;
      } 

   ip = (struct ip *)(long int)recv_buff;
   hlen = ip->ip_hl << 2;

   if(ip->ip_src.s_addr == send_addr.sin_addr.s_addr){
      struct icmp *icmp;
      icmp = (struct icmp *)(long int)(recv_buff + hlen);
      /* OK */
      if(icmp->icmp_type == ICMP_ECHOREPLY){
         gettimeofday(&tv, (struct timezone *)0);
         tvsub(&tv, (struct timeval *)(icmp->icmp_data));
         rtt = tv.tv_sec * 1000.0 + tv.tv_usec / 1000.0;

         if(rtt > (timeout * 10)){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT=%7.4fms TIMEOUT=%dms %s",
               inet_ntoa(*(struct in_addr *)(long int)&(ip->ip_src.s_addr)), rtt, (timeout * 10), ICMP_5);
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(): RECV RAW DATA NG! %s\n",  backdata);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         if(rtt <= (timeout * 10)){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT=%7.4fms TIMEOUT=%dms %s",
               inet_ntoa(*(struct in_addr *)(long int)&(ip->ip_src.s_addr)), rtt, (timeout * 10), ICMP_6);
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(): RECV RAW DATA OK! %s\n", backdata);
            #endif
            close(send_sk);
            * stat = 0;
            return backdata;
            }

         }
      /* NG */
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT=%7.4fms %s",
            inet_ntoa(*(struct in_addr *)(long int)&(ip->ip_src.s_addr)),
            tv.tv_sec*1000.0 + tv.tv_usec/1000.0, ICMP_4);
         #ifdef ICMP_BUG
         printf("ICMP: scan_icmp(): RECV RAW DATA else %s\n", backdata);
         #endif
         close(send_sk);
         * stat = -1;
         return backdata;
         }
      }
   }


rtt = tv.tv_sec*1000.0 + tv.tv_usec/1000.0;
backdata=safe_sprintf(backdata,BUF_MAX,
 "IP=%s :RTT=%7.4fms %s", ip_addr, rtt, ICMP_3);
#ifdef ICMP_BUG
printf("ICMP: scan_icmp(): LAST %s\n", backdata);
#endif

close(send_sk);
* stat = -1;
return backdata;
}




