/*
 * $Id: Coordinate.java,v 1.2 2002/03/17 10:52:42 nie Exp $
 */

package jp.jasminesoft.gcat.scalc;

/** 
 * Coordinateは、座標系番号を受け取り、原点の緯度経度を返すクラスです。
 *
 * 本パッケージは、琉球大学工学部情報工学科 宮城研究室の成果物
 * を、ジャスミンソフトが整理・統合したものです。再利用を快諾
 * して頂いた宮城 隼夫教授以下、宮城研究室のスタッフにこの場を
 * 借りて感謝致します。
 * 
 * @version $Revision: 1.2 $ $Date: 2002/03/17 10:52:42 $
 * @author  Miho Nagata
 * @author  Yoshinori Nie
 */

class Coordinate {
    /**
     * 座標系原点の緯度
     */
    private double gentenB;

    /**
     * 座標系原点の経度
     */    
    private double gentenL;

    /*
     * コンストラクタ
     */
    Coordinate(int i){
	switch (i) {
	case 1:
	    gentenB = 330000.0;
	    gentenL = 1293000.0;
	    break;
	case 2:
	    gentenB = 330000.0;
	    gentenL = 1310000.0;
	    break;
	case 3:
	    gentenB = 360000.0;
	    gentenL = 1321000.0;
	    break;
	case 4:
	    gentenB = 330000.0;
	    gentenL = 1333000.0;
	    break;
	case 5:
	    gentenB = 360000.0;
	    gentenL = 1342000.0;
	    break;
	case 6:
	    gentenB = 360000.0;
	    gentenL = 1360000.0;
	    break;
	case 7:
	    gentenB = 360000.0;
	    gentenL = 1371000.0;
	    break;
	case 8:
	    gentenB = 360000.0;
	    gentenL = 1383000.0;
	    break;
	case 9:
	    gentenB = 360000.0;
	    gentenL = 1395000.0;
	    break;
	case 10:
	    gentenB = 400000.0;
	    gentenL = 1405000.0;
	    break;
	case 11:
	    gentenB = 440000.0;
	    gentenL = 1401500.0;
	    break;
	case 12:
	    gentenB = 440000.0;
	    gentenL = 1421500.0;
	    break;
	case 13:
	    gentenB = 440000.0;
	    gentenL = 1441500.0;
	    break;
	case 14:
	    gentenB = 260000.0;
	    gentenL = 1420000.0;
	    break;
	case 15:
	    gentenB = 260000.0;
	    gentenL = 1273000.0;
	    break;
	case 16:
	    gentenB = 260000.0;
	    gentenL = 1240000.0;
	    break;
	case 17:
	    gentenB = 260000.0;
	    gentenL = 1310000.0;
	    break;
	case 18:
	    gentenB = 200000.0;
	    gentenL = 1360000.0;
	    break;
	case 19:
	    gentenB = 260000.0;
	    gentenL = 1540000.0;
	    break;
	} 
    }

    /**
     * 座標系原点の緯度を返すメソッド
     */
    protected double getGB(){
	return gentenB;
    }

    /**
     * 座標系原点の経度を返すメソッド
     */
    protected double getGL(){
	return gentenL;
    }

    /**
     * 座標系原点の緯度（ラジアン）を返すメソッド
     */
    protected double radianGB(){
	Radians rb0 = new Radians(gentenB);
	return rb0.getRadian();
    }

    /**
     * 座標系原点の経度（ラジアン）を返すメソッド
     */
    protected double radianGL(){
	Radians rl0 = new Radians(gentenL);
	return rl0.getRadian();
    }

    /**
     * 座標系原点の緯度（度）を返すメソッド
     */
    protected double angleGB(){
	Radians ab0 = new Radians(gentenB);
	return ab0.getAngle();
    }
 
    /**
     * 座標系原点の経度（度）を返すメソッド
     */
    protected double angleGL(){
	Radians al0 = new Radians(gentenL);
	return al0.getAngle();
    }
}
