import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import web.WebUtilities;

/**
 * @author Kumano Tatsuo
 * 2005/11/14
 */
public class ZipTest {
	/**
	 * @param args
	 * @throws IOException 
	 * @throws ZipException 
	 */
	public static void main(String[] args) throws ZipException, IOException {
		final File file = new File("N03-11A-28-01.0a.zip");
		final ZipFile zipFile = new ZipFile(file);
		for (final Enumeration<? extends ZipEntry> enumeration = zipFile.entries(); enumeration
				.hasMoreElements();) {
			final ZipEntry entry = enumeration.nextElement();
			if (entry.getName().endsWith(".txt")) {
				WebUtilities.copy(zipFile.getInputStream(entry), new FileOutputStream(new File(
						entry.getName())));
			}
		}
	}
}
