// IMKit: An inputmethod adaptation library for Qtopia environment
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_3 $
// $Id: aux_keyhelper.h,v 1.1 2004/03/09 13:52:43 yamaken Exp $

// aux_keyhelper: An auxiliary keyfilter to cooperate with
// yakty-san's KeyHelperApplet. This enables KeyHelper to
// process key events precede IMKit. See following pages
// (written in Japanese).
//
// - homepage
//   http://yakty.s31.xrea.com/linuzau/keyhelper/
// 
// - key hook feature
//   http://yakty.s31.xrea.com/cgi-bin/wiki/linuzau/wiki.cgi?KeyHelperApplet%2f%a5%ad%a1%bc%a5%d5%a5%c3%a5%af%b5%a1%c7%bd

#ifndef IMKIT_AUX_KEYHELPER_H
#define IMKIT_AUX_KEYHELPER_H

#include <qobject.h>
#include "util.h"
#include "keyfilter.h"


class KeyHelperForwarder
  : public QObject, public CascadeKeyFilter, public StdActivatable
{
  Q_OBJECT

protected:
  virtual void on_activate(void);
  virtual void on_deactivate(void);
  virtual void on_input(QKeyEvent &e);
  virtual void forward(QKeyEvent &e);

public:
  KeyHelperForwarder(void);
  virtual ~KeyHelperForwarder(void);

public slots:
  virtual void slot_activate(bool activity);
};


#endif  // IMKIT_AUX_KEYHELPER_H
