// IMKit-uim: A Qtopia InputMethod interface for uim
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_3 $
// $Id: engine_uim.h,v 1.18 2004/04/14 12:04:28 yamaken Exp $

#ifndef IMKIT_ENGINE_UIM_H
#define IMKIT_ENGINE_UIM_H

#include <qtextcodec.h>
#include <qstring.h>
#include <uim/uim.h>
#include "keyfilter.h"
#include "engine.h"

class QTextCodec;
class UIMEngine;


class UIMCodeConverter {
protected:
  QString convert_to;
  QTextCodec *codec;
  void *fallback_converter;

private:
  UIMCodeConverter(void) {}

public:
  UIMCodeConverter(const QString &convert_to_init,
                   const QString &convert_from);
  ~UIMCodeConverter(void);
  char *convert(const char *str);

  static int is_natively_convertible(const char *tocode, const char *fromcode);
  static int is_convertible(const char *tocode, const char *fromcode);
  static void *create(const char *tocode, const char *fromcode);
  static char *convert(void *obj, const char *str);
  static void release(void *obj);
  static struct uim_code_converter *create_uim_if(void);
};


class UIMSegment : public Segment {
protected:
  int attr;  //UPreeditAttr
  QString qstr;

public:
  UIMSegment(int attr_init, const QString &qstr_init = "");
  virtual ~UIMSegment(void);
  virtual const QString &str(void);
  virtual Type type(void) const;
};


class UIMCandidate : public Candidate {
protected:
  QString qstr;

public:
  UIMCandidate(const QString &qstr_init = "");
  virtual ~UIMCandidate(void);
  virtual const QString &str(void);
};


class UIMEngine : public TranslationEngine {
  Q_OBJECT

protected:
  static uim_context global_uim_ctx;

protected:
  uim_context uim_ctx;
  Segments *segments;
  Candidates *candidates;

  //n2a stands for Native to Abstract
  BidirMap<int, InputMap> n2a_inputmap;
#if 0
  BidirMap<int, PreeditState> n2a_preedit_state;
#endif
  CommandMap *_command_map;
  const char *encoding;
  const char *_lang;
  char *_name;
  QString uim_engine_name;

protected:
  //callback interface to adapt to UIM API
  static void cb_commit(void *_this, const char *str);
  static void cb_clear(void *_this);
  static void cb_pushback(void *_this, int attr, const char *str);
  static void cb_update(void *_this);
  static void cb_set_mode(void *_this, int mode);
  static void cb_set_mode_list_update(void *_this);

  static void cb_candidate_win_activate(void *_this, int nr, int initial_index);
  static void cb_candidate_win_update_focus(void *_this, int index);
  static void cb_candidate_win_shift_page(void *_this, int direction);
  static void cb_candidate_win_deactivate(void *_this);

protected slots:
  //internal slots that receives UIM callbacks
  virtual void slot_commit(const char *str);
  virtual void slot_clear(void);
  virtual void slot_pushback(int attr, const char *str);
  virtual void slot_update(void);
  virtual void slot_set_mode(int mode);
  virtual void slot_set_mode_list_update(void);
  
  virtual void slot_candidate_win_activate(int nr, int initial_index);
  virtual void slot_candidate_win_update_focus(int index);
  virtual void slot_candidate_win_shift_page(int direction);
  virtual void slot_candidate_win_deactivate(void);

protected:
  virtual QStringList available_uim_ims(void);
  virtual QString indicated_uim_engine_name(void);
  virtual PreeditState preedit_state(void) const;
  virtual void init_state(void);
  virtual void free_state(void);
  virtual void init_segments(void);
  virtual void init_candidates(void);
  virtual void sync(void);
  virtual void update_inputmap(void);
  int get_im_index(const char *engine);

public:
  const QTextCodec *codec(void) const;

  UIMEngine(void);
  virtual ~UIMEngine(void);
  virtual const char *name(void) const;
  virtual const char *language(void) const;
  virtual InputMap map_state(void) const;
  virtual CommandMap *command_map(void);
  virtual void select_im(const char *lang = NULL, const char *engine = NULL);

  //commands
  void cmd_receive_keyevent(QKeyEvent &e);
  void cmd_select_map(InputMap new_map);

public slots:
  virtual void reset(void);
  virtual void input_str(const QString &str);
  virtual void input_char(QChar chr);
  virtual void select_im(InputMap nth);
  virtual void select_map(InputMap new_map);
  virtual void select_candidate(Candidates::size_type nth);
};

#endif  // IMKIT_ENGINE_UIM_H
