define qt-qstr2local
  #(QString)
end

define nl
  echo \n
end

define nlnl
  nl
  nl
end

define qt-inspect-qpoint
  #(QPoint)
  #printf "(%3d, %3d)", ($arg0).x(), ($arg0).y()
  printf "(%3d, %3d)", ($arg0).xp, ($arg0).yp
end

define qt-inspect-qsize
  #(QSize)
  #printf "(%3d, %3d)", ($arg0).width(), ($arg0).height()
  printf "(%3d, %3d)", ($arg0).wd, ($arg0).ht
end

define qt-inspect-qrect
  #(QRect)
  printf "{"
  qt-inspect-qpoint ($arg0).topLeft()
  printf ", "
  qt-inspect-qsize ($arg0).size()
  printf "}"
end

define qt-inspect-qwidget
  #(QWidget)
  printf "%s %s (%3d, %3d), (%3d, %3d) V=%d", \
    ($arg0).className(), ($arg0).name(), \
    ($arg0).x(), ($arg0).y(), ($arg0).width(), ($arg0).height(), \
    ($arg0).isVisible()
end

define qt-qevent-type
  #(QEvent *)
  printf "%s", ((($arg0).type() == KeyPress) ? "KeyPress" : \
                (($arg0).type() == KeyRelease) ? "KeyRelease" : \
                (($arg0).type() == Timer) ? "Timer" : \
                (($arg0).type() == MouseButtonPress) ? "MouseButtonPress" : \
                (($arg0).type() == MouseButtonRelease) ? "MouseButtonRelease" : \
                (($arg0).type() == MouseButtonDblClick) ? "MouseButtonDblClick" : \
                (($arg0).type() == MouseMove) ? "MouseMove" : \
                (($arg0).type() == KeyPress) ? "KeyPress" : \
                (($arg0).type() == KeyRelease) ? "KeyRelease" : \
                (($arg0).type() == FocusIn) ? "FocusIn" : \
                (($arg0).type() == FocusOut) ? "FocusOut" : \
                (($arg0).type() == Enter) ? "Enter" : \
                (($arg0).type() == Leave) ? "Leave" : \
                (($arg0).type() == Paint) ? "Paint" : \
                (($arg0).type() == Move) ? "Move" : \
                (($arg0).type() == Resize) ? "Resize" : \
                (($arg0).type() == Create) ? "Create" : \
                (($arg0).type() == Destroy) ? "Destroy" : \
                (($arg0).type() == Show) ? "Show" : \
                (($arg0).type() == Hide) ? "Hide" : \
                (($arg0).type() == Close) ? "Close" : \
                (($arg0).type() == Quit) ? "Quit" : \
                (($arg0).type() == Reparent) ? "Reparent" : \
                (($arg0).type() == ShowMinimized) ? "ShowMinimized" : \
                (($arg0).type() == ShowNormal) ? "ShowNormal" : \
                (($arg0).type() == WindowActivate) ? "WindowActivate" : \
                (($arg0).type() == WindowDeactivate) ? "WindowDeactivate" : \
                (($arg0).type() == ShowToParent) ? "ShowToParent" : \
                (($arg0).type() == HideToParent) ? "HideToParent" : \
                (($arg0).type() == ShowMaximized) ? "ShowMaximized" : \
                (($arg0).type() == Accel) ? "Accel" : \
                (($arg0).type() == Wheel) ? "Wheel" : \
                (($arg0).type() == AccelAvailable) ? "AccelAvailable" : \
                (($arg0).type() == CaptionChange) ? "CaptionChange" : \
                (($arg0).type() == IconChange) ? "IconChange" : \
                (($arg0).type() == ParentFontChange) ? "ParentFontChange" : \
                (($arg0).type() == ApplicationFontChange) ? "ApplicationFontChange" : \
                (($arg0).type() == ParentPaletteChange) ? "ParentPaletteChange" : \
                (($arg0).type() == ApplicationPaletteChange) ? "ApplicationPaletteChange" : \
                (($arg0).type() == Clipboard) ? "Clipboard" : \
                (($arg0).type() == Speech) ? "Speech" : \
                (($arg0).type() == SockAct) ? "SockAct" : \
                (($arg0).type() == AccelOverride) ? "AccelOverride" : \
                (($arg0).type() == DragEnter) ? "DragEnter" : \
                (($arg0).type() == DragMove) ? "DragMove" : \
                (($arg0).type() == DragLeave) ? "DragLeave" : \
                (($arg0).type() == Drop) ? "Drop" : \
                (($arg0).type() == DragResponse) ? "DragResponse" : \
                (($arg0).type() == ChildInserted) ? "ChildInserted" : \
                (($arg0).type() == ChildRemoved) ? "ChildRemoved" : \
                (($arg0).type() == LayoutHint) ? "LayoutHint" : \
                (($arg0).type() == ShowWindowRequest) ? "ShowWindowRequest" : \
                (($arg0).type() == ActivateControl) ? "ActivateControl" : \
                (($arg0).type() == DeactivateControl) ? "DeactivateControl" : \
                (($arg0).type() == User) ? "User" : \
                "unknown")
end

define qt-inspect-qevent
  #(QEvent *)
  if (($arg0).type() == KeyPress || ($arg0).type() == KeyRelease)
    qt-inspect-qkeyevent ($arg0)
  else
  if (($arg0).type() == Paint)
    qt-inspect-qpaintevent ($arg0)
  else
  if (($arg0).type() == Move)
    qt-inspect-qmoveevent ($arg0)
  else
  if (($arg0).type() == Resize)
    qt-inspect-qresizeevent ($arg0)
  else
    echo Q
    qt-qevent-type $arg0
    echo Event
  end
  end
  end
  end
end

define qt-inspect-qkeyevent
  #(QEvent *)
  # type: KeyPress = 6, KeyRelease = 7
  set $tmp = (QKeyEvent *)&($arg0)

  printf "QKeyEvent "

  printf "type="
  qt-qevent-type *$tmp

  printf ", key=%02x, ascii=%02x, ", $tmp->key(), $tmp->ascii()

  printf "text=\""
  qt-qstr2local $tmp->text()
  printf "\", "

  printf "accept=%d, repeat=%d", \
    (int)$tmp->isAccepted(), (int)$tmp->isAutoRepeat()

  #printf ", count=%d", $tmp->count()
end

define qt-inspect-qpaintevent
  #(QEvent *)
  # type: Paint = 12
  set $tmp = (QPaintEvent *)&($arg0)

  printf "QPaintEvent "

  printf "rect="
  qt-inspect-qrect $tmp->rect()

  #TODO: $arg0->region()
end

define qt-inspect-qmoveevent
  #(QEvent *)
  # type: Move = 13
  set $tmp = (QMoveEvent *)&($arg0)

  printf "QMoveEvent "

  qt-inspect-qpoint $tmp->oldp
  printf " -> "
  qt-inspect-qpoint $tmp->p
end

define qt-inspect-qresizeevent
  #(QEvent *)
  # type: Resize = 14
  set $tmp = (QResizeEvent *)&($arg0)

  printf "QResizeEvent "

  qt-inspect-qsize $tmp->olds
  printf " -> "
  qt-inspect-qsize $tmp->s
end

break QWidget::event(QEvent *) if !strcmp(this->name(), "CandidateWindow")
commands
  silent
  qt-inspect-qevent *e
  nl
  cont
end
