<?php
// $Id: GoogleplusAuth.class.php,v 1.1 2011/12/15 03:09:46 ohwada Exp $

//================================================================
// GooglePlus Plugin of Exauth Module
// 2011-12-12 K.OHWADA
//================================================================

/**#@+ load classes */
require_once XOOPS_ROOT_PATH . '/modules/exauth/class/AbstractAuth.class.php';
require_once XOOPS_ROOT_PATH . '/modules/exauth/class/Error.class.php';
require_once XOOPS_ROOT_PATH . '/modules/exauth/class/ApplyIDFIlter.class.php';

/**
 * googleplus service library
 */
require_once XOOPS_ROOT_PATH . '/modules/googleplus/class/googleplus_xoops_service.class.php';

//================================================================
// class Exauth_GoogleplusAuth
//================================================================
class Exauth_GoogleplusAuth extends Exauth_AbstractAuth
{
	var $_service = null;

    /**
     * Constructor
     */
    function Exauth_GoogleplusAuth($exauth, $config)
    {
        parent::Exauth_AbstractAuth($exauth, $config);

		$this->_service =& new googleplus_xoops_service();
		$this->_service->init();
    }

    /**
     * @return string
     */
    function getAuthIDName()
    {
        return 'Googleplus';
    }

    /**
     * @return bool
     */
    function isActive()
    {
		return true;
    }

    /**
     * @param array &$option [out] set external authentication options
     * @return string external user name
     */
// XOOPS Cube : exauth/preload/ExLogin.class.php _getExUserObject()
    function getUser(&$option) 
    {
		$param = $this->_service->callback();
		if ( !is_array($param) ) {
			$msg  = _MD_EXAUTH_GOOGLEPLUS_FAILED ;
			$msg .= $this->_service->get_error_msg();
            return new Exauth_Error( $msg );
		}

		$id    = $param['user_id'] ;
		$token = $param['token'] ;

        $option['__obj']['token']  = $token;

        return array(
			'identifier' => $id, 
			'token'      => $token ,
		);
    }

    /**
     * @param array &$assign_vars [out] set smarty assign variables
     * @return string Template file
     */
    function executePreLoginView(&$assign_vars)
    {
        $step = $this->_getrequest('step');

		$googleplus = $this->_getrequest('googleplus_identifier');

        if (defined('XOOPS_CUBE_LEGACY')) {
            $assign_vars['login_url'] = XOOPS_URL . '/user.php';
        } else {
            $assign_vars['login_url'] = XOOPS_URL . '/modules/exauth/prelogin.php';
        }

       if ( $step == 2 ) {

			$ret = $this->_service->login();
			if ( !$ret ) {
				$msg  = _MD_EXAUTH_GOOGLEPLUS_FAILED;
				$msg .= $this->_service->get_error_msg();
            	$assign_vars['err_mes'] = $msg ;
            	return 'exauth_googleplus_pv.html';
			}
			return true;

        } else {
            return 'exauth_googleplus_pv.html';
        }
    }

    /**
     * @param string &$exuser
     * @param array &$option
     */
// XOOPS Cube : exauth/preload/ExLogin.class.php checkLogin()
    function setUserSetting(&$exuser, &$option)
    {
    	$exuser->setVar('googleplus_token',  $option['__obj']['token'],  true);
    }

// === class end ===
}
