<?php
// $Id: View.class.php,v 1.1.1.1 2009/03/31 10:21:38 ohwada Exp $

//=========================================================
// Googlesearch Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlesearch取得コンポーネント
 *
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Googlesearch_Components_View
{
	/**
	 * @var DIコンテナを保持
	 *
	 * @access	private
	 */
	var $_container = null;

	/**
	 * @var DBオブジェクトを保持
	 *
	 * @access	private
	 */
	var $_db = null;

	/**
	 * @var Requestオブジェクトを保持
	 *
	 * @access	private
	 */
	var $_request = null;

	/* session  */
	var $_session = null;

	/**
	 * コンストラクター
	 *
	 * @access	public
	 */
	function Googlesearch_Components_View()
	{
		$this->_container =& DIContainerFactory::getContainer();
		$this->_db        =& $this->_container->getComponent("DbObject");
		$this->_request   =& $this->_container->getComponent("Request");
		$this->_session   =& $this->_container->getComponent("Session");
	}

	/**
	 * Googlesearchが存在するか判断する
	 *
     * @return boolean	true:存在する、false:存在しない
	 * @access	public
	 */
	function googlesearchExists() 
	{
		$params = array(
			$this->_request->getParameter("parts_id")
		);
		$sql = "SELECT parts_id ".
				"FROM {googlesearch_parts} ".
				"WHERE parts_id = ? ";
		$googlesearchIDs = $this->_db->execute($sql, $params);
		if ($googlesearchIDs === false) {
			$this->_db->addError();
			return $googlesearchIDs;
		}
		
		if (count($googlesearchIDs) > 0) {
			return true;
		}

		return false;
	}

	/**
	 * Googlesearchのpartsレコード件数を取得する
	 *
     * @return string	Googlesearch件数
	 * @access	public
	 */
	function getGooglesearchCount() 
	{
		$count = $this->_db->countExecute("googlesearch_parts");
		return $count;
	}

	/**
	 * 現在配置されているGooglesearchIDを取得する
	 *
     * @return string	配置されているGooglesearchID
	 * @access	public
	 */
	function &getCurrentGooglesearchID() 
	{
		$params = array($this->_request->getParameter("block_id"));		
		$sql = "SELECT parts_id ".
				"FROM {googlesearch_block} ".
				"WHERE block_id = ?";
		$googlesearchIDs = $this->_db->execute($sql, $params);
		if ($googlesearchIDs === false) {
			//errorメッセージを追加
			$this->_db->addError();
			return $googlesearchIDs;
		}

		return $googlesearchIDs[0]["parts_id"];
	}

	/**
	 * Googlesearchのpartsレコード一覧を取得する
	 *
     * @return array	Googlesearch一覧データ配列
	 * @access	public
	 */
	function &getGooglesearchList() 
	{
		$sortColumn = $this->_request->getParameter("sort_col");
		if (empty($sortColumn)) {
			$sortColumn = "parts_id";
		}
		$sortDirection = $this->_request->getParameter("sort_dir");
		if (empty($sortDirection)) {
			$sortDirection = "DESC";
		}
		$orderParams[$sortColumn] = $sortDirection;

// 一覧を取得する
		$sql = "SELECT * ".
				"FROM {googlesearch_parts} ".
				$this->_db->getOrderSQL($orderParams);
		$rows = $this->_db->execute($sql);
		if ($rows === false) {
			$this->_db->addError();
			return false;
		}

// 編集権限を追加する
		$ret = array();
		foreach ($rows as $row) 
		{
			$row['has_edit_auth'] = $this->hasEditAuthority( $row['insert_user_id'] );
			$ret[] = $row;
		}

		return $ret;
	}

	/**
	 * Googlesearchのblockのカレントレコードを取得する
	 *
     * @return string	partsデータ配列
	 * @access	public
	 */
	function getCurPartsData()
	{
		$id = $this->_request->getParameter("block_id");
		return $this->getCurPartsDataByBlockId( $id );
	}
	function getCurPartsDataByBlockId( $id )
	{
		$arr = $this->getCurPartsDataArrayByBlockId( $id );
		if( isset($arr[0]) ){
			return $arr[0];
		}
		return false;
	}
	function getCurPartsDataArrayByBlockId( $id )
	{
		$sql = "SELECT P.* ".
				"FROM {googlesearch_parts} P ".
				"INNER JOIN {googlesearch_block} B ".
				"ON B.parts_id = P.parts_id ".
				"WHERE B.block_id = ? ";
		$params = array( $id );
		$result = $this->_db->execute($sql, $params);
		if ($result === false) {
			$this->_db->addError();
			return false;
		}
		return $result;
	}

	/**
	 * Googlesearchのpartsレコードを取得する
	 *
     * @return array	partsデータ配列
	 * @access	public
	 */
	function getPartsData()
	{
		$id = $this->_request->getParameter("parts_id");
		return $this->getPartsDataByPartsId( $id );
	}
	function getPartsDataByPartsId( $id )
	{
		$arr = $this->getPartsDataArrayByPartsId( $id );
		if( isset($arr[0]) ){
			return $arr[0];
		}
		return false;
	}
	function getPartsDataArrayByPartsId( $id )
	{
		$sql = "SELECT * ".
				"FROM {googlesearch_parts} ".
				"WHERE parts_id= ? ";
		$params = array( $id );
		$result = $this->_db->execute($sql, $params);
		if ($result === false) {
			$this->_db->addError();
			return false;
		}
		return $result;
	}

	/**
	 * Googlesearchの初期値を取得する
	 *
     * @return array	partsデータ配列
	 * @access	public
	 */
	function getPartsDataDefaultCreate()
	{
// refer whatsnew/components/View.class
		$meta     = $this->_session->getParameter("_meta");
		$sitename = $meta["sitename"];

		$arr = array(
			'site_use'         => GOOGLESEARCH_DEFAULT_SITE_USE ,
			'site_label'       => $sitename ,
			'site_restriction' => BASE_URL.'/' ,
			'site_expand'      => GOOGLESEARCH_DEFAULT_SITE_EXPAND ,
			'web_use'          => GOOGLESEARCH_DEFAULT_WEB_USE ,
			'search_draw'      => GOOGLESEARCH_DEFAULT_SEARCH_DRAW ,
			'search_execute'   => '' ,
		);
		return $arr;
	}

	/**
	 * 編集権限を取得する
	 *
	 * @param	array	$insetUserID	登録者ID
	 * @return boolean	true:権限有り、false:権限無し
	 * @access	public
	 */
	function hasEditAuthority( $inset_user_id )
	{
		$session  =& $this->_container->getComponent("Session");
		$_user_id = $session->getParameter("_user_id");
		$_auth_id = $session->getParameter("_user_auth_id");

// 投稿者 あるいは 管理者
		if ($inset_user_id == $_user_id || $_auth_id == _AUTH_ADMIN) {
			return true;
		}
	    return false;
	}

	/**
	 * Config テーブルのデータを取得する
	 *
     * @return array	データ配列
	 * @access	public
	 */
	function getConfig( $module_id ) 
	{
		$configView =& $this->_container->getComponent("configView");
		$config = $configView->getConfig($module_id, false);
		if ($config === false) {
    		return false;
    	}
    	$arr = array(
    		'list_row_count' => $config['list_row_count']['conf_value'],
			'apikey'         => $config['apikey']['conf_value']
		);	
		return $arr;
	}
}
?>