<?php
// $Id: handler.php,v 1.1.1.1 2008/02/09 06:46:14 ohwada Exp $

//=========================================================
// Google PageRank Module
// 2008-02-06 K.OHWADA
//=========================================================

//=========================================================
// class gpagerank_handler
//=========================================================
class gpagerank_handler extends gpagerank_error
{
	var $_db;
	var $_table;

	var $_id        = 0;
	var $_xoops_uid = 0;
	var $_cached    = array();

	var $_DEBUG_SQL   = _GPAGERANK_C_DEBUG_SQL;
	var $_DEBUG_ERROR = _GPAGERANK_C_DEBUG_ERROR;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function gpagerank_handler()
{
	$this->gpagerank_error();
	$this->_db =& Database::getInstance();
}

function set_table( $name )
{
	$this->_table = $this->_db->prefix( $name );
}

function get_id()
{
	return $this->_id;
}

//---------------------------------------------------------
// basic function
//---------------------------------------------------------
function delete( &$row )
{
	foreach ($row as $k => $v) 
	{	${$k} = $v;	}

	return $this->delete_by_id( $id );
}

function delete_by_id( $id )
{
	$sql  = 'DELETE FROM '. $this->_table;
	$sql .= ' WHERE id='.intval($id);
	return $this->query( $sql );
}

function get_count_all()
{
	$sql  = 'SELECT count(*) FROM '.$this->_table;
	return $this->get_count_by_sql( $sql );
}

function &get_row_by_id( $id )
{
	$sql  = 'SELECT * FROM '.$this->_table;
	$sql .= ' WHERE id='. intval($id);
	return $this->get_row_by_sql( $sql );
}

function &get_rows_all_asc( $limit=0, $offset=0, $key=null )
{
	$sql  = 'SELECT * FROM '.$this->_table;
	$sql .= ' ORDER BY id ASC';
	return $this->get_rows_by_sql( $sql, $limit, $offset, $key );
}

function &get_rows_all_desc( $limit=0, $offset=0, $key=null )
{
	$sql  = 'SELECT * FROM '.$this->_table;
	$sql .= ' ORDER BY id DESC';
	return $this->get_rows_by_sql( $sql, $limit, $offset, $key );
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function &get_count_by_sql( $sql )
{
	$count = intval( $this->get_first_row_by_sql( $sql ) );
	return $count;
}

function &get_first_row_by_sql( $sql )
{
	$res =& $this->query($sql);
	if ( !$res )
	{	return $res;	}
	$row = $this->_db->fetchRow( $res );
	$ret =& $row[0];
	return $ret;
}

function &get_row_by_sql( $sql )
{
	$res =& $this->query( $sql );
	if ( !$res )
	{	return $res;	}
	$row = $this->_db->fetchArray($res);
	return $row; 
}

function &get_rows_by_sql( $sql, $limit=0, $offset=0, $key=null )
{
	$arr = array();

	$res =& $this->query( $sql, $limit, $offset );
	if ( !$res )
	{	return $res;	}

	while ( $row = $this->_db->fetchArray($res) ) 
	{
		if ( $key && isset( $row[ $key ] ) ) 
		{
			$arr[ $row[ $key ] ] = $row;
		}
		else 
		{
			$arr[] = $row;
		}
	}
	return $arr; 
}

function &get_first_rows_by_sql( $sql, $limit=0, $offset=0 )
{
	$res =& $this->query( $sql, $limit, $offset );
	if ( !$res )
	{	return $res;	}

	$arr = array();

	while ( $row = $this->_db->fetchRow($res) ) 
	{
		$arr[] = $row[0];
	}
	return $arr;
}

function &query( $sql, $limit=0, $offset=0 )
{
	if ( $this->_DEBUG_SQL )
	{
		echo $this->sanitize( $sql ) .': limit='. $limit .' :offset='. $offset. "<br />\n";
	}

	$res = $this->_db->query( $sql, intval($limit), intval($offset) );
	if ( !$res ) 
	{
		$error = $this->_db->error();
		$this->set_error( $error );

		if ( $this->_DEBUG_ERROR )
		{
			echo $this->highlight( $this->sanitize( $error ) )."<br />\n";
		}
	}
	return $res;
}

function &queryF( $sql, $limit=0, $offset=0 )
{
	if ( $this->_DEBUG_SQL )
	{
		echo $this->sanitize( $sql )."<br />\n";
	}

	$res = $this->_db->queryF( $sql, intval($limit), intval($offset) );
	if ( !$res ) 
	{
		$error = $this->_db->error();
		$this->set_error( $error );

		if ( $this->_DEBUG_ERROR )
		{
			echo $this->highlight( $this->sanitize( $error ) )."<br />\n";
		}
	}
	return $res;
}

function quote( $str )
{
	$str = "'". addslashes($str) ."'";
	return $str;
}

//---------------------------------------------------------
// sql
//---------------------------------------------------------
// MySQL 5 requires the negotiation of the character code
function set_mysql_charset( $charset, $force=false )
{
	if ( ( $this->is_mysql_ver5() || $force ) && $charset )
	{
		$sql = 'SET NAMES ' . $charset;
		$this->query( $sql );
	}
}

function &get_mysql_variables()
{
	$sql = "SHOW VARIABLES LIKE 'char%'";
	$res =& $this->_db->queryF( $sql );
	if ( !$res )
	{	return $res;	}

	$arr =array();
	while ( $row = $this->_db->fetchRow($res) )
	{
		$arr[ $row[0] ] = $row[1];
	}
	return $arr;
}

function is_mysql_ver5()
{
	$ver = mysql_get_server_info();
	if ( preg_match("/^4\.1/", $ver) ) 
	{
		return true;
	}
	if ( preg_match("/^5\./", $ver) ) 
	{
		return true;
	}
	return false;
}

//----- class end -----
}

?>