<?php
// $Id: dir.php,v 1.1 2007/06/17 03:20:44 ohwada Exp $

// 2007-06-10 K.OHWADA
// divid from file.php

// 2006-10-01 K.OHWADA
// this is new file

//=========================================================
// Happy Linux Framework Module
// 2006-10-01 K.OHWADA
//=========================================================

//=========================================================
// class happy_linux_dir
//=========================================================
//---------------------------------------------------------
// this class operate under XOOPS_ROOT_PATH
// this class has one resource handle
//---------------------------------------------------------

class happy_linux_dir extends happy_linux_error
{
	var $_dh = null;
	var $_dir_name  = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_dir()
{
	$this->happy_linux_error();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_linux_dir();
	}
	return $instance;
}

//---------------------------------------------------------
// basic function
//---------------------------------------------------------
function opendir( $dirname=null )
{
	$this->_dh = null;

	if ( empty($dirname) )
	{
		$dirname = $this->_dir_name;
	}

	if ( !$this->check_dirname( $dirname ) )
	{
		return false;
	}

	$xoops_dir = XOOPS_ROOT_PATH.'/'.$dirname;

// add '/' to tail
	if (substr($dirname, -1) != '/') 
	{
		$xoops_dir .= '/';
	}

	if ( !is_dir($xoops_dir) ) 
	{
		$this->_set_errors( "not directory: ".$xoops_dir );
		return false;
	}

	$dh = opendir($xoops_dir);
	if ( !$dh )
	{
		$this->_set_errors( "cannot open directory: ".$xoops_dir );
		return false;
	}

	$this->_dh =& $dh;
	$this->_dir_name = $dirname;
	return true;
}

function closedir()
{
	if ( $this->_dh )
	{
		$ret = closedir($this->_dh);
		if ( !$ret )
		{
			$this->_set_errors( "cannot close directory: ".$this->_dir_name );
			return false;	// NG
		}
	}
	return true;
}

function &readdir_array()
{
	$arr = array();
	while ( false !== ($file = readdir($this->_dh)) )
	{
		$arr[] = $file;
	}
	return $arr;
}

function readdir()
{
	return readdir($this->_dh);
}

function check_dirname( $dirname )
{
// check directory travers
	if ( preg_match("|\.\./|", $dirname) )
	{
		$this->_set_errors( "illegal directory name: ".$dirname );
		return false;
	}
	return true;
}

function set_dir_name( $val )
{
	$this->_dir_name = $val;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function &get_files_in_dir($dirname, $ext=null, $flag_dir=false, $flag_sort=false )
{
	$arr   = array();
	$false = false;

// strip last '/'
	if (substr($dirname, -1) == '/') 
	{
		$dirname = substr($dirname, 0, -1);
	}

	$ret = $this->opendir($dirname);
	if ( !$ret )
	{
		return $false;
	}

	$pattern = "/\.". preg_quote($ext) ."$/";

	foreach ( $this->readdir_array() as $file ) 
	{
		$xoops_file = XOOPS_ROOT_PATH .'/'. $dirname .'/'. $file;

		if ( !is_dir($xoops_file) && is_file($xoops_file) )
		{
			if (( $ext && preg_match($pattern, $file) )||( $ext === '' ))
			{
				$file_out = $file;
				if ( $flag_dir )
				{
					$file_out = $dirname .'/'. $file;
				}
				$arr[] = $file_out;
			}
		}
	}

	$this->closedir();

	if ( $flag_sort )
	{
		asort($arr);
		reset($arr);
	}

	return $arr;
}

//----- class end -----
}

?>