<?
//===============================================
// test_module.textsanitizer.php
// 2005-08-18 K.OHWADA
//===============================================

include 'mainfile.php';
include 'header.php';

$myts =& MyTextSanitizer::getInstance();

$url_1    = 'http://jp.xoops.org/images/logo.gif';
$text_1_1 = "[img]".$url_1."[/img]";
$text_1_2 = '[img align="left"]'.$url_1."[/img]<br />abcdef<br />";
$text_1_3 = "[img align='center']".$url_1."[/img]<br />abcdef<br />";
$text_1_4 = "[img align=right]".$url_1."[/img]<br />abcdef<br />";
$text_1_5 = "[img id=1]image1[/img]";
$text_1_6 = "[img align=\"right\" id='1']image1[/img]<br />abcdef<br />";

$text_1_7 = "[img]".$url_1.",120[/img]";
$text_1_8 = "[img]".$url_1.",120,111[/img]";
$text_1_9 = '[img align="left"]'.$url_1.",120[/img]<br />abcdef<br />";
$text_1_10 = '[img align="right"]'.$url_1.",120,111[/img]<br />abcdef<br />";

$url_2    = 'images/logo.gif';
$text_2_1 = "[siteimg]".$url_2."[/siteimg]";
$text_2_2 = '[siteimg align="left"]'.$url_2."[/siteimg]<br />abcdef<br />";
$text_2_3 = "[siteimg align='center']".$url_2."[/siteimg]<br />abcdef<br />";
$text_2_4 = "[siteimg align=right]".$url_2."[/siteimg]<br />abcdef<br />";
$text_2_5 = "[siteimg]".$url_2.",120[/siteimg]";
$text_2_6 = "[siteimg]".$url_2.",120,111[/siteimg]";
$text_2_7 = '[siteimg align="left"]'.$url_2.",120[/siteimg]<br />abcdef<br />";
$text_2_8 = '[siteimg align="right"]'.$url_2.",120,111[/siteimg]<br />abcdef<br />";

$url_3 = 'http://jp.xoops.org/images/banners/banner.swf';
$text_3_1 = "[flash]".$url_3."[/flash]";
$text_3_2 = "[flash]".$url_3.",120[/flash]";
$text_3_3 = "[flash]".$url_3.",120,111[/flash]";

echo "<h1>Test of module.textsanitizer.php</h3>\n";
echo "<h3>img standard</h3>\n";

print_text("case 1", $text_1_1);
print_text("case 2", $text_1_2);
print_text("case 3", $text_1_3);
print_text("case 4", $text_1_4);
print_text("case 5", $text_1_5);
print_text("case 6", $text_1_6);

echo "<h3>img not allow</h3>\n";

print_text("case 7", $text_1_1, 0);
print_text("case 8", $text_1_2, 0);
print_text("case 9", $text_1_5, 0);
print_text("case 10", $text_1_6, 0);

echo "<hr>\n";
echo "<h3>img new</h3>\n";

print_text("case 11", $text_1_7);
print_text("case 12", $text_1_8);
print_text("case 13", $text_1_9);
print_text("case 14", $text_1_10);

echo "<h3>img new not allow</h3>\n";

print_text("case 15", $text_1_7, 0);
print_text("case 16", $text_1_8, 0);
print_text("case 17", $text_1_9, 0);
print_text("case 18", $text_1_10, 0);

echo "<hr>\n";
echo "<h3>siteimg new</h3>\n";

print_text("case 1", $text_2_1);
print_text("case 2", $text_2_2);
print_text("case 3", $text_2_3);
print_text("case 4", $text_2_4);
print_text("case 5", $text_2_5);
print_text("case 6", $text_2_6);
print_text("case 7", $text_2_7);
print_text("case 8", $text_2_8);

echo "<h3>siteimg new not allow</h3>\n";

print_text("case 9", $text_2_1, 0);
print_text("case 10", $text_2_2, 0);
print_text("case 11", $text_2_5, 0);
print_text("case 12", $text_2_6, 0);
print_text("case 13", $text_2_7, 0);
print_text("case 14", $text_2_8, 0);

echo "<hr>\n";
echo "<h3>flash new</h3>\n";

print_text("case 1", $text_3_1);
print_text("case 2", $text_3_2);
print_text("case 3", $text_3_3);

include 'footer.php';

function print_text($title, $text, $allowimage=1)
{
	global $myts;

	$text_2 = $myts->xoopsCodeDecode($text, $allowimage);
	$text_3 = htmlspecialchars($text_2);

	echo "<h4>$title</h4>\n";
	echo "<table><tr><td>\n";
	echo "$text <br /><br />\n";
	echo "$text_3 <br /><br />\n";
	echo "$text_2 <br />\n";
	echo "</td></tr></table>\n";
}

?>