<?php
// $Id: remote_file.php,v 1.2 2006/09/11 07:41:48 ohwada Exp $

// 2006-09-01 K.OHWADA
// change constant value

// 2006-07-10 K.OHWADA
// this is new file
// porting from rssc_remote_file.php

//=========================================================
// Happy Linux Framework Module
// 2006-07-10 K.OHWADA
//=========================================================

//---------------------------------------------------------
// define constant
//---------------------------------------------------------
define('HAPPY_LINUX_REMOTE_CODE_EMPTY_URL',  11);
define('HAPPY_LINUX_REMOTE_CODE_NOT_FOPEN',  12);
define('HAPPY_LINUX_REMOTE_CODE_NOT_FCLOSE', 13);
define('HAPPY_LINUX_REMOTE_CODE_NOT_FWRITE', 14);
define('HAPPY_LINUX_REMOTE_CODE_NO_RESULT',  15);

define('HAPPY_LINUX_SNOPPY_CODE_NOT_FETCH',  17);
define('HAPPY_LINUX_SNOPPY_CODE_NO_RESULT',  18);

//=========================================================
// class happy_linux_remote_file
// use class snoopy
//=========================================================
class happy_linux_remote_file extends happy_linux_error
{
// class instance
	var $_snoopy;

// file pointer
	var $_fp;

// variable
	var $_flag_allow_url_fopen;
	var $_error_code = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_remote_file()
{
	$this->happy_linux_error();

// class instance
	$this->_snoopy = new Snoopy();

// allow_url_fopen
	$this->_flag_allow_url_fopen = ini_get('allow_url_fopen');

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_linux_remote_file();
	}

	return $instance;
}


//---------------------------------------------------------
// check_url
//---------------------------------------------------------
function check_url($url)
{
	$this->_clear_errors();

	if ( empty($url) )
	{
		$this->_set_error_code( HAPPY_LINUX_REMOTE_CODE_EMPTY_URL );
		$this->_set_errors( "remote url is empty" );
		return false;
	}

// allow_url_fopen
	if ( $this->_flag_allow_url_fopen )
	{
		$ret = $this->_check_url_local( $url );
		return $ret;
	}
// not allow_url_fopen
	else
	{
		$ret = $this->_check_url_remote( $url );
		return $ret;
	}
}

function _check_url_local($url)
{
	if ( $this->_fopen($url, "r") )
	{
		$this->_fclose();
		return true;
	}
	else
	{
		return false;
	}
}

//---------------------------------------------------------
// read_file
//---------------------------------------------------------
function read_file($url)
{
	$this->_clear_errors();

	if ( empty($url) )
	{
		$this->_set_error_code( HAPPY_LINUX_REMOTE_CODE_EMPTY_URL );
		$this->_set_errors( "remote url is empty" );
		return false;
	}

// allow_url_fopen
	if ( $this->_flag_allow_url_fopen )
	{
		$ret = $this->read_file_local( $url );
		return $ret;
	}
// not allow_url_fopen
	else
	{
		$ret = $this->_read_file_remote( $url );
		return $ret;
	}

}

//---------------------------------------------------------
// read & write file
//---------------------------------------------------------
function read_file_local( $url )
{
	$fp = $this->_fopen( $url, "r" );
	if ( !$fp )
	{
		return false;
	}

	$content = $this->_fread();
	$this->_fclose();

	if ( !$content )
	{
		$this->_set_error_code( HAPPY_LINUX_REMOTE_CODE_NO_RESULT );
		$this->_set_errors( "remote data is empty: url = $url" );
		return false;
	}

	return $content;
}

function write_file_local( $filename, $data )
{
	$fp = $this->_fopen( $filename, "w" );
	if ( !$fp )
	{
		return false;
	}

	$ret = $this->_fwrite($data);
	$this->_fclose();

	return $ret;
}

//=========================================================
// private function
//=========================================================
//---------------------------------------------------------
// file handler
//---------------------------------------------------------
function _fopen( $url, $mode )
{
	$this->_fp = false;
	$fp = fopen( $url, $mode );

	if ( !$fp )
	{
		$this->_set_error_code( HAPPY_LINUX_REMOTE_CODE_NOT_FOPEN );
		$this->_set_errors( "cannot open url: url = $url" );
		return false;
	}

	$this->_fp = $fp;
	return $fp;
}

function _fclose()
{
	if ( !$this->_fp )  return false;

	if ( fclose($this->_fp) )
	{
		return true;
	}
	else
	{
		$this->_set_error_code( HAPPY_LINUX_REMOTE_CODE_NOT_FCLOSE );
		$this->_set_errors( "cannot close url" );
		return false;
	}
}

function _fread()
{
	if ( !$this->_fp )  return false;

	$content = '';

	do 
	{
		$data = fread($this->_fp, 8192);
		if ( strlen($data) == 0 )  break;
		$content .= $data;
	} while(true);

	return $content;
}

function _fwrite($data)
{
	if ( fwrite($this->_fp, $data) )
	{
		return true;
	}
	else
	{
		$this->_set_error_code( HAPPY_LINUX_REMOTE_CODE_NOT_FWRITE );
		$this->_set_errors( "cannot write to remote file" );
		return false;
	}
}

//=========================================================
// use class spoopy
//=========================================================
function _check_url_remote( $url )
{
	$ret = $this->_snoppy_fetch( $url );
	return $ret;
}

function _read_file_remote( $url )
{
	$ret = $this->_snoppy_fetch( $url );
	return $ret;
}

function _snoppy_fetch( $url )
{
	if ( $this->_snoopy->fetch( $url ) )
	{
		$res = $this->_snoopy->results;

		if ($res)
		{
			return $res;
		}
		else
		{
			$this->_set_error_code( HAPPY_LINUX_SNOPPY_CODE_NO_RESULT );
			$this->_set_errors( "remote data is empty: url = $url" );
			return false;
		}
	}
	else
	{
		$this->_set_error_code( HAPPY_LINUX_SNOPPY_CODE_NOT_FETCH );
		$this->_set_errors( "cannot fetch remote data: url = $url" );
		return false;
	}
}

//----- class end -----
}

?>