<?php
// $Id: remote_image.php,v 1.3 2006/09/15 14:06:42 ohwada Exp $

// 2006-09-10 K.OHWADA
// change return value

// 2006-07-10 K.OHWADA
// this is new file
// porting from weblinks_remote_image.php

//=========================================================
// Happy Linux Framework Module
// 2006-07-10 K.OHWADA
//=========================================================

//---------------------------------------------------------
// define constant
//---------------------------------------------------------
define('HAPPY_LINUX_REMOTE_CODE_NOT_WRITABLE', 21);

//=========================================================
// class happy_linux_remote_image
//=========================================================
class happy_linux_remote_image extends happy_linux_remote_file
{
// local
	var $_dir_work;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_remote_image()
{
	$this->happy_linux_remote_file();

	$dir_work = XOOPS_ROOT_PATH.'/modules/happy_linux/cache';
	$this->set_dir_work( $dir_work );

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_linux_remote_image();
	}

	return $instance;
}

//=========================================================
// public
//=========================================================
//---------------------------------------------------------
// get_image_size
// return is same as getimagesize()
// array of width, height, type, attr
//---------------------------------------------------------
function &get_image_size($url)
{
	$false = false;

	$this->_clear_errors();

// add check http://
	if ( empty($url) || ($url == 'http://') || ($url == 'https://') )
	{
		$this->_set_error_code( HAPPY_LINUX_REMOTE_CODE_EMPTY_URL );
		$this->_set_errors( "remote url is empty" );
		return $false;
	}

// allow_url_fopen
	if ( $this->_flag_allow_url_fopen )
	{
		$size = getimagesize($url);
	}
// not allow_url_fopen
	else
	{
		$size =& $this->_get_image_size_local($url);
	}

	return $size;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_dir_work($value)
{
	$this->_dir_work = $value;
}

//=========================================================
// private
//=========================================================
function &_get_image_size_local($url)
{
	$false = false;

	if ( !is_writable($this->_dir_work) )
	{
		$this->_set_error_code( HAPPY_LINUX_ERR_REMOTE_NOT_WRITABLE );
		$this->_set_errors( "work directory is not writable : ".$this->_dir_work );
		return $false;
	}

	$data = $this->_read_file_remote( $url );
	if ( !$data )
	{
		return $false;
	}

	$file = tempnam($this->_dir_work, "image");

	if ( !$this->write_file_local( $file, $data ) )
	{
		return $false;
	}

	$size = getimagesize($file);

	unlink($file);

	return $size;

}

// --- class end ---
}

?>