<?php
// $Id: func.whatsnew.php,v 1.4 2005/09/15 04:08:30 ohwada Exp $

// 2005-09-15 K.OHWADA
// add whatsnew_strip_style_tag()

// 2005-08-08 K.OHWADA
// content became one line
//   add fucntion function whatsnew_sanitize_crlf()
// BUG 2824: the CDATA-section-close delimiter "]]>" MUST be escaped "]]&gt;"
//   add fucntion whatsnew_convert_cdata()

// 2005-06-20 K.OHWADA
// add fucntion set_image, measure time

// 2005-06-06
// add plugin
// check if user has perm 

//=========================================================
// What's New Module
// collecting new aritciles from some modules
// 2004/08/20 K.OHWADA
//=========================================================

// --------------------------------------------------------
// collecting new aritciles from some modules
// --------------------------------------------------------
function whatsnew_get_new($whatsnew_module, $module_show='new_show', $module_limit='new_limit', $limit_show=10)
{

// get new from each module
	$i = 0;
	$result_array = array();
	$time_array   = array();

	foreach ( $whatsnew_module as $dirname => $module) 
	{
		if ($module[$module_show] != 1)  continue;

		$mid   = $module['mid'];
		$name  = $module['name'];
		$limit = $module[$module_limit];

// check if user has perm by hodaka
		global $xoopsUser;
		$groups = ( is_object($xoopsUser) ) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
		$moduleperm_handler =& xoops_gethandler('groupperm');
		// user has module access perm ?
		if (!$moduleperm_handler->checkRight('module_read', $mid, $groups)) 
		{	continue;	}
// end of hodaka

		$res_array = whatsnew_get_new_from_module($dirname, $limit);
		$count     = count($res_array);
		if (is_array($res_array) && $count > 0) 
		{
			for ($j=0; $j<$count; $j++) 
			{
				$result_array[$i] = $res_array[$j];	
				$result_array[$i]['module_id']   = $mid;
				$result_array[$i]['module_name'] = $name;
				$result_array[$i]['dirname']     = $dirname;	// hodaka
				$time_array[$i]   = $res_array[$j]['time'];
				$i++;
			}
		}
	}

// sort by time
	arsort($time_array);
	$i = 0;
	$new_array = array();

	foreach ($time_array as $num => $time)
	{
		$new_array[$i++] = $result_array[$num];
		if ($i >= $limit_show) break;
	}

	return $new_array;
}

// --------------------------------------------------------
// collecting new aritciles from one modules
// --------------------------------------------------------
function whatsnew_get_new_from_module($dirname, $limit=0, $offset=0)
{
// add plugin
	$file_module = XOOPS_ROOT_PATH."/modules/$dirname/include/data.inc.php";
	$file_plugin = XOOPS_ROOT_PATH."/modules/whatsnew/plugins/$dirname/data.inc.php";

	if ( file_exists($file_module) ) 
	{
		include_once $file_module;	
	} 
	elseif ( file_exists($file_plugin) ) 
	{
		include_once $file_plugin;	
	}
	else 
	{	return false;	}

	$func = $dirname."_new";
	if ( function_exists($func) )
	{
		return $func($limit,$offset);
	}
	else
	{	return false;	}

}

// --------------------------------------------------------
// set description
// --------------------------------------------------------
function whatsnew_set_desc_short($description, $max_summary)
{
	$desc = $description;
	$desc = whatsnew_sanitize_control_code($desc);
	$desc = preg_replace("/<br \/>/is",    "<br>",  $desc);
	$desc = preg_replace("/(<br>){2,}/is", "<br>",  $desc);
	$desc = preg_replace("/<br>/is",       "<br> ", $desc);
	$desc = whatsnew_strip_style_tag($desc);
	$desc = strip_tags($desc);
	$desc = whatsnew_shorten_text( $desc, $max_summary );

	return $desc;
}

// --------------------------------------------------------
// sanitize control code
// --------------------------------------------------------
function whatsnew_sanitize_control_code($text)
{
	$text = preg_replace('/[\x00-\x09]/',' ',$text);
	$text = preg_replace('/[\x0B-\x0C]/',' ',$text);
	$text = preg_replace('/[\x0E-\x1F]/',' ',$text);
	return $text;
}

// content became one line
function whatsnew_sanitize_crlf($text)
{
	$text = preg_replace("/\r/",' ',$text);
	$text = preg_replace("/\n/",' ',$text);
	return $text;
}

// --------------------------------------------------------
// htmlspecialchars
// http://www.w3.org/TR/REC-xml/#dt-markup
// http://www.fxis.co.jp/xmlcafe/tmp/rec-xml.html#dt-markup
// --------------------------------------------------------
function whatsnew_htmlspecialchars($text)
{
	$text = htmlspecialchars($text);
	$text = preg_replace("/'/", '&apos;', $text);
	return $text;
}

// BUG 2824: the CDATA-section-close delimiter "]]>" MUST be escaped "]]&gt;"
function whatsnew_convert_cdata($text)
{
	$text = preg_replace("/]]>/", ']]&gt;', $text);
	return $text;
}

// --------------------------------------------------------
// strip_style_tag
// --------------------------------------------------------
function whatsnew_strip_style_tag($text)
{
	return preg_replace('|<\s*style\s?.*?>(.*)<\s*/\s*style\s*>|is', '', $text);
}

// --------------------------------------------------------
// shorten text
// --------------------------------------------------------
function whatsnew_shorten_text($text,$max=100)
{
	if ( strlen($text) > $max)
	{
		if (function_exists('mb_strimwidth'))
		{
			$text = mb_strimwidth( $text, 0, $max, " ..." );
		}
		else
		{
			$text = substr( $text, 0, $max )." ...";
		}
	} 

	return $text;
}


// --------------------------------------------------------
// set_image
// --------------------------------------------------------
function whatsnew_set_image($article, $new_image, $max_width, $max_height)
{
	$image  = '';
	$width  = '';
	$height = '';

	if ( $new_image && isset($article['image']) )
	{
		$image = $article['image'];	

		if ( isset($article['width']) && isset($article['height']) )
		{
			list($width, $height) = whatsnew_adjust_image_size($article['width'], $article['height'], $max_width, $max_height);
		}
	}

	return array($image, $width, $height);
}

function whatsnew_adjust_image_size($width, $height, $max_width, $max_height)
{
	if ($width > $max_width)
    {
    	$mag    = $max_width / $width;
    	$width  = $max_width;
    	$height = $height * $mag;
    }

	if ($height > $max_height)
    {
    	$mag    = $max_height / $height;
    	$height = $max_height;
    	$width  = $width * $mag;
    }

    $width  = intval($width);
    $height = intval($height);

	return array($width, $height);
}

//---------------------------------------------------------
// http://www.w3.org/TR/NOTE-datetime
// 2003-12-13T18:30:02+09:00
//
// http://www.php.net/manual/ja/function.date.php
// User Contributed Notes
//---------------------------------------------------------
function whatsnew_iso8601_date($time)
{
	$tzd  = date('O',$time);
	$tzd  = substr( chunk_split( $tzd, 3, ':' ), 0, 6 );
	$date = date('Y-m-d\TH:i:s', $time) . $tzd;
	return $date;
} 

//-------------------------------------------------------------------
// measure time
//-------------------------------------------------------------------
function whatsnew_time_start()
{
	global $whatsnew_time_start;

	$whatsnew_time_start = whatsnew_getmicrotime();
}

function whatsnew_time_end()
{
	global $whatsnew_time_start;

	$time = whatsnew_getmicrotime() - $whatsnew_time_start;

	return $time;
}

function whatsnew_getmicrotime()
{ 
	list($usec, $sec) = explode(" ",microtime()); 
	return ((float)$sec + (float)$usec); 
}

?>
