<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/GroupEditForm.class.php";

class User_GroupEditAction extends User_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['groupid']) ? intval($_REQUEST['groupid']) : 0;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_gethandler('group');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new User_GroupEditForm();
		$this->mActionForm->prepare();
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("group_edit.html");
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		$controller->executeForward("index.php?action=GroupList");
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("index.php?action=GroupList", 1, "*ERROR*");
	}
}

?>