<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH."/user/forms/UserConfirmForm.class.php";
require_once XOOPS_MODULE_PATH."/user/forms/UserRegisterEditForm.class.php";
require_once XOOPS_MODULE_PATH."/user/class/RegistMailBuilder.class.php";

class User_UserRegister_confirmAction extends User_Action
{
	var $mActionForm=null;
	var $mRegistForm=null;
	var $mConfig=array();
	
	var $mNewUser=null;
	
	var $mRedirectMessage=null;

	function prepare(&$controller, &$xoopsUser, &$moduleConfig)
	{
		$this->mConfig=&$moduleConfig;

		$controller->mRoot->mEventManager->add("Module.User.Regist.Success",
												new XCube_InstanceDelegate($this,"eventNotifyMail"));
	}

	function execute(&$controller,&$xoopsUser)
	{
		// confirmForm
		$this->_getRegistForm($controller);
		$this->_processActionForm($controller);
		
		$memberHandler=&xoops_gethandler('member');
		$this->mNewUser=&$memberHandler->createUser();
		$this->mRegistForm->update($this->mNewUser);
		$this->mNewUser->setVar('uorder',$controller->getConfig('com_order'),true);
		$this->mNewUser->setVar('umode',$controller->getConfig('com_mode'),true);
		if($this->mConfig['activation_type'] == 1) {
			$this->mNewUser->setVar('level',1,true);
		}

		if(!$memberHandler->insertUser($this->mNewUser)) {
			$this->mRedirectMessage=_US_REGISTERNG;
			return USER_FRAME_VIEW_ERROR;
		}

        if(!$memberHandler->addUserToGroup(XOOPS_GROUP_USERS,$this->mNewUser->getVar('uid'))) {
			$this->mRedirectMessage=_US_REGISTERNG;
			return USER_FRAME_VIEW_ERROR;
		}

		$this->_clearRegistForm($controller);

		$this->_processMail($controller);
		$eventArgs = array();
		$controller->mRoot->mEventManager->raiseEvent("Module.User.Regist.Success",$controller,$eventArgs);
		
		return USER_FRAME_VIEW_SUCCESS;
	}
	
	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->_getRegistForm($controller);
		$this->_processActionForm($controller);

		return USER_FRAME_VIEW_INPUT;
	}
	
	/**
	 * Get regist actionform from Session and set it to the member property.
	 */
	function _getRegistForm(&$controller)
	{
		$this->mRegistForm=& unserialize($_SESSION['user_register_actionform']);
		if(!is_object($this->mRegistForm)) {
			$controller->executeForward('./index.php?action=UserRegister');
		}
	}

	/**
	 * clear session
	 */
	function _clearRegistForm(&$controller)
	{
		unset($_SESSION['user_register_actionform']);
	}
	
	function _processMail(&$controller)
	{
		$activationType=$this->mConfig['activation_type'];
		
		if($activationType==1)
			return;

		// Wmm..
		$builder = ($activationType==0) ? new RegistUserActivateMailBuilder()
		                                    : new RegistUserAdminActivateMailBuilder();

		$director=new UserRegistMailDirector($this->mNewUser,$controller->getConfig(),$this->mConfig);
		$director->contruct($builder);
		$mailer=&$builder->getResult();
		
		$mailer->send();	// CHECKS
	}
	
	function eventNotifyMail(&$controller,&$eventArgs)
	{
		if($this->mConfig['new_user_notify'] == 1 && !empty($this->mConfig['new_user_notify_group'])) {
			$director=new UserRegistMailDirector($this->mNewUser,$controller->getConfig(),$this->mConfig);
			$builder = new RegistUserNotifyMailBuilder();
			$director->contruct($builder);
			$mailer=&$builder->getResult();
			$mailer->send();
		}
	}

	function _processActionForm(&$controller)
	{
		$this->mActionForm=new UserConfirmForm();
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader(XOOPS_URL,1,$this->mRedirectMessage);
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("user_register_confirm.html");
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
		$renderSystem->setAttribute("registForm",$this->mRegistForm);
	}
	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		$activationType=$this->mConfig['activation_type'];

		if($activationType==0) {
			$renderSystem->setTemplateName("user_register_finish.html");
			$renderSystem->setAttribute("complete_message",_US_YOURREGISTERED);
		} else if($activationType==1) {
			XCube_Utils::redirectHeader(XOOPS_URL,4,_US_ACTLOGIN);
		} else if($activationType==2) {
			$renderSystem->setTemplateName("user_register_finish.html");
			$renderSystem->setAttribute("complete_message",_US_YOURREGISTERED2);
		}
	}
}
?>