<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/AbstractFilterForm.class.php";

define('ONLINE_SORT_KEY_ONLINE_UID', 1);
define('ONLINE_SORT_KEY_ONLINE_UNAME', 2);
define('ONLINE_SORT_KEY_ONLINE_UPDATED', 3);
define('ONLINE_SORT_KEY_ONLINE_MODULE', 4);
define('ONLINE_SORT_KEY_ONLINE_IP', 5);
define('ONLINE_SORT_KEY_MAXVALUE', 5);

define('ONLINE_SORT_KEY_DEFAULT', ONLINE_SORT_KEY_ONLINE_UID);

class Legacy_OnlineFilterForm extends Legacy_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		ONLINE_SORT_KEY_ONLINE_UID => 'online_uid',
		ONLINE_SORT_KEY_ONLINE_UNAME => 'online_uname',
		ONLINE_SORT_KEY_ONLINE_UPDATED => 'online_updated',
		ONLINE_SORT_KEY_ONLINE_MODULE => 'online_module',
		ONLINE_SORT_KEY_ONLINE_IP => 'online_ip'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : ONLINE_SORT_KEY_DEFAULT;
	
		if ($this->mSort > ONLINE_SORT_KEY_MAXVALUE) {
			$this->mSort = ONLINE_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['online_uid'])) {
			$this->_mCriteria->add(new Criteria('online_uid', array(XOBJ_DTYPE_INT, xoops_getrequest('online_uid'))));
		}
	
		if (isset($_REQUEST['online_uname'])) {
			$this->_mCriteria->add(new Criteria('online_uname', array(XOBJ_DTYPE_STRING, xoops_getrequest('online_uname'))));
		}
	
		if (isset($_REQUEST['online_updated'])) {
			$this->_mCriteria->add(new Criteria('online_updated', array(XOBJ_DTYPE_INT, xoops_getrequest('online_updated'))));
		}
	
		if (isset($_REQUEST['online_module'])) {
			$this->_mCriteria->add(new Criteria('online_module', array(XOBJ_DTYPE_INT, xoops_getrequest('online_module'))));
		}
	
		if (isset($_REQUEST['online_ip'])) {
			$this->_mCriteria->add(new Criteria('online_ip', array(XOBJ_DTYPE_STRING, xoops_getrequest('online_ip'))));
		}
		
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
