<?php
// $Id: simpleblog.php,v 1.69 2003/11/12 05:17:58 kousuke Exp $
include_once XOOPS_ROOT_PATH.'/modules/simpleblog/conf.php';
include_once XOOPS_ROOT_PATH.'/modules/simpleblog/language/'.$xoopsConfig['language'].'/main.php';
// include_once XOOPS_ROOT_PATH."/include/xoopscodes.php";


class SimpleBlog {
	var $VIEW_NUM = 20;
	
	var $user_list;
	var $blogUid;
	var $targetUser;
	var $userHander;
	var $permission = -1;
	var $title = '';
	var $usersCache = array();
	var $ts;
	var $xoopsDB;
	
	function SimpleBlog($blogUid = -1){
		global $xoopsDB;
		$this->xoopsDB =& $xoopsDB;
		$this->userHander = new XoopsUserHandler($this->xoopsDB);
		$this->ts =& MyTextSanitizer::getInstance();
		$this->user_list = array();
		$this->blogUid = intval($blogUid);
		
		
		if($this->blogUid > 0){
			$this->targetUser = $this->userHander->get($this->blogUid);
			if( (!$this->targetUser) || (!$this->targetUser->isActive())){
				redirect_header(SIMPLEBLOG_DIR,2,_MD_SIMPLEBLOG_NORIGHTTOACCESS);
				exit();
			}
			$usersCache[$this->blogUid] = $this->targetUser;
		}else{
			redirect_header(XOOPS_URL.'/',5,_MD_SIMPLEBLOG_INTERNALERROR.'(99.0) ['.$this->blogUid.']');
			exit();
		}
	}
	
	function getApplicationNum(){
		global $xoopsDB;
		if(!$dbResult = $xoopsDB->query('select count(*) num from '.SIMPLEBLOG_TABLE_APPL)){
			return 0;
		}
		if(list($num) = $xoopsDB->fetchRow($dbResult)){
			return $num;
		}
		return 0;
	}
	
	function getAllApplication(){
		global $xoopsDB;
		if(!$qResult = $xoopsDB->query('select uid, title, permission, create_date from '.SIMPLEBLOG_TABLE_APPL.' order by create_date' )){
			return false;
		}
		$result = array();
		while(list($uid, $title, $permission, $create_date) = $xoopsDB->fetchRow($qResult)){
			$result[] = array(
				'uid' => $uid, 
				'title' => $title, 
				'permission' => $permission, 
				'create_date' => $create_date);
		}
		return $result;
	}
	
	function deleteApplication($in_uid){
		global $xoopsDB;
		$uid = intval($in_uid);
		if($uid > 0){
			 $xoopsDB->queryF(sprintf('delete from %s where uid = %u', SIMPLEBLOG_TABLE_APPL, $uid));
		}
	}
	
	
	
	function getTargetUname(){
		return $this->targetUser->uname();
	}
	/**
	 * create new blog user
	 */
	function createNewBlogUser($permission = 0, $title = ''){
		global $xoopsUser;
		
		$result = $this->xoopsDB->query('select uid from '.SIMPLEBLOG_TABLE_INFO.' where uid = '.$this->blogUid);
		if(list($localuid) = $this->xoopsDB->fetchRow($result)){
			return false;
		}else{
			$this->xoopsDB->queryF('insert into '.SIMPLEBLOG_TABLE_INFO.'(uid, blog_permission, last_update, title) values ('.$this->blogUid.', '.intval($permission).', \'0000-00-00\', \''.$title.'\')');
			$result = $this->xoopsDB->query('select uid from '.SIMPLEBLOG_TABLE_APPL.' where uid = '.$this->blogUid);
			if(list($appUid ) = $this->xoopsDB->fetchRow($result)){
				$this->xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_APPL.' where uid = '.$this->blogUid);
			}
			return true;
		}
	}
	
	function setBlogInfo($permisstion = 0, $title = ""){
		$this->xoopsDB->queryF('update '.SIMPLEBLOG_TABLE_INFO.' set blog_permission = '.intval($permisstion).', title=\''.$title.'\' where uid ='.$this->blogUid);
	}
	
	function deleteAll(){
		$this->xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_INFO.' where uid = '.$this->blogUid);
		$this->xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid);
		$this->xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_COMMENT.' where uid = '.$this->blogUid);
		$this->xoopsDB->queryF('delete from '.SIMPLEBLOG_TABLE_TRACKBACK.' where uid = '.$this->blogUid);
	}
	
	function loadBlogInfo(){
		global $xoopsUser;
		$sql = 'select blog_permission, title from '.SIMPLEBLOG_TABLE_INFO.' where uid='.$this->targetUser->uid();
		if(!$result = $this->xoopsDB->query($sql)){
			return false;
		}
		if(list($permission, $title) = $this->xoopsDB->fetchRow($result)){
			$this->permission = $permission;
			$this->title = $title;
			return true;
		}
		return false;
	}
	
	
	function canWrite(){
		global $xoopsUser;
		if(!$xoopsUser){
			return false;
		}else if($this->permission < 0){
			if(!$this->loadBlogInfo()){
				return false;
			}
		}
		if($xoopsUser->uid() == $this->blogUid){
			return true;
		}
		return false;	
	}
	
	function canRead(){
		global $xoopsUser;
		if($xoopsUser){
			return true;
		}
		if($this->permission < 0){
			$this->loadBlogInfo();
		}
		
		if( ($this->permission == 0) || ($this->permission == 1) || ($this->permission == 2) ){
			return true;
		}
		return false;
	}
	
	function canComment(){
		global $xoopsUser;
		
		if($this->permission < 0){
			$this->loadBlogInfo();
		}
		
		if($this->permission == 0){
			return true;
		}
		if($xoopsUser){
			if(($this->permission == 1) || ($this->permission == 3)){
				return true;
			}
		}
		return false;
	}
	
	function getTitle(){
		if($this->permission < 0){
			$this->loadBlogInfo();
		}
		if($this->title != ''){
			return $this->title;
		}else{
			return _MD_SIMPLEBLOG_TITLE_PREFIX.$this->getTargetUname()._MI_SIMPLEBLOG_TITLE_SUFFIX;
		}
	}
	
	
	function getBlogData($year = 0, $month = 0, $date = 0, $limit = 0){
		global $xoopsUser;
		if($limit == 0){
			$limit = SIMPLEBLOG_VIEW_LIST_NUM;
		}
		$dateFormat = '%y/%m/%d';
		if(!$this->canRead()){
			redirect_header(XOOPS_URL.'/',1,_MD_SIMPLEBLOG_NORIGHTTOACCESS);
			exit();
		}
		$sql_blog = '';
		
		if( ($year > 1000) && ($month > 0) ){
			if($date > 0){ // display date blog
					if(checkdate($month, $date, $year)){
						$sql_blog = 'select UNIX_TIMESTAMP(last_update) last_update, blog_date, title, post_text from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' and blog_date= \''.$year.'-'.$month.'-'.$date.'\' order by blog_date desc ';
					}
			}else{ // display month blog
				$sql_blog = 'select UNIX_TIMESTAMP(last_update) last_update, blog_date, title, post_text from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' and DATE_FORMAT(blog_date, \'%Y\')='.$year.' and DATE_FORMAT(blog_date, \'%m\') = '.$month.' order by blog_date desc ';
			}
		}
		if($sql_blog == ''){ // display current blog
			$sql_blog = 'select UNIX_TIMESTAMP(last_update) last_update, blog_date, title, post_text from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' order by blog_date desc limit '.$limit;
		}
		
		if(!$result_blog = $this->xoopsDB->query($sql_blog)){
			return false;
		}
		$result = array();
		$i = 0;
	
		while(	list(
				$last_update,
				$result_date, 
				$result_title,
				$result_post_text
			) = $this->xoopsDB->fetchRow($result_blog)
		){

			$result['blog'][$i]['year'] = $this->mb_strcut($result_date, 0, 4);
			$result['blog'][$i]['month'] = $this->mb_strcut($result_date, 5, 2);
			$result['blog'][$i]['date'] = $this->mb_strcut($result_date, 8, 2);
			$result['blog'][$i]['date_all'] = $result_date;
			$result['blog'][$i]['title'] = $result_title;
			$result['blog'][$i]['text'] = $this->ts->makeTareaData4Show($result_post_text);
			$result['blog'][$i]['text_edit'] = $this->ts->makeTareaData4Edit($result_post_text);
			$result['blog'][$i]['comments'] = $this->getComments($result_date);
			$result['blog'][$i]['url'] = SimpleBlog::createUrl($this->blogUid, $result['blog'][$i]['year'], $result['blog'][$i]['month'], $result['blog'][$i]['date']);
			$result['blog'][$i]['last_update_s'] = formatTimestamp($last_update, 's');
			$result['blog'][$i]['last_update_m'] = formatTimestamp($last_update, 'm');
			$result['blog'][$i]['last_update_l'] = formatTimestamp($last_update, 'l');
			$result['blog'][$i]['last_update4rss'] =& SimpleBlog::toRssDate($last_update, $this->targetUser->getVar("timezone_offset"));
			$i++;
		}
		
		
		$result['blog_num'] = $i;
		$time = time();
		$result['today']['year'] = date('Y',$time);
		$result['today']['month'] = date('m',$time);
		$result['today']['date'] = date('d',$time);
		$result['user'] = $this->targetUser;
		$result['uname'] = $this->targetUser->uname();
		return $result;
	}
	
	
	
	function getBlog1($dates){
		global $xoopsUser;
		$sqlDate = $dates['year'].'-'.$dates['month'].'-'.$dates['date'];
		$sql = 'select title, post_text FROM '.SIMPLEBLOG_TABLE_BLOG.' WHERE uid = '.$this->blogUid.' and  blog_date = \''.$sqlDate.'\'';
		if(!$result_select = $this->xoopsDB->query($sql)){
			return false;
		}
		$result = array();
		
		$result['year'] = $dates['year'];
		$result['month'] = $dates['month'];
		$result['date'] = $dates['date'];
			
		if(list($title, $text) = $this->xoopsDB->fetchRow($result_select)){
			
			$result['date_all'] = $sqlDate;
			$result['title'] = $title;
			$result['text'] = $this->ts->makeTareaData4Show($text);
			$result['text_edit'] = $this->ts->makeTareaData4Edit($text);
		}
		return $result;
	}
	
	
	function updateBlog($dates, $text, $title = ''){
		global $xoopsUser;
		
		$sqlDate = $dates['year'].'-'.$dates['month'].'-'.$dates['date'];
		// $sqlDate = $this->escapeHtml($dates['sql_date']);
		$sqlText = $this->ts->makeTareaData4Save($this->escapeHtml($text));
		$sqlTitle = $this->ts->makeTareaData4Save($this->escapeHtml($title));
		$uid = $xoopsUser->uid();
		if(empty($text)){
			$sql = sprintf("delete from %s where uid=%u and blog_date='%s'", SIMPLEBLOG_TABLE_BLOG, $uid, $sqlDate);
		}else{
			$sql = sprintf("select uid from %s where uid = %u and blog_date = '%s'",SIMPLEBLOG_TABLE_BLOG, $uid, $sqlDate);
			if(!$result_select = $this->xoopsDB->query($sql)){
				return false;
			}
			if($this->xoopsDB->getRowsNum($result_select) == 0){
				$sql = sprintf("insert into %s(uid, blog_date, title, post_text) values(%u, '%s', '%s', '%s')", SIMPLEBLOG_TABLE_BLOG, $uid, $sqlDate, $sqlTitle, $sqlText);
			}else{
				$sql = sprintf("update %s set title = '%s', post_text = '%s' where uid = %u and blog_date ='%s'", SIMPLEBLOG_TABLE_BLOG, $sqlTitle, $sqlText, $uid, $sqlDate);
			}
		}
		$this->xoopsDB->queryF($sql);
		$this->update();
		return true;
	}
	
	function update(){
		$sql = 'update '.SIMPLEBLOG_TABLE_INFO.' set last_update = CURRENT_TIMESTAMP() where uid = '.$this->blogUid;
		$this->xoopsDB->queryF($sql);
	}
	
	function insertComment($dates, $name, $comment){
		global $xoopsUser;
		$uid = 0;
		if($xoopsUser){
			$uid = $xoopsUser->uid();
		}
		$sqlDate = $this->escapeHtml($dates['year'].'-'.$dates['month'].'-'.$dates['date']);
		$sqlName = $this->escapeHtml($name);
		$sqlComment = $this->escapeHtml($comment); 
		$sql = sprintf("select count(*) from %s where uid = %u and blog_date = '%s'",SIMPLEBLOG_TABLE_BLOG, $this->blogUid, $sqlDate);
		if(!$result_select = $this->xoopsDB->query($sql)){
			return false;
		}
		if($this->xoopsDB->getRowsNum($result_select) == 1){
			$sql_base = "insert into %s (uid, blog_date, comment_id, comment_uid, comment_name, post_text) values(%u, '%s', null, %u, '%s', '%s')";
			$sql = sprintf($sql_base, SIMPLEBLOG_TABLE_COMMENT, $this->blogUid, $sqlDate, $uid, $sqlName, $sqlComment);
			$result = $this->xoopsDB->queryF($sql);
			
			$this->update();
			return true;
		}
		return false;
	}
	
	function escapeHtml($text){
		$result = $text;
		// $result = ereg_replace('&', '&amp;', $text);
		$result = ereg_replace('<', '&lt;', $result);
		$result = ereg_replace('>', '&gt;', $result);
		// $result = ereg_replace('\'', '&apos;', $result);
		$result = ereg_replace('"', '&quot;', $result);
		//$result = ereg_replace('\r\n', '\n', $result);
		//$result = ereg_replace('\r', '\n', $result);
		//$result = ereg_replace('\n', '<br />', $result);
		return $result;
	}
	
	function getBlogIndex(){
		global $xoopsUser;
		$sql = 'select distinct DATE_FORMAT(blog_date, \'%Y\') year, DATE_FORMAT(blog_date, \'%m\') month from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' and blog_date != \'0000-00-00\' order by year desc, month';
		if(!$result_select = $this->xoopsDB->query($sql)){
			return false;
		}
		$result = array();
		while(list($year, $month) = $this->xoopsDB->fetchRow($result_select)){
			// $result[$year][$month] = $month;
			$result[$year][$month]['month'] = $month;
			$result[$year][$month]['url'] = SimpleBlog::createUrl($this->blogUid, $year, $month);
		}
		return $result;
	}
	
	function getComments($blogDate){
		global $xoopsUser;
		$sql = 'select comment_id, comment_uid,comment_name, post_text from '.SIMPLEBLOG_TABLE_COMMENT.' where uid = '.$this->blogUid.' and blog_date = '.$this->xoopsDB->quoteString($blogDate).' order by comment_id '; 
		if(!$result_select = $this->xoopsDB->query($sql)){
			return false;
		}
		$i = 0;
		$comments = array();
		
		while(
			list($comment_id, $comment_uid, $comment_name, $post_text) = $this->xoopsDB->fetchRow($result_select)
		){
			$comments[$i]['id'] = $comment_id;
			$comments[$i]['uid'] = $comment_uid;
			if($comment_uid > 0){
				if(!in_array($comment_uid, $this->usersCache)){
					$this->usersCache[$comment_uid] = $this->userHander->get($comment_uid);
				}
				$comments[$i]['name'] = $this->usersCache[$comment_uid]->uname();
			}else{
				$comments[$i]['name'] = $comment_name.'@'._MD_SIMPLEBLOG_FORM_GUEST;
			}
			$comments[$i]['comment'] = $post_text;
			$i++;
		}
		return $comments;
	}


	function getDateFromHttpParams(){
		global $HTTP_POST_VARS, $HTTP_GET_VARS;
		
		$param = isset($HTTP_POST_VARS['param']) ? ($HTTP_POST_VARS['param']) : 0;
		if($param == 0){
			$param = isset($HTTP_GET_VARS['param']) ? ($HTTP_GET_VARS['param']) : 0;
		}
		$param = trim($param);
		
		if($param == 0){
			return false;
		}
		
		if(preg_match("/^([0-9]+)-([0-9]{4})([0-9]{2})([0-9]{2})$/", $param, $m)){
			$result['uid'] = SimpleBlog::checkUid($m[1]);
			$result['year'] = SimpleBlog::checkYeak($m[2]);
			$result['month'] = SimpleBlog::checkMonth($m[3]);
			$result['date'] = SimpleBlog::checkDate($m[2], $m[3], $m[4]);
		}else if(preg_match("/^([0-9]+)-([0-9]{4})([0-9]{2})$/", $param, $m)){
			$result['uid'] = SimpleBlog::checkUid($m[1]);
			$result['year'] = SimpleBlog::checkYeak($m[2]);
			$result['month'] = SimpleBlog::checkMonth($m[3]);
		}else if(preg_match("/^([0-9]+)$/", $param, $m)){
			$result['uid'] = SimpleBlog::checkUid($m[1]);
		}else{
			redirect_header(XOOPS_URL.'/',1,_MD_SIMPLEBLOG_INVALID_DATE.'(INVALID PARAM)');
			exit();
		}
		return $result;
	}
	
	function trackback($dates = null){
		global $HTTP_POST_VARS;
		
		$referer = null;
		if(array_key_exists('url', $HTTP_POST_VARS)){
			$referer = trim($HTTP_POST_VARS['url']);
		}
		if(empty($referer) && array_key_exists('HTTP_REFERER', $_SERVER)){
			$referer = trim($_SERVER['HTTP_REFERER']);
		}
		
		if( (empty($referer)) || (preg_match('/^'.ereg_replace('/', '\\/', XOOPS_URL).'*/', $referer)) ){
			return;
		}
		if(SimpleBlog::isCompleteDate($dates)){
			$targetDate = $dates['year']."-".$dates['month'].'-'.$dates['date'];
		}
		
		// get current date
		$sql = 'select blog_date from '.SIMPLEBLOG_TABLE_BLOG.' where uid = '.$this->blogUid.' order by blog_date desc limit 1';
		if(!$result_select = $this->xoopsDB->query($sql)){
			return false;
		}
		list($current_date) = $this->xoopsDB->fetchRow($result_select);
		
		if(!empty($current_date)){
			// $insert = "insert into ".SIMPLEBLOG_TABLE_TRACKBACK." VALUES(%u, %s, %s)";
			// $sql = sprintf($insert, $this->blogUid, $this->xoopsDB->quoteString($current_date), $this->xoopsDB->quoteString($referer));
			// $this->xoopsDB->queryF($sql);
			$this->incrementTrackBack($current_date, $referer);
			if( (!empty($targetDate)) && ($current_date != $targetDate)){
			// 	$sql = sprintf($insert, $this->blogUid, $this->xoopsDB->quoteString($targetDate), $this->xoopsDB->quoteString($referer));
			// 	$this->xoopsDB->queryF($sql);
				$this->incrementTrackBack($targetDate, $referer);
			}
		}
	}
	function incrementTrackBack($date, $url){
		$update = "update ".SIMPLEBLOG_TABLE_TRACKBACK." set count = count+1 where uid = %u and t_date = %s and url = %s";
		$this->xoopsDB->queryF(sprintf($update, $this->blogUid, $this->xoopsDB->quoteString($date), $this->xoopsDB->quoteString($url)));
		if($this->xoopsDB->getAffectedRows() == 0){
			$insert = "insert into ".SIMPLEBLOG_TABLE_TRACKBACK." VALUES(%u, %s, 1, %s)";
			$this->xoopsDB->queryF(sprintf($insert, $this->blogUid, $this->xoopsDB->quoteString($date), $this->xoopsDB->quoteString($url)));
		}
	}
	
	function getTrackBack($date){
		$sqlDate = $this->xoopsDB->quoteString($date['year']."-".$date['month']."-".$date['date']);
		$sql = 'select count, t_date, url from '.SIMPLEBLOG_TABLE_TRACKBACK.' where uid = '.$this->blogUid.' and t_date = '.$sqlDate.'  order by count desc';
		if(!$result_select = $this->xoopsDB->query($sql)){
			return false;
		}
		$result = array();
		while(list($count, $date, $url) = $this->xoopsDB->fetchRow($result_select)){
			$t = array();
			$t['count'] = $count;
			$t['date'] = $date;
			$t['url'] = htmlspecialchars($url);
			$result[] = $t;
		}
		return $result;
	}
	
	//________________________________________________________________________________________________
	//                                                                                 static methods
	
	function newApplication($in_title, $in_permission){
		global $xoopsUser, $xoopsDB;
		$title = "";
		$permission = -1;
		if(!empty($in_title)){
			$title = $in_title;
		}
		if( ($in_permission == 0) || ($in_permission == 1) || ($in_permission == 2) || ($in_permission == 3)){
			$permission = intval($in_permission);
		}
		
		if($permission < 0){
			return _MD_SIMPLEBLOG_ERR_INVALID_PERMISSION;
		}
		if(!$result = $xoopsDB->query('select uid from '.SIMPLEBLOG_TABLE_APPL.' where uid = '.$xoopsUser->uid())){
			return "select error";
		}
		if(list($tmpUid) = $xoopsDB->fetchRow($result)){
			return _MD_SIMPLEBLOG_ERR_APPLICATION_ALREADY_APPLIED;
		}
		if(!$result = $xoopsDB->query('select uid from '.SIMPLEBLOG_TABLE_INFO.' where uid = '.$xoopsUser->uid())){
			return "select error";
		}
		if(list($tmpUid) = $xoopsDB->fetchRow($result)){
			return _MD_SIMPLEBLOG_ERR_ALREADY_WRITABLE;
		}
		$sql = sprintf("insert into %s (uid, title, permission, create_date) values(%u, '%s', %u, CURRENT_TIMESTAMP())", 
			SIMPLEBLOG_TABLE_APPL, $xoopsUser->uid(), $title, $permission);
		if(!$result = $xoopsDB->query($sql)){
			return "insert error";
		}
		
		return "";
	}
	
	function getXoopsModuleConfig($key){
		global $xoopsDB;
		$mid = -1;

		$sql = "SELECT mid FROM ".$xoopsDB->prefix('modules')." WHERE dirname = 'simpleblog'";
		if (!$result = $xoopsDB->query($sql)) {
			return false;
		}
		$numrows = $xoopsDB->getRowsNum($result);
		if ($numrows == 1) {
			list($l_mid) = $xoopsDB->fetchRow($result);
			$mid = $l_mid;
		}else{
			return false;
		}
		
		$sql = "select conf_value from ".$xoopsDB->prefix('config')." where conf_modid = ".$mid." and conf_name = '".trim($key)."'";
		if (!$result = $xoopsDB->query($sql)) {
			return false;
		}
		$numrows = $xoopsDB->getRowsNum($result);
		if ($numrows == 1) {
			list($value) = $xoopsDB->fetchRow($result);
			return intval($value);
		}else{
			return false;
		}

	}
	
	function get_blog_list($start = 0){
		global $xoopsUser, $xoopsDB;
		$useRerite = SimpleBlog::getXoopsModuleConfig('SIMPLEBLOG_REWRITE');
		
		$block_list_num = 10;
		$permission = 2;
		$dateFormat = '%m/%d %k:%i';
		if ( $xoopsUser ) {
			$permission = 4;
		}
	
		$selectMax = $start + SIMPLEBLOG_BLOCK_LIST_NUM;
		$sql_select = sprintf('select uid, UNIX_TIMESTAMP(last_update) last_update,  title FROM %s WHERE blog_permission <= %u and last_update != \'0000-00-00\' ORDER BY last_update desc limit %u',
			 SIMPLEBLOG_TABLE_INFO, $permission, $selectMax);
		if(!$result_select = $xoopsDB->query($sql_select)){
			return false;
		}
	
		$tmp = array();
		$i = 0;
		while(	list(
				$result_uid, 
				$result_last_update,
				$title
			) = $xoopsDB->fetchRow($result_select)
		){
			if($i >= $start){
				$res = array();
				$res['uid'] = $result_uid;
				$res['last_update'] = $result_last_update;
				$res['last_update_s'] = formatTimestamp($result_last_update, 's');
				$res['last_update_m'] = formatTimestamp($result_last_update, 'm');
				$res['last_update_l'] = formatTimestamp($result_last_update, 'l');
				$res['title'] = $title;
				$res['url'] = SimpleBlog::createUrl($result_uid);
				$tmp[$i] = $res;
			}
			$i++;
		}
		$block = array();
		$userHander = new XoopsUserHandler($xoopsDB);
		$i = 0;
		foreach ( $tmp as $target ) {
			$tUser = $userHander->get($target['uid']);
			$target['uname'] = $tUser->uname();
			$target['last_update4rss'] = SimpleBlog::toRssDate($target['last_update'], $tUser->getVar("timezone_offset"));
			if(empty($target['title'])){
				$target['title'] = _MD_SIMPLEBLOG_TITLE_PREFIX.$target['uname']._MD_SIMPLEBLOG_TITLE_SUFFIX;
			}
			$block[$i] = $target;
			$i++;
		
		}
		return $block;
	}
	
	function createUrl($uid, $year = 0, $month = 0, $date = 0){
		return XOOPS_URL."/modules/simpleblog/".SimpleBlog::createUrlNoPath($uid, $year, $month, $date);
	}
	
	function createUrlNoPath($uid, $year = 0, $month = 0, $date = 0){
		$useRerite = SimpleBlog::getXoopsModuleConfig('SIMPLEBLOG_REWRITE');
		$result = '';
		if((empty($useRerite)) || ($useRerite == 0) ){
			$result .= "index.php?param=".SimpleBlog::makeParams($uid, $year, $month, $date);
		}else{
			$result .= "view/".SimpleBlog::makeParams($uid, $year, $month, $date).".html";
		}
		return $result;
	}
	
	function check_updater(){
		$host = "xoops-modules.sourceforge.jp";
		$port = 80;
		$file = "/update/simpleblog.txt";
		$local = "simpleblog-0.1.0";
		$response = "";

		$request  = "GET ".$file." HTTP/1.0\r\n";
		$request .= "Host: " . $host . ":" . $port . "\r\n";
		$request .= "User-agent: xoops/".$local."\r\n\r\n";

		$fp = fsockopen($host, $port, $errno, $errstr, 10);
		if(! $fp) {
			return false;
		} else {
			fputs($fp, $request);
			while( !feof($fp) ){
				$response .= fread($fp, 4096);
			}
		}
		$pos = strpos($response, "\r\n\r\n");
		$response = substr($response, $pos + 4);
		$pos = strpos($response, "\r");
		if($pos == false){
			$pos = strpos($response, "\n");
		}
		if($pos != false){
			$response = substr($response, 0, $pos);
		}
		return array('request' => $request, 'response' => $response, 'local' => $local);
	}
	
	function mb_strcut($text, $start, $end){
		if(function_exists('mb_strcut')){
			return mb_strcut($text, $start, $end);
		}else{
			return strcut($text, $start, $end);
		}
	}
	
	function toRssDate($time, $timezone = null){
		if(!empty($timezone)){
			$time = xoops_getUserTimestamp($time, $timezone);
		}
		$res =  date("Y-m-d\\TH:i:sO", $time);
		// mmmm
		$result = substr($res, 0, strlen($res) -2).":".substr($res, -2);
		return $result;
	}
	
	function checkUid($iuid){
		$uid = intval($iuid);
		if( $uid > 0){
			return $uid;
		}
	}

	function checkYeak($iyear){
		$year = intval($iyear);
		if ( ($year > 1000) && ($year < 3000) ){
			return $iyear;
		}
		redirect_header(XOOPS_URL.'/',1,_MD_SIMPLEBLOG_INVALID_DATE.'(YEAR)'.$iyear);
		exit();
	}
	
	function checkMonth($imonth){
		$month = intval($imonth);
		if ( ($month > 0) && ($month < 13) ){
			return $imonth;
		}
		redirect_header(XOOPS_URL.'/',1,_MD_SIMPLEBLOG_INVALID_DATE.'(MONTH)');
		exit();
	}
	
	function checkDate($year, $month, $date){
		if(checkdate(intval($month), intval($date), intval($year))){
			return $date;
		}
		redirect_header(XOOPS_URL.'/',1,_MD_SIMPLEBLOG_INVALID_DATE.'(ALL DATE) '.intval($year)."-".intval($month)."-". intval($date));
		exit();
	}
	
	function makeParams($uid, $year = 0, $month = 0, $date = 0){
		$result = '';
		if($year == 0){
			$result = $uid;
		}else if($date == 0){
			$result = sprintf("%s-%04u%02u", "".$uid, $year, $month);
		}else{
			$result = sprintf("%s-%04u%02u%02u", "".$uid, $year, $month, $date);
		}
		return $result;
	}
	
	function isCompleteDate($d){
		if(checkdate(intval($d['month']), intval($d['date']), intval($d['year']))){
			return true;
		}
		return false;
	}
	function complementDate($d){
		if(!checkdate(intval($d['month']), intval($d['date']), intval($d['year']))){
			$time = time();
			$d['year'] = date('Y',$time);
			$d['month'] = sprintf('%02u', date('m',$time));
			$d['date'] =  sprintf('%02u', date('d',$time));
		}
		return $d;
	}
}

?>