package org.torikiri.xlsapi;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.contrib.HSSFCellUtil;

public class XlsContext {

	private HSSFWorkbook workbook;

	private HSSFSheet currentSheet;

	private HSSFRow currentRow;

	private HSSFCell currentCell;

	public XlsContext(HSSFWorkbook workbook) {
		this.workbook = workbook;
	}

	public HSSFWorkbook getCurrentBook() {
		return assertNotNull(workbook);
	}

	public HSSFSheet getCurrentSheet() {
		return assertNotNull(currentSheet);
	}

	public HSSFRow getCurrentRow() {
		return assertNotNull(currentRow);
	}

	public HSSFCell getCurrentCellell() {
		return assertNotNull(currentCell);
	}

	HSSFSheet nextSheet() {
		return (currentSheet = workbook.createSheet());
	}

	HSSFSheet nextSheet(String name) {
		return (currentSheet = workbook.createSheet(name));
	}

	HSSFRow nextRow(int index) {
		return (currentRow = HSSFCellUtil.getRow(index, getCurrentSheet()));
	}

	HSSFCell nextCell(int index) {
		return (currentCell = getCurrentRow().getCell(index, HSSFRow.CREATE_NULL_AS_BLANK));
	}

	private static <T> T assertNotNull(T o) {
		if (o == null) {
			throw new RuntimeException();
		}
		return o;
	}
}
