package org.torikiri.xlsapi;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.torikiri.xlsapi.util.StringUtil;

public class Xls extends AbstractElement<Xls, Sheet>{

	public Xls(Sheet... sheets) {
		add(sheets);
	}

	public Xls(boolean condition, Sheet... sheets) {
		add(condition, sheets);
	}

	public void write(String path) throws IOException {
		OutputStream out = null;
		try {
			write(out = new FileOutputStream(path));
		} finally {
			if (out != null) out.close();
		}
	}

	public void write(OutputStream out) throws IOException {
		build().write(out);
	}

	public HSSFWorkbook build() {
		HSSFWorkbook result = new HSSFWorkbook();
		XlsContext ctx = new XlsContext(result);
		for (Sheet s : children) {
			s.build(ctx, StringUtil.isEmpty(s.getName()) ?
				ctx.nextSheet() : ctx.nextSheet(s.getName()));
		}
		return result;
	}

	@Override
	public Xls getThis() {
		return this;
	}
}
