#include <stdio.h>

#include "unzip.h"

static int _unzipLog(char *s)
{
	FILE *fp;

	fp = fopen("./unzip.log","a");

	fprintf(fp,"%s\n",s);

	fclose(fp);

	return 0;
}
static int _checkFileType(char *fname)
{
	char *p;

	for(p=fname+strlen(fname)-1;*p;p--){
		if(*p == '.') break;
	}

	if(strcmp(p,".txt")==0 || strcmp(p,".TXT")==0 || strcmp(p,".text")==0 || strcmp(p,".TEXT")==0) return 1;

	return 0;
}
int itextGetZipTitle(char *file_path,unsigned char *title)
{
	char log[100];
	char filename[256];

	void *un_buf;
	int un_size;

	unzFile *fz;
	unz_global_info ginfo;
	unz_file_info finfo;

	int i,j,flag;
	unsigned char *p;


	if((fz = unzOpen(file_path)) == NULL){
		sprintf(log,"unzip : False Open File %s",file_path);
		_unzipLog(log);
		return -1;
	}

	if(unzGetGlobalInfo(fz,&ginfo) != UNZ_OK){
		_unzipLog("unzip : False unzGetGloblInfo()");
		return -1;
	}

	if(unzGoToFirstFile(fz) != UNZ_OK){
		_unzipLog("unzip : False unzGoToFirstFile()");
		return -1;
	}


	for(i=0;i<ginfo.number_entry;i++){

		unzGetCurrentFileInfo(fz,&finfo,filename,256,NULL,0,NULL,0);

		if(_checkFileType(filename)){

			unzOpenCurrentFile(fz);

			un_buf = (void *)malloc(BUFSIZ);
			while((un_size = unzReadCurrentFile(fz,un_buf,BUFSIZ)) > 0){

				j = 0;
				flag = 0;
				for(p=un_buf;*p;p++){
					if(*p == '\r' || *p == '\n'){
						if(flag == 0){
							continue;
						}else{
							*(title + j) = '\0';
							break;
						}
					}else{
						if(flag == 0) flag = 1;
					}
					if(flag) *(title + (j++)) = *p; 
				}
				break;
			}
			free(un_buf);
			unzCloseCurrentFile(fz);

			break;
		}

		unzGoToNextFile(fz);
	}

	unzClose(fz);

	return j;
}
