#include "itext.h"
#include "xtext.h"

#define debug 0

int xtext_next_kuten(ITEXT_T *it)
{
	ITEXT_T *n;

	if(it->next == NULL) return -1;

	n = it->next;

	if(n->c1 == 0xa1){
		if(n->c2 == 0xa2 || n->c2 == 0xa3 || n->c2 == 0xd7 || n->c2 == 0xd9) return 1;
	}

	return 0;
}
int xtext_get_low_space(ITEXT_T *it,char_data_t *ct)
{
	int h;

	h = it->ej ? ct->charSize + ct->ypad : ct->charSize_e + ct->ypad;

	return h;
}
static void * _page_data_free(page_data_t **start,page_data_t **end)
{
	page_data_t *pt,*ptt;

	for(pt = *start;pt!=NULL;pt=pt->next){

		ptt = pt->next;

		free(pt);

	}

	*start = NULL;
	*end = NULL;

	return NULL;
}
static page_data_t * _page_data_alloc()
{
	page_data_t *pt;

	pt = (page_data_t *)malloc(sizeof(page_data_t));
	pt->char_no = 0;

	return pt;
}
static void *_page_data_add(page_data_t **start,page_data_t **end,page_data_t *mg)
{
        if(*end){
                mg->next = NULL;
                mg->prev = *end;

                (*end)->next = mg;
                *end = mg;
        }else{
                mg->next = NULL;
                mg->prev = NULL;

                *end = mg;
                *start = mg;
        }

	return NULL;
}
static void *_page_data_insert(page_data_t **start,page_data_t **end,int n,int np)
{
	page_data_t *pt;

	pt = (page_data_t *)_page_data_alloc();

	pt->char_no = n;
	pt->page_no = np+1;

	_page_data_add(start,end,pt);

	return NULL;
}
static image_data_t * _image_data_alloc()
{
	image_data_t *im;

	im = (image_data_t *)malloc(sizeof(image_data_t));
	im->chu = 0;

	return im;
}
static void * _image_data_free(image_data_t **head,image_data_t **tail)
{
	image_data_t *im,*imm;

	for(im = *head;im!=NULL;im=im->next){
		imm = im->next;

		XDestroyImage(im->char_image);
	}

	*head = NULL;
	*tail = NULL;

	return NULL;
}
static void * _image_data_add(image_data_t **head,image_data_t **tail,image_data_t *im)
{
        if(*tail){
                im->next = NULL;
                im->prev = *tail;

                (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }

	return NULL;
}
static Pixmap _xtext_Draw_imageString_normal(	Display *disp,
						my_window_t win,
						char_data_t *char_d,
						ITEXT_T *it,
						int type,
						XImage **base_im,
						int *charSize		)
{
        Pixmap pix;

	XFontSet fs;
	GC gc,gc1;
	char text[3];

	fs = win.fs;
	gc1 = win.sgc;
	gc = win.gc;
	*charSize = char_d->charSize;

	if(it->chu == 1) gc = win.rubi_gc;
	if(it->small == 1){
	       	*charSize = char_d->charSize_s;
		fs = win.fs_s;
	}
	if(it->ej == 0){
		text[0] = it->c1;
		text[1] = '\0';
		fs = win.fs_e;
	}else{
		text[0] = it->c1;
		text[1] = it->c2;
		text[2] = '\0';
	}

        pix = XCreatePixmap(disp,DefaultRootWindow(disp),*charSize,*charSize,DefaultDepth(disp,0));
        XFillRectangle(disp,pix,win.bgc,0,0,*charSize,*charSize);
        *base_im = XGetImage(disp,pix,0,0,*charSize,*charSize,0xFFFF,XYPixmap);


      	if(type == 4){
               	XRectangle ink,log;
               	int tx,ty;

               	XmbTextExtents(fs,text,strlen(text),&ink,&log);

               	if((log.width == ink.width) && (log.height == ink.height)){ 
                       	tx = *charSize / 4;
                       	ty = ink.height - (ink.height / 4);
               	}else{ 
                       	tx = (*charSize - ink.width) / 2;
                       	ty = ink.height;
               	}

		XmbDrawString(disp,pix,fs,gc,tx,ty,text,strlen(text));
       	}else{
		XmbDrawString(disp,pix,fs,gc,2,*charSize-2,text,strlen(text));
       	}

	return pix;
}
static Pixmap _xtext_Draw_imageString_anti(	Display *disp,
						my_window_t win,
						char_data_t *char_d,
						ITEXT_T *it,
						int type,
						XImage **base_im,
						int *charSize		)
{
	Pixmap pix;

#if HAVE_LIBXFT

	XftDraw *draw = NULL;
	XftFont *font = NULL;
	XftColor color;

	font = win.font;
	color = win.fg_color;
	*charSize = char_d->charSize;
	if(it->chu) color = win.rubi_color;
	if(it->small){
	       	font = win.font_s;
		*charSize = char_d->charSize_s;
	}
	if(it->ej == 0) font = win.font_e;

        pix = XCreatePixmap(disp,DefaultRootWindow(disp),*charSize,*charSize,DefaultDepth(disp,0));
        XFillRectangle(disp,pix,win.bgc,0,0,*charSize,*charSize);
        *base_im = XGetImage(disp,pix,0,0,*charSize,*charSize,0xFFFF,XYPixmap);

	draw = XftDrawCreate(disp,pix,win.visual,win.cmap);

	if(it->ej == 1){
		XftDrawStringUtf8(draw,&color,font,0,*charSize-2,it->utf8,strlen(it->utf8));
	}else{
		char text[2];

		text[0] = it->c1;
		text[1] = '\0';

		XftDrawString8(draw,&color,font,2,*charSize-2,text,strlen(text));
	}
	XftDrawDestroy(draw);

	return pix;

#else
	pix = _xtext_Draw_imageString_normal(disp,win,char_d,it,type,base_im,charSize);

	return pix;
#endif

}
static XImage * get_rotate_image(      Display *disp,
                                	my_window_t win,
					char_data_t *char_d,
					ITEXT_T *it,
                                	int type        )
{
	int charSize;

	Pixmap pix;
        XImage *base_im,*char_im;
        long pixel;
        int x,y;
        int x0,x1,y0,y1;

	if(win.anti == 0){
		pix = _xtext_Draw_imageString_normal(disp,win,char_d,it,type,&base_im,&charSize);

	}else{
		pix = _xtext_Draw_imageString_anti(disp,win,char_d,it,type,&base_im,&charSize);
	}
#if debug 
fprintf(stderr,"image charSize : %d\n",charSize);
#endif

        char_im = XGetImage(disp,pix,0,0,charSize,charSize,0xFFFF,XYPixmap);
        if(type == 0 || type == 1 || type == 4){ x0=0; x1=charSize; y0=0; y1=charSize;}
	else if(type == 2){ x0=0; x1=charSize/2+2; y0=0; y1=charSize/2;}
        else if(type == 3){ x0=charSize/2; x1=charSize; y0=0; y1=charSize/2;}

        for(x=x0;x<x1;x++){
                for(y=y0;y<y1;y++){
                        pixel = XGetPixel(char_im,x,y);

                        if(type == 0){
                                XPutPixel(base_im,charSize-y-1,x,pixel);

                        }else if(type == 1){
                                XPutPixel(base_im,charSize-x-1,charSize-y-1,pixel);

                        }else if(type == 2){
                                XPutPixel(base_im,(charSize/2-2)+x-1,charSize/2+y+1,pixel);

                        }else if(type == 3){
                                XPutPixel(base_im,x-charSize/2,charSize/2+y,pixel);
                        }else if(type == 4){
                                XPutPixel(base_im,x,y,pixel);
                        }

                }
        }

        XFreePixmap(disp,pix);
        XDestroyImage(char_im);

#if debug
fprintf(stderr,"image END\n");
#endif

        return base_im;
}
static void * _image_data_insert(Display *disp,my_window_t win,char_data_t *char_d,ITEXT_T *it,int type)
{
	image_data_t *im;
	int s_type;

	if(char_d->im_head != NULL){
		for(im=char_d->im_head;im!=NULL;im=im->next){
			if(im->c1 == it->c1 && im->c2 == it->c2 && im->chu == it->chu && im->small == it->small) break;
		}
		if(im != NULL) return NULL;
	}

	im = _image_data_alloc();

	im->c1 = it->c1;
	im->c2 = it->c2;
	im->chu = it->chu;
	im->small = it->small;

	if(type == 1) s_type = 0;
	if(type == 2) s_type = 1;
	if(type == 3) s_type = 2;
	if(type == 4) s_type = 3;
	if(type == 5) s_type = 4;
	
	im->char_image = (XImage *)get_rotate_image(disp,win,char_d,it,s_type);

	_image_data_add(&char_d->im_head,&char_d->im_tail,im);

	return NULL;
}
static int _check_image_data(ITEXT_T *it)
{
	if(it->ej == 0) return 1;

	if(it->c1 == 0xa1){
		switch(it->c2){
			case 0xa1:
			case 0xa7:case 0xa8:
			case 0xbc:case 0xbd:
			case 0xc1:
			case 0xc3:case 0xc4:case 0xc5:
			case 0xca:case 0xcb:
			case 0xcc:case 0xcd:
			case 0xce:case 0xcf:
			case 0xd0:case 0xd1:
			case 0xd2:case 0xd3:
			case 0xd4:case 0xd5:
			case 0xd6:case 0xd7:
			case 0xd8:case 0xd9:
			case 0xda:case 0xdb:
			case 0xdd:
				return 1;
			break;
			case 0xa2:case 0xa3:
			/*
			case 0xc8:case 0xc9:
			*/
				return 2;
			break;
			case 0xc9:
				return 3;
			break;
			case 0xc8:
				return 4;
			break;
		}
	}else if(it->c1 == 0xa2){
		switch(it->c2){
			case 0xaa:case 0xab:case 0xac:case 0xad:
				return 1;
			break;
		}
	}else if(it->c1 == 0xa8){
		switch(it->c2){
			case 0xa1:
				return 1;
			break;
		}
	}else if(it->c1 == 0xa4){
		switch(it->c2){
			case 0xa1:case 0xa3:case 0xa5:case 0xa7:case 0xa9:case 0xc3:
			case 0xe3:case 0xe5:case 0xe7:case 0xee:
				return 5;
			break;
		}
	}else if(it->c1 == 0xa5){
		switch(it->c2){
			case 0xa1:case 0xa3:case 0xa5:case 0xa7:case 0xa9:
			case 0xc3:case 0xe3:case 0xee:case 0xf6:
				return 5;
			break;
		}
	}

	return 0;
}
static int _xtext_get_normalfont_size(my_window_t win,int *charSize,int *charSize_s,int *charSize_e,int *charSize_r)
{
	char *str = "";
	char *str_e = "A";
	XRectangle ink,log;

	XmbTextExtents(win.fs,str,strlen(str),&ink,&log);
	*charSize = log.width >= log.height ? log.width+2 : log.height+2;

	XmbTextExtents(win.fs_s,str,strlen(str),&ink,&log);
	*charSize_s = log.width >= log.height ? log.width+2 : log.height+2;

	XmbTextExtents(win.fs,str_e,strlen(str_e),&ink,&log);
	*charSize_e = log.width+2;

	if(win.rubi_fs != NULL){
		XmbTextExtents(win.rubi_fs,str,strlen(str),&ink,&log);
		*charSize_r = log.width >= log.height ? log.width : log.height;
	}

	return 0;
}
static int _xtext_get_antifont_size(Display *disp,my_window_t win,int *charSize,int *charSize_s,int *charSize_e,int *charSize_r)
{
#if HAVE_LIBXFT
	char *str = "";
	char *str_e = "A";

	XGlyphInfo gi;
	iconv_t con;
	char *utf8;

	con = iconv_open("UTF-8","EUC-JP");
	utf8 = (char *)euc2utf8(con,str,strlen(str));

	XftTextExtentsUtf8(disp,win.font,utf8,strlen(utf8),&gi);
	*charSize = gi.width >= gi.height ? gi.width+2 : gi.height+2;

	XftTextExtentsUtf8(disp,win.font_s,utf8,strlen(utf8),&gi);
	*charSize_s = gi.width >= gi.height ? gi.width+2 : gi.height+2;

	XftTextExtents8(disp,win.font_e,str_e,strlen(str_e),&gi);
	*charSize_e = gi.width+4;

	if(win.rubi_fs != NULL){
		utf8 = (char *)euc2utf8(con,str,strlen(str));
		XftTextExtentsUtf8(disp,win.font_rubi,utf8,strlen(utf8),&gi);
		*charSize_r = gi.width >= gi.height ? gi.width : gi.height;
	}

	if(utf8) free(utf8);
	iconv_close(con);
#else

	_xtext_get_normalfont_size(win,charSize,charSize_s,charSize_e,charSize_r);

#endif

	return 0;
}
int xtext_get_charsize(Display *disp,my_window_t win,IBUF_T *l_head,char_data_t *ct)
{
	IBUF_T *ib;
	ITEXT_T *it;

	int charSize=0,charSize_s=0,charSize_e=0,charSize_r=0;
	int x,y,h,xpad;
	int page_char_no = 0;
	int total_page = 0;
	int one_line,start_line,end_line,start_low,end_low;
	int type;


	if(win.fs == NULL){
		fprintf(stderr,"ERROR : Font False\n");
		exit(1);
	}

#if debug
fprintf(stderr,"ANTI : %d\n",win.anti);
#endif

	if(win.anti == 0){
		_xtext_get_normalfont_size(win,&charSize,&charSize_s,&charSize_e,&charSize_r);

	}else{
		_xtext_get_antifont_size(disp,win,&charSize,&charSize_s,&charSize_e,&charSize_r);
	}


#if debug
fprintf(stderr,"size : %d size_s %d size_e %d : size_r %d\n",charSize,charSize_s,charSize_e,charSize_r);
fprintf(stderr,"Get CharSize End\n");
#endif

	ct->charSize = charSize;
	ct->charSize_s = charSize_s;
	ct->charSize_e = charSize_e;
	ct->charSize_r = charSize_r;


	if(ct->im_head != NULL) _image_data_free(&ct->im_head,&ct->im_tail);
	if(ct->head != NULL) _page_data_free(&ct->head,&ct->tail);

	xpad = ct->xpad;

	one_line = charSize + xpad + charSize_r;
	start_line = win.width - one_line;
	end_line = 0;

	start_low = charSize * 2;
	end_low = win.height - charSize;

	x = start_line;
	y = start_low;

	_page_data_insert(&ct->head,&ct->tail,0,total_page++);
	for(ib=l_head;ib!=NULL;ib=ib->next){
		for(it=ib->i_head;it!=NULL;it=it->next){
			if((type = _check_image_data(it)) > 0){
				_image_data_insert(disp,win,ct,it,type);
			}

			h = xtext_get_low_space(it,ct);

			page_char_no++;
			if((y += h) > end_low && xtext_next_kuten(it)==0){
				if((x -= one_line) < end_line){
					_page_data_insert(&ct->head,&ct->tail,page_char_no,total_page++);
					x = start_line;
				}
				y = start_low;
			}
		}
		if((x -= one_line) < end_line){
			_page_data_insert(&ct->head,&ct->tail,page_char_no,total_page++);
			x = start_line;
		}
		y = start_low;
	}
	ct->book->total_page = total_page;

#if debug
fprintf(stderr,"Get Total_Page %d\n",total_page);
#endif

	return total_page;
}
