#include "itext.h"
#include "xtext.h"
#include <dirent.h>

static unsigned char *base_str = "";

static sub_window_t * _subwindow_data_alloc()
{
	sub_window_t *sw;

	sw = (sub_window_t *)malloc(sizeof(sub_window_t));

	return sw;
}
static void * _subwindow_data_free(sub_window_t **head,sub_window_t **tail)
{
	sub_window_t *sw,*sww;

	for(sw = *head;sw!=NULL;sw=sww){
		sww = sw->next;

		free(sw);
	}

	*head = NULL;
	*tail = NULL;

	return NULL;
}
static void * _subwindow_data_add(sub_window_t **head,sub_window_t **tail,sub_window_t *im)
{
	if(*tail){
                im->next = NULL;
                im->prev = *tail;

                (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }

        return NULL;
}

int xtextHelpData2Sub(sub_window_t **head,sub_window_t **tail,char *help)
{
	sub_window_t *sw;
	char *p,temp[BUFSIZ];
	int a,i;

	if(*head != NULL) _subwindow_data_free(head,tail);

	i=0;
	a=0;
	for(p=help;*p;p++){
		if(*p == '\n'){
			temp[a] = '\0';
			a = 0;

			sw = (sub_window_t *)_subwindow_data_alloc();
			strcpy(sw->line_str,temp);
			sw->re_str[0] = '\0';
			sw->line_no = i++;
			_subwindow_data_add(head,tail,sw);
		}
		temp[a++] = *p;
	}

	return 0;
}
int xtextSioriData2Sub(sub_window_t **head,sub_window_t **tail,xtext_siori_t *s_head)
{
	sub_window_t *sw;
	xtext_siori_t *si;
	int i;

	if(s_head == NULL) return -1;
	if(*head != NULL) _subwindow_data_free(head,tail);

	for(si=s_head,i=1;si!=NULL;si=si->next,i++){
		sw = (sub_window_t *)_subwindow_data_alloc();
		sprintf(sw->line_str,"%s (%s)",si->book_title,si->book_time);
		strcpy(sw->re_str,si->book_path);
		sw->line_no = i;

		_subwindow_data_add(head,tail,sw);
	}

	return 0;
}
int xtextBookData2Sub(sub_window_t **head,sub_window_t **tail,char *dname)
{
	sub_window_t *sw;

	IBOOK_T *bhead = NULL, *btail = NULL;
	IBOOK_T *ib;

	int i,total;

	if(*head != NULL) _subwindow_data_free(head,tail);

	total = ibookGetFileData(&bhead,&btail,dname);

	for(ib=bhead,i=1;ib!=NULL;ib=ib->next,i++){
		sw = (sub_window_t *)_subwindow_data_alloc();

		sprintf(sw->line_str,"%s (%s)",ib->title,ib->filename);
		strcpy(sw->re_str,ib->fullpath);
		sw->line_no = i;

		_subwindow_data_add(head,tail,sw);

	}
	book_link_free(&bhead,&btail);

	return 0;
}
static int _Draw_SubWindow_Text(	Display *disp,
					my_subwindow_t swin,
					int fh,
					sub_window_t *head,
					sub_window_t *tail,
					sub_window_t *CSW,
					int PY	)
{
	Drawable pwin;
	Pixmap pix;
	sub_window_t *psw,*nsw,*sw;

	int i,x,y,CY;

	pwin = swin.win;
	XClearWindow(disp,pwin);

	x = 5;
	CY = PY * fh;
	XmbDrawImageString(disp,pwin,swin.fs,swin.rfgc,x,CY,CSW->line_str,strlen(CSW->line_str));

	for(sw=CSW->prev,i=1;sw!=NULL;sw=sw->prev,i++){
		if((y = CY - (i * fh)) < fh) break;
		XmbDrawString(disp,pwin,swin.fs,swin.fgc,x,y,sw->line_str,strlen(sw->line_str));
	}
	for(sw=CSW->next,i=1;sw!=NULL;sw=sw->next,i++){
		if((y = CY + (i * fh)) > swin.height) break;
		XmbDrawString(disp,pwin,swin.fs,swin.fgc,x,y,sw->line_str,strlen(sw->line_str));
	}

	return 0;
}
char * xtextSubWindow(Display *disp,my_window_t win,sub_window_t *head,sub_window_t *tail)
{
	sub_window_t *st;
	int line = 0,sh;

	int percent = 80;
	char *result = NULL;

	my_subwindow_t swin;
	XEvent event;
	KeySym keysym;
	XRectangle ink,log;

	int x,y,loop = 1;

	int fh;

	sub_window_t *CSW;
	int PY,H_LINE;


	swin.fs = win.fs_s;
	swin.gc = win.gc;
	swin.bgc = win.bgc;
	swin.fgc = win.fgc;
	swin.rfgc = win.rfgc;
	swin.sgc = win.sgc;

	swin.fg_pixel = win.menu_fg_pixel;
	swin.bg_pixel = win.menu_bg_pixel;

	swin.parent_win = win.win;
	swin.width = (win.width * percent) / 100;
	swin.height = (win.height * percent) / 100;

	XmbTextExtents(swin.fs,base_str,strlen(base_str),&ink,&log);
	fh = log.height + 5;

	for(st=head;st!=NULL;st=st->next){
		line++;
	}
	sh = line * fh + 5;
	if(sh < swin.height) swin.height = sh;

	swin.x = (win.width - swin.width) / 2;
	swin.y = (win.height - swin.height) / 2;

	swin.win = XCreateSimpleWindow(disp,swin.parent_win,swin.x,swin.y,swin.width,swin.height,0,swin.fg_pixel,swin.bg_pixel);
	XSelectInput(disp,swin.win,ExposureMask|KeyPressMask);
	XMapRaised(disp,swin.win);



	H_LINE = swin.height / fh;
	PY = 1;
	CSW = head;
	while(loop){
		usleep(50);
		while(XPending(disp)){
			XNextEvent(disp,&event);
			switch(event.type){
				case Expose:
					_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY);
				break;
				case KeyPress:
					keysym = XLookupKeysym(&event.xkey,0);
					switch(keysym){
						case XK_Return:
							result = CSW->re_str;
							loop = 0;
						break;
						case XK_q:
							loop = 0;
						break;
						case XK_Up:
							if(CSW->prev == NULL) break;
							CSW = CSW->prev;
							if(PY-- <= 1) PY = 1;
							_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY);
						break;
						case XK_Down:
							if(CSW->next == NULL) break;
							CSW = CSW->next;
							if(PY++ >= H_LINE) PY = H_LINE;
							_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY);
						break;
					}
				break;
			}
		}
	}

	XDestroyWindow(disp,swin.win);

	return result;
}
int xtextSubWindow_Message(Display *disp,my_window_t win,unsigned char *message)
{
	my_subwindow_t swin;
	XRectangle ink,log;

	int x,y;
	int message_len;


	swin.fs = win.fs_s;
	swin.gc = win.gc;
	swin.bgc = win.bgc;
	swin.fgc = win.fgc;
	swin.rfgc = win.rfgc;
	swin.sgc = win.sgc;

	swin.fg_pixel = win.menu_fg_pixel;
	swin.bg_pixel = win.menu_bg_pixel;
	swin.parent_win = win.win;

	message_len = strlen(message);
	XmbTextExtents(swin.fs,message,message_len,&ink,&log);

	swin.width = log.width + 4;
	swin.height = log.height + 4;

	swin.x = (win.width - swin.width) / 2;
	swin.y = (win.height - swin.height) / 2;

	swin.win = XCreateSimpleWindow(disp,swin.parent_win,swin.x,swin.y,swin.width,swin.height,0,swin.fg_pixel,swin.bg_pixel);
	XMapRaised(disp,swin.win);

	XmbDrawString(disp,swin.win,swin.fs,swin.fgc,2,log.height,message,message_len);
	XFlush(disp);


	sleep(2);


	XDestroyWindow(disp,swin.win);

	return 0;
}


	


















