#include "itext.h"
#include "unzip.h"

static int _unzipLog(char *s)
{
	FILE *fp;

	fp = fopen("./unzip.log","a");

	fprintf(fp,"%s\n",s);

	fclose(fp);

	return 0;
}
static int _checkFileType(char *fname)
{
	char *p;

	for(p=fname+strlen(fname)-1;*p;p--){
		if(*p == '.') break;
	}

	if(strcmp(p,".txt")==0 || strcmp(p,".TXT")==0 || strcmp(p,".text")==0 || strcmp(p,".TEXT")==0) return 1;

	return 0;
}
int itextUnZipFile(char *file_path,char *get_file_path)
{
	char log[100];

	char gcomment[256];
	char filename[256];

	void *un_buf;
	int un_size;

	unzFile *fz;
	unz_global_info ginfo;
	unz_file_info finfo;

	int i;

	if((fz = unzOpen(file_path)) == NULL){
		sprintf(log,"unzip : False Open File %s",file_path);
		_unzipLog(log);
		return -1;
	}

	if(unzGetGlobalInfo(fz,&ginfo) != UNZ_OK){
		_unzipLog("unzip : False unzGetGloblInfo()");
		return -1;
	}

	if(unzGetGlobalComment(fz,gcomment,256) < 0){
		_unzipLog("unzip : False unzGetGlobalComment()");
	}

	if(unzGoToFirstFile(fz) != UNZ_OK){
		_unzipLog("unzip : False unzGoToFirstFile()");
		return -1;
	}


	for(i=0;i<ginfo.number_entry;i++){

		unzGetCurrentFileInfo(fz,&finfo,filename,sizeof(filename),NULL,0,NULL,0);

		if(_checkFileType(filename)){
			FILE *fp;

			sprintf(get_file_path,"./%s",filename);
			if((fp = fopen(get_file_path,"wb")) == NULL){
				sprintf(log,"unzip : False Open File (%s)",get_file_path);
				_unzipLog(log);
				return -1;
			}

			unzOpenCurrentFile(fz);

			un_buf = (void *)malloc(BUFSIZ);
			while((un_size = unzReadCurrentFile(fz,un_buf,BUFSIZ)) > 0){

				fwrite(un_buf,un_size,1,fp);

			}
			free(un_buf);
			unzCloseCurrentFile(fz);
			fclose(fp);

			break;
		}

		unzGoToNextFile(fz);
	}

	unzClose(fz);

	return finfo.uncompressed_size;
}
