#include "itext.h"
#include "xtext.h"

#include <stdarg.h>
#include <locale.h>

#define debug 0

extern int opterr;
extern int optind;
extern char *optarg;
extern int getopt(int argc,char * const * argv,const char * pattern);

static xtext_siori_t *siori_head = NULL, *siori_tail = NULL;
static sub_window_t *book_head = NULL,*book_tail = NULL,*bh;
static sub_window_t *si_head = NULL,*si_tail = NULL;
static sub_window_t *help_head = NULL, *help_tail = NULL;

static IBUF_T *line_head = NULL, *line_tail = NULL;
static char_data_t char_d;
static page_data_t *char_p;
static int NPC = 0;

static Display *disp;
static Window root;
static my_window_t main_win;

static xtext_conf_t xconf_default = {
	500,
	400,
	"lavender",
	"Black",
	"gray60",
	"SteelBlue",
	"SteelBlue",
	"White",
	"-misc-fixed-*-*-*-*-14-*-*-*-*-*-*-*",
	"-misc-fixed-*-*-*-*-14-*-*-*-*-*-*-*",
	"-misc-*-*-*-*-*-12-*-*-*-*-*-*-*",
	"/home/becho/programing/txt/book/",
	"-misc-*-*-*-*-*-10-*-*-*-*-*-*-*",
	0,
	1,
	0,
	0,
	"Down",
	"Up",
	"h",
	"space",
	"s",
	"q",
	"f",
	"Tab"	
};
static xtext_conf_t xconf;
static unsigned char MESSAGE[][256] = {
	"ˡ Ϥߤޤ",
	"¸ʸˤ̵ѥǤ",
	"٤Ϥޤ줿޽ϡޤ"
};
static unsigned char HELP_STR[BUFSIZ];
static int _init_help()
{
	HELP_STR[0] = '\0';

	sprintf(HELP_STR,"%s¸ʸ          : %s\n",HELP_STR,xconf.book_dir);
	sprintf(HELP_STR,"%s[ ]\n",HELP_STR);
	sprintf(HELP_STR,"%sڡ          : %s\n",HELP_STR,xconf.page_next);
	sprintf(HELP_STR,"%sڡ          : %s\n",HELP_STR,xconf.page_prev);
	sprintf(HELP_STR,"%sڡ        : %s\n",HELP_STR,xconf.conf_page);
	sprintf(HELP_STR,"%sٵϿ            : %s\n",HELP_STR,xconf.book_mark);
	sprintf(HELP_STR,"%s٥˥塼        : %s\n",HELP_STR,xconf.siori_menu);
	sprintf(HELP_STR,"%s˥塼          : %s\n",HELP_STR,xconf.menu);
	sprintf(HELP_STR,"%sλ              : %s\n",HELP_STR,xconf.quit);
	sprintf(HELP_STR,"%sȥ  on_off  : %s\n",HELP_STR,xconf.title_key);
	sprintf(HELP_STR,"%s[ɥ ]\n",HELP_STR);
	sprintf(HELP_STR,"%sɥ  : %d\n",HELP_STR,xconf.main_window_width);
	sprintf(HELP_STR,"%sɥ⤵: %d\n",HELP_STR,xconf.main_window_height);
	sprintf(HELP_STR,"%sɥ      : %s\n",HELP_STR,xconf.main_window_color);
	sprintf(HELP_STR,"%sʸ            : %s\n",HELP_STR,xconf.main_font_color);
	sprintf(HELP_STR,"%sʸ        : %s\n",HELP_STR,xconf.rubi_font_color);
	sprintf(HELP_STR,"%s˥塼  : %s\n",HELP_STR,xconf.menu_window_color);
	sprintf(HELP_STR,"%s˥塼ʸ    : %s\n",HELP_STR,xconf.menu_font_color);
	sprintf(HELP_STR,"%sʸƿ          : %s\n",HELP_STR,xconf.main_shadow_color);
	sprintf(HELP_STR,"%sᥤե(J) : %s\n",HELP_STR,xconf.main_font_j);
	sprintf(HELP_STR,"%s ե(Small)  : %s\n",HELP_STR,xconf.main_font_s);
	sprintf(HELP_STR,"%s ե(E)      : %s\n",HELP_STR,xconf.main_font_e);
	sprintf(HELP_STR,"%s ե     : %s\n",HELP_STR,xconf.rubi_font);
	sprintf(HELP_STR,"%sԴ              : %d\n",HELP_STR,xconf.line_space);
	sprintf(HELP_STR,"%sʸ            : %d\n",HELP_STR,xconf.row_space);
	sprintf(HELP_STR,"%sXft2              : %d\n",HELP_STR,xconf.anti);
	sprintf(HELP_STR,"%sȥɽ      : %d\n",HELP_STR,xconf.title_on);


	return 0;
}
static void _usage()
{
	fprintf(stderr,"\n");
	fprintf(stderr,"    %s  Version : %s\n",XTEXT_NAME,XTEXT_VERSION);
	fprintf(stderr,"\n");

	exit(1);
}	
static void _set_util()
{
	main_win.title_on = xconf.title_on;
	main_win.anti = xconf.anti;
}
static int _set_window_size()
{
	main_win.width = xconf.main_window_width;
	main_win.height = xconf.main_window_height;
}
static void _set_x_init()
{
	setlocale(LC_ALL,"");

	disp = XOpenDisplay(NULL);
	root = DefaultRootWindow(disp);
	main_win.cmap = DefaultColormap(disp,0);
	main_win.visual = DefaultVisual(disp,0);

	main_win.gc = XCreateGC(disp,root,0,0);
	main_win.bgc = XCreateGC(disp,root,0,0);
	main_win.fgc = XCreateGC(disp,root,0,0);
	main_win.rfgc = XCreateGC(disp,root,0,0);
	main_win.rubi_gc = XCreateGC(disp,root,0,0);
	main_win.sgc = XCreateGC(disp,root,0,0);
}
static void _set_color()
{
	XColor bg0,bg1;
	XColor fg0,fg1;
	XColor menu_font_color0,menu_font_color1;
	XColor menu_window_color0,menu_window_color1;
	XColor rubi_fg0,rubi_fg1;
	XColor shadow_fg0,shadow_fg1;

	XAllocNamedColor(disp,main_win.cmap,xconf.main_font_color,&fg1,&fg0);
	XAllocNamedColor(disp,main_win.cmap,xconf.main_window_color,&bg1,&bg0);
	XAllocNamedColor(disp,main_win.cmap,xconf.menu_font_color,&menu_font_color1,&menu_font_color0);
	XAllocNamedColor(disp,main_win.cmap,xconf.menu_window_color,&menu_window_color1,&menu_window_color0);
	XAllocNamedColor(disp,main_win.cmap,xconf.rubi_font_color,&rubi_fg1,&rubi_fg0);
	XAllocNamedColor(disp,main_win.cmap,xconf.main_shadow_color,&shadow_fg1,&shadow_fg0);

	XSetForeground(disp,main_win.gc,fg1.pixel);
	XSetForeground(disp,main_win.bgc,bg1.pixel);
	XSetForeground(disp,main_win.fgc,menu_font_color1.pixel);
	XSetForeground(disp,main_win.rfgc,menu_window_color1.pixel);
	XSetForeground(disp,main_win.rubi_gc,rubi_fg1.pixel);
	XSetForeground(disp,main_win.sgc,shadow_fg1.pixel);

	XSetBackground(disp,main_win.gc,bg1.pixel);
	XSetBackground(disp,main_win.bgc,fg1.pixel);
	XSetBackground(disp,main_win.fgc,menu_window_color1.pixel);
	XSetBackground(disp,main_win.rfgc,menu_font_color1.pixel);

	main_win.fg_pixel = fg1.pixel;
	main_win.bg_pixel = bg1.pixel;
	main_win.menu_fg_pixel = menu_font_color1.pixel;
	main_win.menu_bg_pixel = menu_window_color1.pixel;

#if HAVE_LIBXFT
	XftColorAllocName(disp,main_win.visual,main_win.cmap,xconf.main_window_color,&(main_win.bg_color));
	main_win.bg_color.color.alpha = 0xFFFF;

	XftColorAllocName(disp,main_win.visual,main_win.cmap,xconf.main_font_color,&(main_win.fg_color));
	main_win.fg_color.color.alpha = 0xFFFF;

	XftColorAllocName(disp,main_win.visual,main_win.cmap,xconf.rubi_font_color,&(main_win.rubi_color));
	main_win.fg_color.color.alpha = 0xCCCC;
#endif
}
static void _set_font()
{
	char **miss,*def;
	int n_miss;

	main_win.fs = XCreateFontSet(disp,xconf.main_font_j,&miss,&n_miss,&def);
	main_win.fs_e = XCreateFontSet(disp,xconf.main_font_e,&miss,&n_miss,&def);
	main_win.fs_s = XCreateFontSet(disp,xconf.main_font_s,&miss,&n_miss,&def);
	main_win.rubi_fs = XCreateFontSet(disp,xconf.rubi_font,&miss,&n_miss,&def);

#if HAVE_LIBXFT
	main_win.font = XftFontOpenXlfd(disp,0,xconf.main_font_j);
	main_win.font_e = XftFontOpenXlfd(disp,0,xconf.main_font_e);
	main_win.font_s = XftFontOpenXlfd(disp,0,xconf.main_font_s);
	main_win.font_rubi = XftFontOpenXlfd(disp,0,xconf.rubi_font);
#endif

}
static void _set_drawable()
{
	main_win.win = XCreateSimpleWindow(disp,root,0,0,main_win.width,main_win.height,3,main_win.fg_pixel,main_win.bg_pixel);

	XSelectInput(disp,main_win.win,	ExposureMask|StructureNotifyMask|ButtonPressMask|KeyPressMask);

	XMapWindow(disp,main_win.win);
#if HAVE_LIBXFT
	main_win.draw = XftDrawCreate(disp,main_win.win,main_win.visual,main_win.cmap);
#endif

}
static void _set_char()
{
	char_d.xpad = xconf.line_space != -1 ? xconf.line_space:0;
	char_d.ypad = xconf.row_space != -1 ? xconf.row_space:0;

	char_d.im_head = NULL;
	char_d.im_tail = NULL;

	char_d.head = NULL;
	char_d.tail = NULL;

	char_d.book = NULL;
}
static page_data_t * _get_page_data(page_data_t *head,int no)
{
	page_data_t *p;

	for(p=head;p!=NULL;p=p->next){
		if(p->next == NULL) return p;

		if(no >= p->char_no && no < p->next->char_no) return p;
	}

	return head;
}
static int _init_book_data(char *book_name,int n)
{
	iconv_t con;
	char *utf8;
	unsigned char title[256];

#if debug
fprintf(stderr,"main_bookname : %s %d\n",book_name,n);
#endif

	NPC = n;

	if(line_head != NULL) ibuf_data_free(line_head,line_tail);
	if(char_d.book != NULL) free(char_d.book);

	con = iconv_open("UTF-8","EUC-JP");
	char_d.book = (book_data_t *)malloc(sizeof(book_data_t));

	line_head = NULL;
	line_tail = NULL;
	if(itextGetTextData(book_name,title,&line_head,&line_tail)<0) return -1;
#if debug
fprintf(stderr,"main_booktitle : %s\n",title);
#endif
	utf8 = (char *)euc2utf8(con,title,strlen(title));

	strcpy(char_d.book->book_path,book_name);
	strcpy(char_d.book->book_title,title);
	strcpy(char_d.book->book_title_utf8,utf8);

	xtext_get_charsize(disp,main_win,line_head,&char_d);
	char_p = _get_page_data(char_d.head,NPC);

	XStoreName(disp,main_win.win,book_name);

	if(utf8) free(utf8);
	iconv_close(con);

	return 0;

}
static void _help_book_data()
{
	xtextHelpData2Sub(&help_head,&help_tail,HELP_STR);

	xtextSubWindow(disp,main_win,help_head,help_tail);

}
static void _select_book_data(char *book_dir)
{
	char *book_path;

#if debug
fprintf(stderr,"main_selectdir : %s\n",book_dir);
#endif
	xtextBookData2Sub(&book_head,&book_tail,book_dir);
	if(book_head == NULL){
		xtextSubWindow_Message(disp,main_win,MESSAGE[1]);
		return ;
	}

	if((book_path = (char *)xtextSubWindow(disp,main_win,book_head,book_tail)) == NULL)
		return ;
#if debug
fprintf(stderr,"main_selectpath : %s\n",book_dir);
#endif
       	_init_book_data(book_path,0);

}
static void _siori_book_data()
{
	char *book_path;
	xtext_siori_t *si;

	xtextSioriData2Sub(&si_head,&si_tail,siori_head);
	if(si_head == NULL){
		xtextSubWindow_Message(disp,main_win,MESSAGE[2]);
		return ;
	}

	if((book_path = (char *)xtextSubWindow(disp,main_win,si_head,si_tail)) == NULL) return ;

	for(si=siori_head;si!=NULL;si=si->next){
		if(strcmp(si->book_path,book_path)==0){
			_init_book_data(book_path,si->NPC);
			return;
		}
	}

}
static int _xtext_event()
{
	XEvent ev;
	char *keyname;

	XNextEvent(disp,&ev);

	switch(ev.type){
		case Expose:
			NPC = xtext_Draw_Text(disp,main_win,line_head,char_d,char_p);
		break;
		case ConfigureNotify:
			if(main_win.width != ev.xconfigure.width || main_win.height != ev.xconfigure.height){
				xconf.main_window_width = ev.xconfigure.width;
				xconf.main_window_height = ev.xconfigure.height;
				_set_window_size();

				xtext_get_charsize(disp,main_win,line_head,&char_d);
				char_p = _get_page_data(char_d.head,NPC);
			}
		break;
		case KeyPress:
			keyname = (char *)XKeysymToString(XLookupKeysym(&ev.xkey,0)); 

			if(strcmp(keyname,xconf.menu)==0){
				_select_book_data(xconf.book_dir);
				xtext_siori_data_write(&siori_head,&siori_tail);

			}else if(strcmp(keyname,xconf.conf_page)==0){
				_help_book_data();

			}else if(strcmp(keyname,xconf.book_mark)==0){
			   	xtext_siori_data_mark(&siori_head,&siori_tail,char_d.book->book_path,char_d.book->book_title,NPC);
				xtextSubWindow_Message(disp,main_win,MESSAGE[0]);

			}else if(strcmp(keyname,xconf.siori_menu)==0){
				_siori_book_data();

			}else if(strcmp(keyname,xconf.quit)==0){
				return 0;

			}else if(strcmp(keyname,xconf.page_next)==0){
				if(line_head == NULL || char_p->next == NULL) break;

				char_p = char_p->next;
				NPC = xtext_Draw_Text(disp,main_win,line_head,char_d,char_p);

			}else if(strcmp(keyname,xconf.page_prev)==0){
				if(line_head == NULL || char_p->prev == NULL) break;

				char_p = char_p->prev;
				NPC = xtext_Draw_Text(disp,main_win,line_head,char_d,char_p);

			}else if(strcmp(keyname,xconf.title_key)==0){
				if(xconf.title_on)
				      	xconf.title_on = 0;
				else
					xconf.title_on = 1;	

				_set_util();

				NPC = xtext_Draw_Text(disp,main_win,line_head,char_d,char_p);
			}
		break;
	}

	return 1;
}
static char * _get_option(int c,char **v)
{
	int option;

	while(1){
		if((option = getopt(c,v,"f:h")) == -1) break;
		switch(option){
			case 'h': _usage(); break;
			case 'f': return optarg; break;
			default: _usage(); break;
		}
	}

	return NULL;
}
int main(int argc,char *argv[])
{
	int loop = 1;

	_get_option(argc,argv);

	xtext_conf_data(&xconf,xconf_default);

#if debug
fprintf(stderr,"width:%d\n",xconf.main_window_width);
fprintf(stderr,"height:%d\n",xconf.main_window_height);
fprintf(stderr,"w_color:%s\n",xconf.main_window_color);
fprintf(stderr,"f_color:%s\n",xconf.main_font_color);
fprintf(stderr,"s_color:%s\n",xconf.main_shadow_color);
fprintf(stderr,"r_color:%s\n",xconf.rubi_font_color);
fprintf(stderr,"m_color:%s\n",xconf.menu_window_color);
fprintf(stderr,"mf_color:%s\n",xconf.menu_font_color);
fprintf(stderr,"m_font:%s\n",xconf.main_font_j);
fprintf(stderr,"s_font:%s\n",xconf.main_font_s);
fprintf(stderr,"e_font:%s\n",xconf.main_font_e);
fprintf(stderr,"dir:%s\n",xconf.book_dir);
fprintf(stderr,"r_font:%s\n",xconf.rubi_font);
fprintf(stderr,"anti:%d\n",xconf.anti);
fprintf(stderr,"title:%d\n",xconf.title_on);
fprintf(stderr,"line:%d\n",xconf.line_space);
fprintf(stderr,"row:%d\n",xconf.row_space);
fprintf(stderr,"next:%s\n",xconf.page_next);
fprintf(stderr,"prev:%s\n",xconf.page_prev);
fprintf(stderr,"conf:%s\n",xconf.conf_page);
fprintf(stderr,"mark:%s\n",xconf.book_mark);
fprintf(stderr,"siori:%s\n",xconf.siori_menu);
fprintf(stderr,"quit:%s\n",xconf.quit);
fprintf(stderr,"menu:%s\n",xconf.menu);
fprintf(stderr,"t_key:%s\n",xconf.title_key);
#endif

	_set_x_init();
	_set_color();
	_set_font();
	_set_char();
	_set_window_size();
	_set_drawable();

	_set_util();
	_init_help();

	xtext_siori_data_read(&siori_head,&siori_tail);

	while(loop){
		while(XPending(disp)){
			loop = _xtext_event();
		}
		usleep(500);
	}

	xtext_siori_data_write(&siori_head,&siori_tail);

	return 0;
}



































