#include "itext.h"
#include "xtext.h"

#define debug 0

int XtextDrawString(	Display *disp,
			my_window_t win,
			char_data_t char_d,
			ITEXT_T *it,
			int x,
			int y		)
{
	GC gc;
	XFontSet fs;
	char text[3];

	text[0] = it->c1;
	text[1] = it->c2;
	text[2] = '\0';

#if debug
fprintf(stderr,"Normal_String : %s   ",text);
#endif

	gc = win.gc;
	fs = win.fs;
	if(it->chu) gc = win.rubi_gc;
	if(it->small) fs = win.fs_s;

	XmbDrawString(disp,win.win,fs,gc,x,y,text,strlen(text));

#if debug
fprintf(stderr,"END\n");
#endif
	return 0;
}
int XtextDrawAntiString(	Display *disp,
				my_window_t win,
				char_data_t char_d,
				ITEXT_T *it,
				int x,
				int y		)
{
#if HAVE_LIBXFT

	XftFont *font;
	XftColor color;
	XGlyphInfo gi;
	int xoff;

	font = win.font;
	color = win.fg_color;

	if(it->chu) color = win.rubi_color;
	if(it->small) font = win.font_s;
/*
	XftTextExtentsUtf8(disp,font,it->utf8,strlen(it->utf8),&gi);
	if(it->small){
		xoff = char_d.s_off - gi.xOff;
	}else{
		xoff = char_d.m_off - gi.xOff;
	}
	*/

	XftDrawStringUtf8(win.draw,&color,font,x/*+xoff*/,y,it->utf8,strlen(it->utf8));
#else

	XtextDrawString(disp,win,char_d,it,x,y);

#endif

	return 0;
}
static int XtextDrawImageString(	Display *disp,
					my_window_t win,
					char_data_t char_d,
					ITEXT_T *it,
					int x0,
					int y0	)

{
	XImage *image_str = NULL;
	image_data_t *im;
	int x,y;
	int charSize;

	for(im=char_d.im_head;im!=NULL;im=im->next){
		if(im->c1 == it->c1 && im->c2 == it->c2 && im->chu == it->chu && im->small == it->small){
			image_str = im->char_image;
			break;
		}
	}
	if(image_str == NULL) return -1;

	x = x0;
	y = y0 - char_d.charSize + 3;
	charSize = char_d.charSize;
	if(it->small == 1) charSize = char_d.charSize_s;
	XPutImage(disp,win.win,win.gc,image_str,0,0,x,y,charSize,charSize);


	return 0;
}
static int XtextDrawRubiString(	Display *disp,
				my_window_t win,
				char_data_t char_d,
				ITEXT_T *it,
				int x0,
				int y0	)
{
	ITEXT_T *rb;
	unsigned char text[3];
	int k_len=0,r_len=0;
	int x,y;

	if(win.rubi_fs == NULL) return -1;

	for(rb=it;rb!=NULL;rb=rb->prev){
		if(!(rb->c1 >= 0xb0)) break;
		k_len = k_len + (char_d.charSize + char_d.ypad);
	}
	for(rb=it->rubi_head;rb!=NULL;rb=rb->next){
		r_len = r_len + char_d.charSize_r;
	}

	if(k_len >= r_len){
		y = y0;
	}else{
		if((y = y0 + ((r_len - k_len)/2)) > win.height-2) y = y0;
	}
	if(y - r_len < 0) y = r_len;

	x = x0;
	for(rb=it->rubi_tail;rb!=NULL;rb=rb->prev){
		text[0] = rb->c1;
		text[1] = rb->c2;
		text[2] = '\0';

		if(win.anti == 0){
			XmbDrawString(disp,win.win,win.rubi_fs,win.rubi_gc,x,y,text,2);
		}else{
#if HAVE_LIBXFT
			XftDrawStringUtf8(win.draw,&(win.rubi_color),win.font_rubi,x,y,rb->utf8,strlen(rb->utf8));
#else
			XmbDrawString(disp,win.win,win.rubi_fs,win.rubi_gc,x,y,text,2);
#endif
		}

		y = y - char_d.charSize_r;
	}

	return 0;
}
static int XtextDrawBoutenString(	Display *disp,
					my_window_t win,
					char_data_t char_d,
					unsigned char *text,
					int x0,
					int y0			)
{
	int ypad;

	if(win.rubi_fs == NULL) return -1;

	ypad = (char_d.charSize - char_d.charSize_r) / 2;
	XmbDrawString(disp,win.win,win.fs,win.gc,x0,y0-ypad,text,2);

	return 0;
}
static int _Draw_String(	Display *disp,
				my_window_t win,
				char_data_t char_d,
				ITEXT_T *it,
				int x,
				int y	)
{
	unsigned char bouten_text[3];

	bouten_text[0] = 0xa1;
	bouten_text[1] = 0xa6;
	bouten_text[2] = '\0';

	if(it->ej == 1){
		if(XtextDrawImageString(disp,win,char_d,it,x,y) < 0){

			if(win.anti == 0){
				XtextDrawString(disp,win,char_d,it,x,y);
			}else{
				XtextDrawAntiString(disp,win,char_d,it,x,y);
			}

			if(it->bouten == 1) XtextDrawBoutenString(disp,win,char_d,bouten_text,x+char_d.charSize-6,y+2);

			if(it->rubi_head != NULL) XtextDrawRubiString(disp,win,char_d,it,x+char_d.charSize-2,y);
			

		}
	}else{
		XtextDrawImageString(disp,win,char_d,it,x,y);
	}


	return 0;
}
static int _get_str_size(Display *disp,my_window_t win,char *euc_str,char *utf8_str,int *w,int *h)
{
	if(win.anti == 0){
		XRectangle ink,log;

		*w = XmbTextExtents(win.fs_s,euc_str,strlen(euc_str),&ink,&log) + 2;	
		*h = log.height + 2;
	}else{
#if HAVE_LIBXFT
		XGlyphInfo gi;

		XftTextExtentsUtf8(disp,win.font_s,utf8_str,strlen(utf8_str),&gi);

		*w = gi.width;
		*h = gi.height;
#else
		XRectangle ink,log;

		*w = XmbTextExtents(win.fs_s,euc_str,strlen(euc_str),&ink,&log) + 2;	
		*h = log.height + 2;
#endif
	}

	return 0;
}
static int _Draw_Page_Title_String(	Display *disp,
					my_window_t win,
					char *euc_str,
					char *utf8_str,
					int x,
					int y		)
{
	XFontSet fs;
	GC gc;

	fs = win.fs_s;
	gc = win.rubi_gc;

	if(win.anti == 0){
		XmbDrawString(disp,win.win,fs,gc,x,y,euc_str,strlen(euc_str));

	}else{
#if HAVE_LIBXFT
		XftDrawStringUtf8(win.draw,&(win.rubi_color),win.font_s,x,y,utf8_str,strlen(utf8_str));
#else
		XmbDrawString(disp,win.win,fs,gc,x,y,euc_str,strlen(euc_str));
#endif
	}

	return 0;
}
int xtext_Draw_Text(	Display *disp,
			my_window_t win,
			IBUF_T *l_head,
			char_data_t char_d,
			page_data_t *char_p	)
{
	IBUF_T *ib;
	ITEXT_T *it;

	char page_str[50];

	int sc = 0,flag = 0;
	int x,y,one_line,start_line,end_line,start_low,end_low;
	int h;
	int width,height;

	if(l_head == NULL) return -1;


	XClearWindow(disp,win.win);

	one_line = char_d.charSize + char_d.xpad + char_d.charSize_r;

	start_line = win.width - one_line;
	end_line = 0;

	start_low = char_d.charSize * 2;
	end_low = win.height - char_d.charSize;

	x = start_line;
	y = start_low;

#if debug
fprintf(stderr,"Draw Start\n");
#endif

	for(ib=l_head;ib!=NULL;ib=ib->next){
		for(it=ib->i_head;it!=NULL;it=it->next){
			if(sc++ >= char_p->char_no) flag = 1;

			if(flag){

				_Draw_String(disp,win,char_d,it,x,y);

				h = xtext_get_low_space(it,&char_d);

				if((y += h) > end_low && xtext_next_kuten(it)==0){
					if((x -= one_line) < end_line) goto _draw_end;
					y = start_low;
				}
			}
		}
		if(flag){
			if((x -= one_line) < end_line) goto _draw_end;
			y = start_low;
		}
	}
#if debug
fprintf(stderr,"Draw END\n");
#endif

_draw_end:
	sprintf(page_str,"(%d/%d)",char_p->page_no,char_d.book->total_page);
	_get_str_size(disp,win,page_str,page_str,&width,&height);
	_Draw_Page_Title_String(disp,win,page_str,page_str,(win.width-width)/2,win.height-2);

	if(win.title_on){
		_get_str_size(disp,win,char_d.book->book_title,char_d.book->book_title_utf8,&width,&height);
		_Draw_Page_Title_String(disp,win,char_d.book->book_title,char_d.book->book_title_utf8,2,height);
	}


	return char_p->char_no;
}

			


