#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>

#include "xtext.h"

#define CONF_MAX 25 

static char conf_d[CONF_MAX][20] = {	"MAIN_WINDOW_WIDTH:",
					"MAIN_WINDOW_HEIGHT:",
					"MAIN_WINDOW_COLOR:",
					"MAIN_FONT_COLOR:",
					"MAIN_SHADOW_COLOR:",
					"MENU_WINDOW_COLOR:",
					"MENU_FONT_COLOR:",
					"MAIN_FONT_J:",
					"MAIN_FONT_S:",
					"MAIN_FONT_E:",
					"LINE_SPACE:",
					"ROW_SPACE:",
					"TITLE_DISP:",
					"BOOK_DIR:",
					"RUBI_FONT:",
					"XFT_FONT:",
					"RUBI_FONT_COLOR:",
					"PAGE_NEXT:",
					"PAGE_PREV:",
					"CONF_PAGE:",
					"BOOK_MARK:",
					"SIORI_MENU:",
					"QUIT:",
					"MENU:",
					"TITLE_KEY:"	};

static int _get_data(char *s,char *t)
{
	char *p;
	int i = 0;

	for(p=s;*p;p++){
		if(*p == '\n'){
			*(t + i) = '\0';
			return 0;
		}
		*(t + (i++)) = *p;
	}
	*(t + i) = '\0';

	return 0;
}
static int _init_xconf(xtext_conf_t *xconf)
{
	xconf->main_window_width = -1;
	xconf->main_window_height = -1;
	xconf->main_window_color[0] = '\0';
	xconf->main_font_color[0] = '\0';
	xconf->main_shadow_color[0] = '\0';
	xconf->rubi_font_color[0] = '\0';
	xconf->menu_window_color[0] = '\0';
	xconf->menu_font_color[0] = '\0';
	xconf->main_font_j[0] = '\0';
	xconf->main_font_s[0] = '\0';
	xconf->main_font_e[0] = '\0';
	xconf->book_dir[0] = '\0';
	xconf->rubi_font[0] = '\0';
	xconf->anti = -1;
	xconf->title_on = -1;
	xconf->line_space = -1;
	xconf->row_space = -1;
	xconf->page_next[0] = '\0';
	xconf->page_prev[0] = '\0';
	xconf->conf_page[0] = '\0';
	xconf->book_mark[0] = '\0';
	xconf->siori_menu[0] = '\0';
	xconf->quit[0] = '\0';
	xconf->menu[0] = '\0';
	xconf->title_key[0] = '\0';

	return 0;
}
int xtext_conf_data(xtext_conf_t *xconf,xtext_conf_t def)
{
	FILE *fp;
	struct passwd *pwd;
	char buf[BUFSIZ],temp[BUFSIZ],conf_file_path[256];
	int i,len;

	_init_xconf(xconf);

	pwd = getpwuid(getuid());
	sprintf(conf_file_path,"%s/%s/%s",pwd->pw_dir,CONF_DIR_NAME,CONF_FILE_NAME);
	if((fp = fopen(conf_file_path,"r")) == NULL) goto xtext_def;

	while(fgets(buf,BUFSIZ,fp) != NULL){
		if(buf[0] == '\n' || buf[0] == '#') continue;
		for(i=0;i<CONF_MAX;i++){
			len = strlen(conf_d[i]);
			if(strncmp(buf,conf_d[i],strlen(conf_d[i])) == 0){
				_get_data(buf+len,temp);

				switch(i){
					case 0:xconf->main_window_width = atoi(temp);break;
					case 1:xconf->main_window_height = atoi(temp);break;
					case 2:strcpy(xconf->main_window_color,temp);break;
					case 3:strcpy(xconf->main_font_color,temp);break;
					case 4:strcpy(xconf->main_shadow_color,temp);break;
					case 5:strcpy(xconf->menu_window_color,temp);break;
					case 6:strcpy(xconf->menu_font_color,temp);break;
					case 7:strcpy(xconf->main_font_j,temp);break;
					case 8:strcpy(xconf->main_font_s,temp);break;
					case 9:strcpy(xconf->main_font_e,temp);break;
					case 10:xconf->line_space = atoi(temp);break;
					case 11:xconf->row_space = atoi(temp);break;
					case 12:xconf->title_on = atoi(temp);break;
					case 13:strcpy(xconf->book_dir,temp);break;
					case 14:strcpy(xconf->rubi_font,temp);break;
					case 15:xconf->anti = atoi(temp);break;
					case 16:strcpy(xconf->rubi_font_color,temp);break;
					case 17:strcpy(xconf->page_next,temp);break;
					case 18:strcpy(xconf->page_prev,temp);break;
					case 19:strcpy(xconf->conf_page,temp);break;
					case 20:strcpy(xconf->book_mark,temp);break;
					case 21:strcpy(xconf->siori_menu,temp);break;
					case 22:strcpy(xconf->quit,temp);break;
					case 23:strcpy(xconf->menu,temp);break;
					case 24:strcpy(xconf->title_key,temp);break;
				}
				break;
			}
		}
	}
	fclose(fp);

xtext_def:

	if(xconf->main_window_width == -1) xconf->main_window_width=def.main_window_width;
	if(xconf->main_window_height == -1) xconf->main_window_height=def.main_window_height;
	if(xconf->main_window_color[0] == '\0') strcpy(xconf->main_window_color,def.main_window_color);
	if(xconf->main_font_color[0] == '\0') strcpy(xconf->main_font_color,def.main_font_color);
	if(xconf->main_shadow_color[0] == '\0') strcpy(xconf->main_shadow_color,def.main_shadow_color);
	if(xconf->menu_window_color[0] == '\0') strcpy(xconf->menu_window_color,def.menu_window_color);
	if(xconf->menu_font_color[0] == '\0') strcpy(xconf->menu_font_color,def.menu_font_color);
	if(xconf->rubi_font_color[0] == '\0') strcpy(xconf->rubi_font_color,def.rubi_font_color);
	if(xconf->main_font_j[0] == '\0') strcpy(xconf->main_font_j,def.main_font_j);
	if(xconf->main_font_s[0] == '\0') strcpy(xconf->main_font_s,def.main_font_s);
	if(xconf->main_font_e[0] == '\0') strcpy(xconf->main_font_e,def.main_font_e);
	if(xconf->book_dir[0] == '\0') strcpy(xconf->book_dir,def.book_dir);
	if(xconf->rubi_font[0] == '\0') strcpy(xconf->rubi_font,def.rubi_font);
	if(xconf->anti == -1) xconf->anti = def.anti;
	if(xconf->title_on == -1) xconf->title_on = def.title_on;
	if(xconf->line_space == -1) xconf->line_space = def.line_space;
	if(xconf->row_space == -1) xconf->row_space = def.row_space;
	if(xconf->page_next[0] == '\0') strcpy(xconf->page_next,def.page_next);
	if(xconf->page_prev[0] == '\0') strcpy(xconf->page_prev,def.page_prev);
	if(xconf->conf_page[0] == '\0') strcpy(xconf->conf_page,def.conf_page);
	if(xconf->book_mark[0] == '\0') strcpy(xconf->book_mark,def.book_mark);
	if(xconf->siori_menu[0] == '\0') strcpy(xconf->siori_menu,def.siori_menu);
	if(xconf->quit[0] == '\0') strcpy(xconf->quit,def.quit);
	if(xconf->menu[0] == '\0') strcpy(xconf->menu,def.menu);
	if(xconf->title_key[0] == '\0') strcpy(xconf->title_key,def.title_key);

	return 0;
}
				



































