#include <X11/Intrinsic.h>
#include <X11/keysym.h>

#if HAVE_LIBXFT
#include <X11/Xft/Xft.h>
#include <X11/extensions/Xrender.h>
#endif

#include <iconv.h>

#ifndef __XTEXT_

#define XTEXT_NAME 	"xjp-text"
#define XTEXT_VERSION 	"0.9.5"
#define CONF_DIR_NAME 	".xtext"
#define CONF_FILE_NAME 	"xtext.conf"
#define SIORI_FILE_NAME "xtext.siori"

#endif

typedef struct{
	int main_window_width;
	int main_window_height;
	char main_window_color[50];
	char main_font_color[50];
	char main_shadow_color[50];
	char rubi_font_color[50];
	char menu_window_color[50];
	char menu_font_color[50];
	char main_font_j[100];
	char main_font_s[100];
	char main_font_e[100];
	char book_dir[100];
	char rubi_font[100];

	int anti;
	int title_on;
	int line_space;
	int row_space;

	char page_next[10];
	char page_prev[10];
	char conf_page[10];
	char book_mark[10];
	char siori_menu[10];
	char quit[10];
	char menu[10];
	char title_key[10];

}xtext_conf_t;
typedef struct{
	Window win;

	int width;
	int height;

	GC gc;
	GC bgc;
	GC fgc,rfgc;
	GC rubi_gc;
	GC sgc;

	XFontSet fs;
	XFontSet fs_s;
	XFontSet fs_e;
	XFontSet rubi_fs;

	long fg_pixel;
	long bg_pixel;

	long menu_fg_pixel;
	long menu_bg_pixel;

#if HAVE_LIBXFT
	XftFont	*font;
	XftFont *font_s;
	XftFont *font_e;
	XftFont *font_rubi;

	XftDraw	*draw;

	XftColor fg_color;
	XftColor bg_color;
	XftColor rubi_color;
#endif

	Visual	*visual;
	Colormap cmap;

	int anti;
	int title_on;

}my_window_t;
typedef struct {
	Window parent_win;
	Window win;
	int x;
	int y;
	int width;
	int height;

	GC gc;
	GC bgc;
	GC fgc;
	GC rfgc;
	GC sgc;

	long fg_pixel;
	long bg_pixel;

	XFontSet fs;

}my_subwindow_t;

typedef struct CHARIMAGE{
	unsigned int c1;
	unsigned int c2;
	int chu;
	int small;

	XImage *char_image;

	struct CHARIMAGE *next;
	struct CHARIMAGE *prev;
}image_data_t;

typedef struct PAGEDATA{
	int char_no;
	int page_no;

	struct PAGEDATA *next;
	struct PAGEDATA *prev;
}page_data_t;

typedef struct {
	char book_path[256];
	char book_title[256];
	char book_title_utf8[256];
	int total_page;
}book_data_t;

typedef struct {

	int charSize;
	int charSize_s;
	int charSize_e;
	int charSize_r;
	int m_off;
	int s_off;
	int e_off;
	int xpad;
	int ypad;

	image_data_t *im_head;
	image_data_t *im_tail;

	page_data_t *head;
	page_data_t *tail;

	book_data_t *book;

}char_data_t;

typedef struct SUBWINDOWDATA{
	char line_str[256];
	char re_str[256];

	int line_no;

	struct SUBWINDOWDATA *next;
	struct SUBWINDOWDATA *prev;
}sub_window_t;

typedef struct SIORIDATA{
	unsigned char book_path[256];
	unsigned char book_title[256];
	unsigned char book_time[256];

	int NPC;

	struct SIORIDATA *next;
	struct SIORIDATA *prev;
}xtext_siori_t;


