#include "itext.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <wkf.h>


static char *K_CODE[5] = {"UN_KNOWN","ASCII","JIS","EUC","SJIS"};
static char *KEYPUSH = "< [Up] select up  [Down] select down  [Space] enter >";


void book_link_free(IBOOK_T **head,IBOOK_T **tail)
{
	IBOOK_T *wd,*wdd;

	if(*head == NULL) return;

	for(wd = *head;wd!=NULL;wd=wdd){
		wdd = wd->next;
		free(wd);
	}

	*head = NULL;
	*tail = NULL;
	return ;
}
static IBOOK_T *_book_link_alloc()
{
	IBOOK_T *ik;

	ik = (IBOOK_T *)malloc(sizeof(IBOOK_T));

	return ik;
}
static void _book_link_add(IBOOK_T **head,IBOOK_T **tail,IBOOK_T *ik)
{
	if(*tail){
		ik->next = NULL;
		ik->prev = *tail;

		(*tail)->next = ik;
		*tail = ik;
	}else{
		ik->next = NULL;
		ik->prev = NULL;

		*tail = ik;
		*head = ik;
	}
	return ;
}
static char *_ibookGetCode(int code)
{
	switch(code){
		case 1:
			return K_CODE[1];
		break;
		case 2:
			return K_CODE[2];
		break;
		case 3:
			return K_CODE[3];
		break;
		case 4:
			return K_CODE[4];
		break;
		default:
			return K_CODE[0];
		break;
	}
}
static int _ibookGetTitle(char *fname,char *title,int ftype)
{
	int i;
	kcode_t code;

	if(ftype == 0){
		FILE *fp;
		unsigned char buf[BUFSIZ];

		if((fp = fopen(fname,"r")) == NULL){
			strcpy(title,"Unknown Title");
			return -1;
		}

		while(fgets(buf,BUFSIZ,fp) != NULL){
			if(buf[0] == '\r' || buf[0] == '\n') continue;
			for(i=0;i<strlen(buf);i++)
				if(buf[i] == '\r' || buf[i] == '\n') buf[i] = '\0';

			wkfConvertKanjiCodeOfString(KC_UNKNOWN,buf,KC_EUC,title,256);
			code = wkfGuessKanjiCodeOfString(buf);

			break;
		}
		fclose(fp);

		return code;

	}else if(ftype == 1){
		unsigned char ziptitle[256];

		if(itextGetZipTitle(fname,ziptitle) > 0){
			wkfConvertKanjiCodeOfString(KC_UNKNOWN,ziptitle,KC_EUC,title,256);
			code = wkfGuessKanjiCodeOfString(ziptitle);
		}

		return code;
	}
}
int ibookGetFileData(IBOOK_T **bhead,IBOOK_T **btail,char *directory)
{
	DIR *dp;
	struct dirent *dir;
	struct stat sbuf;
	char fullpath[256];

	IBOOK_T *ik;

	int book_total = 0;
	int ftype;

	if((dp = opendir(directory)) == NULL) return -1;

	while((dir=readdir(dp)) != NULL){
		if(strncmp(dir->d_name,".",1) == 0 || strncmp(dir->d_name,"..",2) == 0) continue;

		sprintf(fullpath,"%s/%s",directory,dir->d_name);
		stat(fullpath,&sbuf);

		if((ftype = _checkFileType(fullpath)) >=0 ){

			ik = (IBOOK_T *)_book_link_alloc();

			ik->size = sbuf.st_size;
			strcpy(ik->fullpath,fullpath);
			strcpy(ik->filename,dir->d_name);
			ik->code = _ibookGetTitle(ik->fullpath,ik->title,ftype);

			_book_link_add(bhead,btail,ik);

			book_total++;
		}
	}

	closedir(dp);

	return book_total;
}
