<?php
/**
 * @file
 * @package xdbase
 * @version $Id: xoops_version.php,v 1.14 2011/08/27 10:38:22 bluemelon Exp $
 */

// language file (modinfo.php)
$langmanpath = XOOPS_TRUST_PATH.'/libs/altsys/class/D3LanguageManager.class.php';
if( ! file_exists( $langmanpath ) ) die( 'install the latest altsys' );
require_once( $langmanpath );
$langman =& D3LanguageManager::getInstance();
$langman->read( 'modinfo.php' , $mydirname , $mytrustdirname , false );

$constpref = '_MI_' . strtoupper( $mydirname );

//
// Define a basic manifesto.
//
$modversion['name'] = constant($constpref.'_NAME');
$modversion['description'] = constant($constpref.'_DESC');
$modversion['version'] = 2.5;
$modversion['author'] = 'hiro';
$modversion['credits'] = '';
$modversion['help'] = '';
$modversion['license'] = 'GPL';
$modversion['official'] = 0;
$modversion['image'] = file_exists($mydirpath.'/images/module_icon.png') ? 'images/module_icon.png' : 'images/module_icon.php';
$modversion['dirname'] = $mydirname;
$modversion['trust_dirname'] = $mytrustdirname;


// Any tables can't be touched by modulesadmin.
$modversion['sqlfile'] = false ;
$modversion['tables'] = array() ;

// All Templates can't be touched by modulesadmin.
$modversion['templates'] = array() ;

// Admin things
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = 'admin/index.php';
$modversion['adminmenu'] = 'admin/menu.php';

// Menu
$modversion['hasMain'] = 1;

// Search
$modversion['hasSearch'] = 1;
$modversion['search']['file'] = 'include/search.inc.php';
$modversion['search']['func'] = $mydirname.'_global_search';

// Blocks
$modversion['blocks'][1]['file'] = 'xdbase_datalist_block.php';
$modversion['blocks'][1]['name'] =  constant($constpref.'_LANG_UTILITY_BLOCK');
$modversion['blocks'][1]['description'] = constant($constpref.'_LANG_UTILITY_BLOCKDSC');
$modversion['blocks'][1]['show_func'] = 'b_xdbase_datalist_block_show';
$modversion['blocks'][1]['edit_func'] = 'b_xdbase_datalist_block_edit';
$modversion['blocks'][1]['options'] = $mydirname.'|title,img01,updated_date|5|0|updated_date|1||1||0||0||0||60|400';
//$modversion['blocks'][1]['template'] = '';
$modversion['blocks'][1]['template'] = $mydirname.'_datalist_block.html';
$modversion['blocks'][1]['can_clone'] = true;

$modversion['blocks'][2]['file'] = 'xdbase_tagcloud_block.php';
$modversion['blocks'][2]['name'] = constant($constpref.'_LANG_TAGCLOUD_BLOCK');
$modversion['blocks'][2]['description'] = constant($constpref.'_LANG_TAGCLOUD_BLOCKDSC');
$modversion['blocks'][2]['show_func'] = 'b_xdbase_tagcloud_block_show';
$modversion['blocks'][2]['edit_func'] = 'b_xdbase_tagcloud_block_edit';
$modversion['blocks'][2]['options'] = $mydirname;
//$modversion['blocks'][2]['template'] = '';
$modversion['blocks'][2]['template'] = $mydirname.'_tagcloud_block.html';

$modversion['blocks'][3]['file'] = 'xdbase_thumbnail_block.php';
$modversion['blocks'][3]['name'] = constant($constpref.'_LANG_THUMBNAIL_BLOCK');
$modversion['blocks'][3]['description'] = constant($constpref.'_LANG_THUMBNAIL_BLOCKDSC');
$modversion['blocks'][3]['show_func'] = 'b_xdbase_thumbnail_block_show';
$modversion['blocks'][3]['edit_func'] = 'b_xdbase_thumbnail_block_edit';
$modversion['blocks'][3]['options'] = $mydirname.'|3|1|0|updated_date|1||1||0||0||0||60';
//$modversion['blocks'][3]['template'] = '';
$modversion['blocks'][3]['template'] = $mydirname.'_thumbnail_block.html';
$modversion['blocks'][3]['can_clone'] = true;

$modversion['blocks'][4]['file'] = 'xdbase_calendar_block.php';
$modversion['blocks'][4]['name'] = constant($constpref.'_LANG_CALENDAR_BLOCK');
$modversion['blocks'][4]['description'] = constant($constpref.'_LANG_CALENDAR_BLOCKDSC');
$modversion['blocks'][4]['show_func'] = 'b_xdbase_calendar_block_show';
$modversion['blocks'][4]['edit_func'] = 'b_xdbase_calendar_block_edit';
$modversion['blocks'][4]['options'] = $mydirname.'|0|1|updated_date|';
//$modversion['blocks'][4]['template'] = '';
$modversion['blocks'][4]['template'] = $mydirname.'_calendar_block.html';

$modversion['blocks'][5]['file'] = 'xdbase_catlist_block.php';
$modversion['blocks'][5]['name'] = constant($constpref.'_LANG_CATLIST_BLOCK');
$modversion['blocks'][5]['description'] = constant($constpref.'_LANG_CATLIST_BLOCKDSC');
$modversion['blocks'][5]['show_func'] = 'b_xdbase_catlist_block_show';
$modversion['blocks'][5]['edit_func'] = 'b_xdbase_catlist_block_edit';
$modversion['blocks'][5]['options'] = $mydirname.'|3|5|1|';
//$modversion['blocks'][5]['template'] = '';
$modversion['blocks'][5]['template'] = $mydirname.'_catlist_block.html';

// Comments
$modversion['hasComments'] = 1;
$modversion['comments']['pageName'] = 'index.php';
$modversion['comments']['itemName'] = 'did';
$modversion['comments']['extraParams'] = array('action');
// Comment callback functions
$modversion['comments']['callbackFile'] = 'include/comment_functions.php';
$modversion['comments']['callback']['approve'] = $mydirname.'_com_approve';
$modversion['comments']['callback']['update'] = $mydirname.'_com_update';

// Notification
$modversion['hasNotification'] = 1;
$modversion['notification']['lookup_file'] = 'include/notification.inc.php';
$modversion['notification']['lookup_func'] = $mydirname.'_notify_iteminfo';

$modversion['notification']['category'][1]['name'] = 'global';
$modversion['notification']['category'][1]['title'] = constant($constpref.'_GLOBAL_NOTIFY');
$modversion['notification']['category'][1]['description'] = constant($constpref.'_GLOBAL_NOTIFYDSC');
$modversion['notification']['category'][1]['subscribe_from'] = 'index.php';

$modversion['notification']['category'][2]['name'] = 'cat';
$modversion['notification']['category'][2]['title'] = constant($constpref.'_CAT_NOTIFY');
$modversion['notification']['category'][2]['description'] = constant($constpref.'_CAT_NOTIFYDSC');
$modversion['notification']['category'][2]['subscribe_from'] = 'index.php';
$modversion['notification']['category'][2]['item_name'] = 'cid';

$modversion['notification']['category'][3]['name'] = 'data';
$modversion['notification']['category'][3]['title'] = constant($constpref.'_DATA_NOTIFY');
$modversion['notification']['category'][3]['description'] = constant($constpref.'_DATA_NOTIFYDSC');
$modversion['notification']['category'][3]['subscribe_from'] = 'index.php';
$modversion['notification']['category'][3]['item_name'] = 'did';

$modversion['notification']['event'][1]['name'] = 'new_data';
$modversion['notification']['event'][1]['category'] = 'global';
$modversion['notification']['event'][1]['title'] = constant($constpref.'_GLOBAL_NEW_DATA_NOTIFY');
$modversion['notification']['event'][1]['caption'] = constant($constpref.'_GLOBAL_NEW_DATA_NOTIFYCAP');
$modversion['notification']['event'][1]['description'] = constant($constpref.'_GLOBAL_NEW_DATA_NOTIFYDSC');
$modversion['notification']['event'][1]['mail_template'] = 'global_new_data_notify';
$modversion['notification']['event'][1]['mail_subject'] = constant($constpref.'_GLOBAL_NEW_DATA_NOTIFYSBJ');

$modversion['notification']['event'][2]['name'] = 'new_data';
$modversion['notification']['event'][2]['category'] = 'cat';
$modversion['notification']['event'][2]['title'] = constant($constpref.'_CAT_NEW_DATA_NOTIFY');
$modversion['notification']['event'][2]['caption'] = constant($constpref.'_CAT_NEW_DATA_NOTIFYCAP');
$modversion['notification']['event'][2]['description'] = constant($constpref.'_CAT_NEW_DATA_NOTIFYDSC');
$modversion['notification']['event'][2]['mail_template'] = 'global_new_data_notify';
$modversion['notification']['event'][2]['mail_subject'] = constant($constpref.'_CAT_NEW_DATA_NOTIFYSBJ');

$modversion['notification']['event'][3]['name'] = 'waiting';
$modversion['notification']['event'][3]['category'] = 'global';
$modversion['notification']['event'][3]['title'] = constant($constpref.'_GLOBAL_WAITING');
$modversion['notification']['event'][3]['caption'] = constant($constpref.'_GLOBAL_WAITINGCAP');
$modversion['notification']['event'][3]['description'] = constant($constpref.'_GLOBAL_WAITINGDSC');
$modversion['notification']['event'][3]['mail_template'] = 'global_waiting_notify';
$modversion['notification']['event'][3]['mail_subject'] = constant($constpref.'_GLOBAL_WAITINGSBJ');
$modversion['notification']['event'][3]['admin_only'] = 1;

$modversion['notification']['event'][4]['name'] = 'approve';
$modversion['notification']['event'][4]['category'] = 'data';
$modversion['notification']['event'][4]['title'] = constant($constpref.'_DATA_APPROVE_NOTIFY');
$modversion['notification']['event'][4]['caption'] = constant($constpref.'_DATA_APPROVE_NOTIFYCAP');
$modversion['notification']['event'][4]['description'] = constant($constpref.'_DATA_APPROVE_NOTIFYDSC');
$modversion['notification']['event'][4]['mail_template'] = 'data_approve_notify';
$modversion['notification']['event'][4]['mail_subject'] = constant($constpref.'_DATA_APPROVE_NOTIFYSBJ');
$modversion['notification']['event'][4]['invisible'] = 1;

// Config
/*
$modversion['config'][] = array(
	'name'			=> 'numperpage',
	'title'			=> 'constant($constpref.'_NUMPERPAGE'),
	'description'	=> 'constant($constpref.'_NUMPERPAGEDSC'),
	'formtype'		=> 'select',
	'valuetype'		=> 'int',
	'default'		=> 10,
	'options'		=> array('5'=>5,'10'=>10,'15'=>15,'20'=>20,'25'=>25,'30'=>30,'40'=>40,'50'=>50,'60'=>60,'70'=>70,'80'=>80,'90'=>90,'100'=>100)
) ;
*/
$modversion['config'][] = array(
	'name'			=> 'numperpage',
	'title'			=> $constpref.'_NUMPERPAGE',
	'description'	=> $constpref.'_NUMPERPAGEDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 10,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'select_perpage',
	'title'			=> $constpref.'_SELECTPERPAGE',
	'description'	=> $constpref.'_SELECTPERPAGEDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 1
) ;

$modversion['config'][] = array(
	'name'			=> 'display_breadcrumb',
	'title'			=> $constpref.'_DISPBREADCRUMB',
	'description'	=> $constpref.'_DISPBREADCRUMBDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 1
) ;

$modversion['config'][] = array(
	'name'			=> 'display_listpagenavi',
	'title'			=> $constpref.'_DISPLISTPAGENAV',
	'description'	=> $constpref.'_DISPLISTPAGENAVDSC',
	'formtype'		=> 'select',
	'valuetype'		=> 'int',
	'default'		=> 2,
	'options'		=> array(
		$constpref.'_DISPLAY_NONE'=>0,
		$constpref.'_DISPLAY_TOP'=>1,
		$constpref.'_DISPLAY_BOTTOM'=>2,
		$constpref.'_DISPLAY_BOTH'=>3
	)
) ;

$modversion['config'][] = array(
	'name'			=> 'display_detailpagenavi',
	'title'			=> $constpref.'_DISPDETAILPAGENAV',
	'description'	=> $constpref.'_DISPDETAILPAGENAVDSC',
	'formtype'		=> 'select',
	'valuetype'		=> 'int',
	'default'		=> 2,
	'options'		=> array(
		$constpref.'_DISPLAY_NONE'=>0,
		$constpref.'_DISPLAY_TOP'=>1,
		$constpref.'_DISPLAY_BOTTOM'=>2,
		$constpref.'_DISPLAY_BOTH'=>3
	)
) ;

$modversion['config'][] = array(
	'name'			=> 'display_sortnavi',
	'title'			=> $constpref.'_DISPSORTNAV',
	'description'	=> $constpref.'_DISPSORTNAVDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 1
) ;

$modversion['config'][] = array(
	'name'			=> 'default_sort',
	'title'			=> $constpref.'_DEFAULTSORT',
	'description'	=> $constpref.'_DEFAULTSORTDSC',
	'formtype'		=> 'select',
	'valuetype'		=> 'int',
	'default'		=> 1,
	'options'		=> array(
		'did'=>1,
		'cid'=>2,
		'title'=>3,
		'tag'=>4,
		'pid'=>5,
		'uid'=>6,
		'name'=>7,
		'poster_ip'=>8,
		'created_date'=>9,
		'updated_date'=>10,
		'published_date'=>11,
		'expired_date'=>12,
		's_date'=>13,
		'e_date'=>14,
		'password'=>15,
		'url'=>16,
		'email'=>17,
		'zip'=>18,
		'state'=>19,
		'city'=>20,
		'address'=>21,
		'phone'=>22,
		'mobile_phone'=>23,
		'fax'=>24,
		'show_map'=>25,
		'latitude'=>26,
		'longitude'=>27,
		'zoom'=>28,
		'img01'=>29,
		'img02'=>30,
		'file01'=>31,
		'file01name'=>32,
		'file01ext'=>33,
		'file01size'=>34,
		'body'=>35,
		'int01'=>36,
		'int02'=>37,
		'int03'=>38,
		'int04'=>39,
		'int05'=>40,
		'int06'=>41,
		'int07'=>42,
		'int08'=>43,
		'int09'=>44,
		'int10'=>45,
		'float01'=>46,
		'float02'=>47,
		'varchar01'=>48,
		'varchar02'=>49,
		'varchar03'=>50,
		'varchar04'=>51,
		'varchar05'=>52,
		'varchar06'=>53,
		'varchar07'=>54,
		'varchar08'=>55,
		'varchar09'=>56,
		'varchar10'=>57,
		'text01'=>58,
		'text02'=>59,
		'reservation'=>60,
		'option_value'=>61,
		'weight'=>62,
		'status'=>63,
		'access'=>64,
		'groups'=>65,
		'hits'=>66,
		'comments'=>67,
		'rating'=>68,
		'votes'=>69,
		'downloads'=>70,
		'trackbacks'=>71,
		'pipe_id'=>72,
		'dohtml'=>73,
		'doxcode'=>74,
		'dosmiley'=>75,
		'doimage'=>76,
		'dobr'=>77
	)
) ;

$modversion['config'][] = array(
	'name'			=> 'default_order',
	'title'			=> $constpref.'_DEFAULTORDER',
	'description'	=> $constpref.'_DEFAULTORDERDSC',
	'formtype'		=> 'select',
	'valuetype'		=> 'int',
	'default'		=> 1,
	'options'		=> array($constpref.'_ORDERASC'=>1,$constpref.'_ORDERDESC'=>-1)
) ;

$modversion['config'][] = array(
	'name'			=> 'list_template',
	'title'			=> $constpref.'_LIST_TPT',
	'description'	=> $constpref.'_LIST_TPTDSC',
	'formtype'		=> 'select',
	'valuetype'		=> 'text',
	'default'		=> 'data_list_table_style.html',
	'options'		=> array(
		'data_list_address_style.html'=>'data_list_address_style.html',
		'data_list_album_style.html'=>'data_list_album_style.html',
		'data_list_article_style.html'=>'data_list_article_style.html',
		'data_list_bbs_style.html'=>'data_list_bbs_style.html',
		'data_list_box_style.html'=>'data_list_box_style.html',
		'data_list_calendar_style.html'=>'data_list_calendar_style.html',
		'data_list_daily_style.html'=>'data_list_daily_style.html',
		'data_list_job_style.html'=>'data_list_job_style.html',
		'data_list_map_style.html'=>'data_list_map_style.html',
		'data_list_monthly_style.html'=>'data_list_monthly_style.html',
		'data_list_note_style.html'=>'data_list_note_style.html',
		'data_list_simple_link_style.html'=>'data_list_simple_link_style.html',
		'data_list_slideshow_style.html'=>'data_list_slideshow_style.html',
		'data_list_table_style.html'=>'data_list_table_style.html',
		'data_list_thumbnail_style.html'=>'data_list_thumbnail_style.html',
		'data_list_title_style.html'=>'data_list_title_style.html',
		'data_list_weekly_style.html'=>'data_list_weekly_style.html',
		'data_list_xigg_style.html'=>'data_list_xigg_style.html',
		'data_list_yearly_style.html'=>'data_list_yearly_style.html'
	)
) ;

$modversion['config'][] = array(
	'name'			=> 'view_template',
	'title'			=> $constpref.'_VIEW_TPT',
	'description'	=> $constpref.'_VIEW_TPTDSC',
	'formtype'		=> 'select',
	'valuetype'		=> 'text',
	'default'		=> 'data_view_table_style.html',
	'options'		=> array(
		'data_view_album_style.html'=>'data_view_album_style.html',
		'data_view_article_style.html'=>'data_view_article_style.html',
		'data_view_box_style.html'=>'data_view_box_style.html',
		'data_view_note_style.html'=>'data_view_note_style.html',
		'data_view_table_style.html'=>'data_view_table_style.html',
		'data_view_xigg_style.html'=>'data_view_xigg_style.html'
	)
) ;

$modversion['config'][] = array(
	'name'			=> 'display_catnavi',
	'title'			=> $constpref.'_DISPLAYCATNAV',
	'description'	=> $constpref.'_DISPLAYCATNAVDSC',
	'formtype'		=> 'select',
	'valuetype'		=> 'int',
	'default'		=> 1,
	'options'		=> array($constpref.'_LANG_NOTDISPLAY'=>0,$constpref.'_LANG_LIST'=>1,$constpref.'_LANG_SELECTBOX'=>2)
) ;

$modversion['config'][] = array(
	'name'			=> 'display_subcatnum',
	'title'			=> $constpref.'_DISPLAYSUBCATNUM',
	'description'	=> $constpref.'_DISPLAYSUBCATNUMDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 5,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'display_itemcount',
	'title'			=> $constpref.'_DISPLAYCOUNT',
	'description'	=> $constpref.'_DISPLAYCOUNTDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0,
) ;

$modversion['config'][] = array(
	'name'			=> 'display_catrow',
	'title'			=> $constpref.'_DISPLAYCATROW',
	'description'	=> $constpref.'_DISPLAYCATROWDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 3,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'display_thumbsrow',
	'title'			=> $constpref.'_DISPLAYTHUMBSROW',
	'description'	=> $constpref.'_DISPLAYTHUMBSROWDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 3,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'display_editbutton',
	'title'			=> $constpref.'_DISPLAYEDITBUTTON',
	'description'	=> $constpref.'_DISPLAYEDITBUTTONDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0
) ;

$modversion['config'][] = array(
	'name'			=> 'display_fieldsearch',
	'title'			=> $constpref.'_DISPLAYFIELDSEARCH',
	'description'	=> $constpref.'_DISPLAYFIELDSEARCHDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0
) ;

$modversion['config'][] = array(
	'name'			=> 'display_tagcloud',
	'title'			=> $constpref.'_DISPLAYTAGCLOUD',
	'description'	=> $constpref.'_DISPLAYTAGCLOUDDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0
) ;

$modversion['config'][] = array(
	'name'			=> 'max_textlength',
	'title'			=> $constpref.'_TEXTLENGTH',
	'description'	=> $constpref.'_TEXTLENGTHDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 0
) ;

$modversion['config'][] = array(
	'name'			=> 'date_format_list',
	'title'			=> $constpref.'_DATEFMT_LIST',
	'description'	=> $constpref.'_DATEFMT_LISTDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> 'Y-m-d'
) ;

$modversion['config'][] = array(
	'name'			=> 'date_format_view',
	'title'			=> $constpref.'_DATEFMT_VIEW',
	'description'	=> $constpref.'_DATEFMT_VIEWDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> 'Y-m-d H:i jD'
) ;

$modversion['config'][] = array(
	'name'			=> 'textarea_col',
	'title'			=> $constpref.'_TEXTAREA_COL',
	'description'	=> $constpref.'_TEXTAREA_COLDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 50,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'textarea_row',
	'title'			=> $constpref.'_TEXTAREA_ROW',
	'description'	=> $constpref.'_TEXTAREA_ROWDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 7,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'use_script',
	'title'			=> $constpref.'_USE_SCRIPT',
	'description'	=> $constpref.'_USE_SCRIPTDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0
) ;

$modversion['config'][] = array(
	'name'			=> 'use_url_thumbnailapi',
	'title'			=> $constpref.'_USE_URLTHUM',
	'description'	=> $constpref.'_USE_URLTHUMDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0
) ;

$modversion['config'][] = array(
	'name'			=> 'cat_perm',
	'title'			=> $constpref.'_CATPERM',
	'description'	=> $constpref.'_CATPERMDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'data_perm',
	'title'			=> $constpref.'_DATAPERM',
	'description'	=> $constpref.'_DATAPERMDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'cat_image_path',
	'title'			=> $constpref.'_CATIMGPATH',
	'description'	=> $constpref.'_CATIMGPATHDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '/uploads/'.$mydirname.'/categories',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'photos_path',
	'title'			=> $constpref.'_PHOTOSPATH',
	'description'	=> $constpref.'_PHOTOSPATHDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '/uploads/'.$mydirname.'/photos',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'thumbs_path',
	'title'			=> $constpref.'_THUMBSPATH',
	'description'	=> $constpref.'_THUMBSPATHDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '/uploads/'.$mydirname.'/thumbs',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'cat_image_size',
	'title'			=> $constpref.'_MAXCATIMGSIZE',
	'description'	=> $constpref.'_MAXCATIMGSIZEDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 50,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'max_image_size',
	'title'			=> $constpref.'_MAXIMGSIZE',
	'description'	=> $constpref.'_MAXIMGSIZEDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 1024,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'view_image_size',
	'title'			=> $constpref.'_MAXVIEWSIZE',
	'description'	=> $constpref.'_MAXVIEWSIZEDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 640,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'thumbnail_image_size',
	'title'			=> $constpref.'_MAXTHUMBSIZE',
	'description'	=> $constpref.'_MAXTHUMBSIZEDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 200,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'create_thumbnail',
	'title'			=> $constpref.'_CREATETHUMB',
	'description'	=> $constpref.'_CREATETHUMBDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 1,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'files_path',
	'title'			=> $constpref.'_FILESPATH',
	'description'	=> $constpref.'_FILESPATHDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '/uploads/'.$mydirname.'/files',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'allowed_extension',
	'title'			=> $constpref.'_ALLOWEDEXTS',
	'description'	=> $constpref.'_ALLOWEDEXTSDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> 'zip,tgz,lzh,cab',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'max_filesize',
	'title'			=> $constpref.'_MAXFILESIZE',
	'description'	=> $constpref.'_MAXFILESIZEDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 1000,
	'options'		=> array()
) ;
/*
$modversion['config'][] = array(
	'name'			=> 'use_facility_reservation',
	'title'			=> $constpref.'_USEFACILITY',
	'description'	=> $constpref.'_USEFACILITYDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0
) ;

$modversion['config'][] = array(
	'name'			=> 'overlap_limit',
	'title'			=> $constpref.'_OVERLAPLIMIT',
	'description'	=> $constpref.'_OVERLAPLIMITDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 0
) ;
*/
$modversion['config'][] = array(
	'name'			=> 'use_gmap',
	'title'			=> $constpref.'_USEGMAP',
	'description'	=> $constpref.'_USEGMAPDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'show_gmap_top',
	'title'			=> $constpref.'_SHOWGMAPTOP',
	'description'	=> $constpref.'_SHOWGMAPTOPDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'gmap_height',
	'title'			=> $constpref.'_GMAPHEIGHT',
	'description'	=> $constpref.'_GMAPHEIGHTDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 400,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'gmap_key',
	'title'			=> $constpref.'_GMAPKEY',
	'description'	=> $constpref.'_GMAPKEYDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'gmap_latidefault',
	'title'			=> $constpref.'_GMAPLATI',
	'description'	=> $constpref.'_GMAPLATIDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '35.631610',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'gmap_longidefault',
	'title'			=> $constpref.'_GMAPLONGI',
	'description'	=> $constpref.'_GMAPLONGIDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '139.881277',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'gmap_zoomdefault',
	'title'			=> $constpref.'_GMAPZOOM',
	'description'	=> $constpref.'_GMAPZOOMDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'int',
	'default'		=> 10,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'use_search_address',
	'title'			=> $constpref.'_USESEARCHADDRESS',
	'description'	=> $constpref.'_USESEARCHADDRESSDSC',
	'formtype'		=> 'yesno',
	'valuetype'		=> 'int',
	'default'		=> 0,
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'ptype_path',
	'title'			=> $constpref.'_PTYPE_PATH',
	'description'	=> $constpref.'_PTYPE_PATHDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '/modules/'.$mydirname.'/include/',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'azip_path',
	'title'			=> $constpref.'_AZIP_PATH',
	'description'	=> $constpref.'_AZIP_PATHDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '/include/ajaxzip2/',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'comment_type',
	'title'			=> $constpref.'_COM_TYPE',
	'description'	=> $constpref.'_COM_TYPEDSC',
	'formtype'		=> 'select',
	'valuetype'		=> 'int',
	'default'		=> 0,
	'options'		=> array($constpref.'_USE_XOOPSCOM'=>0,$constpref.'_USE_D3FORUMCOM'=>1)
) ;

$modversion['config'][] = array(
	'name'			=> 'd3forum_dir',
	'title'			=> $constpref.'_COM_DIRNAME',
	'description'	=> $constpref.'_COM_DIRNAMEDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> 'd3forum',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'd3forum_id',
	'title'			=> $constpref.'_COM_FORUM_ID',
	'description'	=> $constpref.'_COM_FORUM_IDDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'comment_view',
	'title'			=> $constpref.'_COM_VIEW',
	'description'	=> $constpref.'_COM_VIEWDSC',
	'formtype'		=> 'select',
	'valuetype'		=> 'text',
	'default'		=> 'listposts_flat',
	'options'		=> array('_FLAT' => 'listposts_flat' , '_THREADED' => 'listtopics')
) ;

$modversion['config'][] = array(
	'name'			=> 'd3pipes_dir',
	'title'			=> $constpref.'_D3PIPES_DIRNAME',
	'description'	=> $constpref.'_D3PIPES_DIRNAMEDSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> 'd3pipes',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'option01',
	'title'			=> $constpref.'_OPTION01',
	'description'	=> $constpref.'_OPTION01DSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'option02',
	'title'			=> $constpref.'_OPTION02',
	'description'	=> $constpref.'_OPTION02DSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '',
	'options'		=> array()
) ;

$modversion['config'][] = array(
	'name'			=> 'option03',
	'title'			=> $constpref.'_OPTION03',
	'description'	=> $constpref.'_OPTION03DSC',
	'formtype'		=> 'textbox',
	'valuetype'		=> 'text',
	'default'		=> '',
	'options'		=> array()
) ;


$modversion['onInstall'] = 'oninstall.php' ;
$modversion['onUpdate'] = 'onupdate.php' ;
$modversion['onUninstall'] = 'onuninstall.php' ;

// keep block's options
if ( ! defined( 'XOOPS_CUBE_LEGACY' ) && substr( XOOPS_VERSION , 6 , 3 ) < 2.1 && ! empty( $_POST['fct'] ) && ! empty( $_POST['op'] ) && $_POST['fct'] == 'modulesadmin' && $_POST['op'] == 'update_ok' && $_POST['dirname'] == $modversion['dirname'] ) {
	include dirname(__FILE__).'/include/x20_keepblockoptions.inc.php' ;
}


?>
