<?php
/**
 * @file
 * @package xdbase
 * @version $Id: function.php,v 1.17 2011/08/27 10:38:23 bluemelon Exp $
 */


function &xdbaseGetModuleHandler($name = null, $module_dir = null, $optional = false)
{
	static $handlers;
	$name = (!isset($name)) ? $module_dir : trim($name);

	if (!isset($handlers[$module_dir][$name]))
	{
		if (file_exists($hnd_file = XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/handler/'.ucfirst($name).'.class.php'))
		{
			include_once $hnd_file;
		}
		elseif (file_exists($hnd_file = XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/'.$name.'.php'))
		{
			include_once $hnd_file;
		}

		$className = ucfirst(strtolower(XDBASE_TRUST_DIRNAME)).'_'.ucfirst($name).'Handler';
		if (class_exists($className))
		{
			$handlers[$module_dir][$name] =& new $className($GLOBALS['xoopsDB'], $module_dir);
		}
		else
		{
			$className = ucfirst(strtolower(XDBASE_TRUST_DIRNAME)).ucfirst($name).'Handler';

			if (class_exists($className))
			{
				$handlers[$module_dir][$name] = new $className($GLOBALS['xoopsDB'], $module_dir);
			}
		}
	}
	if (!isset($handlers[$module_dir][$name]) && !$optional)
	{
		die('Handler does not exist<br />Module: '.$module_dir.'<br />Name: '.$name);
	}

	return $handlers[$module_dir][$name];
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * Gets a value of the current HTTP request. The return value doesn't
 * include quotes which are appended by magic_quote_gpc, even if it's
 * active.
 * 
 * @param string $key
 * @return mixed
 */
function xdbaseGetRequest($key)
{
	if (!isset($_GET[$key]) && !isset($_POST[$key]))
	{
		return null;
	}

	$value = isset($_GET[$key]) ? $_GET[$key] : $_POST[$key];

	if (!get_magic_quotes_gpc())
	{
		return $value;
	}

	if (is_array($value))
	{
		return xdbaseGetArrayRequest($value);
	}

	return stripslashes($value);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * Supports xdbaseGetRequest().
 *
 * @private
 * @param Array $arr
 * @return Array
 */
function xdbaseGetArrayRequest($arr)
{
	foreach (array_keys($arr) as $t_key)
	{
		if (is_array($arr[$t_key]))
		{
			$arr[$t_key] = xdbaseGetArrayRequest($arr[$t_key]);
		}
		else
		{
			$arr[$t_key] = stripslashes($arr[$t_key]);
		}
	}

	return $arr;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetUid()
{
	global $xoopsUser;
//	$xoopsUser = $GLOBALS['xoopsUser'];

	if (is_object($xoopsUser))
	{
		$uid = $xoopsUser->getVar('uid');
	}
	else
	{
		$uid = 0;
	}
	return $uid;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseIsAdmin()
{
	$isAdmin = false;
	global $xoopsUser, $xoopsModule;
//	$xoopsUser = $GLOBALS['xoopsUser'];
//	$xoopsModule = $GLOBALS['xoopsModule'];

	if (is_object($xoopsUser) && is_object($xoopsModule))
	{
		if ($xoopsUser->isAdmin($xoopsModule->getVar('mid')))
		{
			$isAdmin = true;
		}
	}
	return $isAdmin;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseIsGuest()
{
	$isGuest = true;
	global $xoopsUser;
//	$xoopsUser = $GLOBALS['xoopsUser'];

	if (is_object($xoopsUser))
	{
		$isGuest = false;
	}
	return $isGuest;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetGroups()
{
	$gidArray = array();
	global $xoopsUser;
//	$xoopsUser = $GLOBALS['xoopsUser'];

	if (is_object($xoopsUser))
	{
		$gidArray = $xoopsUser->getGroups();
	}
	else
	{
		$gidArray = array(XOOPS_GROUP_ANONYMOUS);
	}
	return $gidArray;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetTimeOffset()
{
	global $xoopsUser;
//	$xoopsUser = $GLOBALS['xoopsUser'];
	if (is_object($xoopsUser))
	{
		$userTimezone = $xoopsUser->timezone();
	}
	else
	{
		$userTimezone = $GLOBALS['xoopsConfig']['default_TZ'];
	}
	$offset = ($userTimezone - $GLOBALS['xoopsConfig']['server_TZ']) * 3600;
	return $offset;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function &xdbaseGetConfigsByDirname($dirname, $category = 0)
{
	$ret = null;
	$handler =& xoops_gethandler('module');
	$module =& $handler->getByDirname($dirname);
	if (!is_object($module))
	{
		return $ret;
	}

	$configHandler =& xoops_gethandler('config');
	$ret =& $configHandler->getConfigsByCat($category, $module->getVar('mid'));

	return $ret;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*
* @return array formatted
* getdate() key
* "seconds" á͡ 0  59
* "minutes" ʬ͡ 0  59
* "hours"  0  23
* "mday" ñ̤ 1  31
* "wday" ͡ 0 ()  6 ()
* "mon" ͡ 1  12
* "year" ǯ4ο͡ : 1999 뤤 2003
* "yday" ǯñ̤͡ 0  365
* "weekday" ե륹ڥʸ Sunday  Saturday
* "month" ե륹ڥʸ January  December
*/
function xdbaseGetDate()
{
	$unixTime = intval(xdbaseGetRequest('utime'));
	if ($unixTime == 0)
	{
		$timestamp = mktime(xdbaseGetHour(), xdbaseGetMinute(), xdbaseGetSecond(), xdbaseGetMonth(), xdbaseGetDay(), xdbaseGetYear());
	}
	else
	{
		$timestamp = $unixTime;
	}
	$dateArray = getdate($timestamp);
	return $dateArray;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetDateUnixTime()
{
	$timestamp = mktime(xdbaseGetHour(), xdbaseGetMinute(), xdbaseGetSecond(), xdbaseGetMonth(), xdbaseGetDay(), xdbaseGetYear());
	return $timestamp;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetWeekStartUnixTime()
{
	$dateArray = xdbaseGetDate();
	$weekNo = $dateArray['wday'];
	$startDay = $dateArray['mday'] - $weekNo;
	$weekStartUnixTime = mktime(0, 0, 0, $dateArray['mon'], $startDay, $dateArray['year']);
	return $weekStartUnixTime;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetWeekEndUnixTime()
{
	$dateArray = xdbaseGetDate();
	$weekNo = $dateArray['wday'];
	$endDay = $dateArray['mday'] + (6 - $weekNo);
	$weekEndUnixTime = mktime(0, 0, 0, $dateArray['mon'], $endDay, $dateArray['year']);
	return $weekEndUnixTime;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetWeekArray()
{
	$dateArray = xdbaseGetDate();
	$weekNo = $dateArray['wday'];
	$startDay = $dateArray['mday'] - $weekNo;
	$weekArray = array();
	for ($i=0; $i<=6; $i++)
	{
		$weekArray[$i] = mktime(0, 0, 0, $dateArray['mon'], $startDay + $i, $dateArray['year']);
	}
	return $weekArray;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetYear()
{
	$year = xdbaseGetRequest('year');
	if ($year === null)
	{
		$year = date('Y');
	}
	return intval($year);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetYearStr($year)
{
	return intval($year)._MD_XDBASE_LANG_YEAR;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetMonth()
{
	$month = xdbaseGetRequest('month');

	if ($month === null)
	{
		$month = date('n');
	}
	return intval($month);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetMonthStr($month)
{
	if ($month < 1 || $month > 12)
	{
		return false;
	}
	$monthArray = array(
		1 => _MD_XDBASE_LANG_JAN,
		2 => _MD_XDBASE_LANG_FEB,
		3 => _MD_XDBASE_LANG_MAR,
		4 => _MD_XDBASE_LANG_APR,
		5 => _MD_XDBASE_LANG_MAY,
		6 => _MD_XDBASE_LANG_JUN,
		7 => _MD_XDBASE_LANG_JUL,
		8 => _MD_XDBASE_LANG_AUG,
		9 => _MD_XDBASE_LANG_SEP,
		10 => _MD_XDBASE_LANG_OCT,
		11 => _MD_XDBASE_LANG_NOV,
		12 => _MD_XDBASE_LANG_DEC
	);
	return $monthArray[$month];
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetWeek()
{
	$week = xdbaseGetRequest('week');
	if ($week === null)
	{
		$week = date('w');
	}
	return intval($week);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetDay()
{
	$day = xdbaseGetRequest('day');
	if ($day === null)
	{
		$day = date('j');
	}
	return intval($day);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetHour()
{
	$hour = xdbaseGetRequest('hour');
	if ($hour === null)
	{
		$hour = date('H');
	}
	return intval($hour);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetMinute()
{
	$minute = xdbaseGetRequest('minute');
	if ($minute === null)
	{
		$minute = date('i');
	}
	return intval($minute);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetSecond()
{
	$second = xdbaseGetRequest('second');
	if ($second === null)
	{
		$second = date('s');
	}
	return intval($second);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	function xdbaseCalcImageSize($max, $tmpWidth, $tmpHeight)
	{
		if ($tmpWidth <= $max && $tmpHeight <= $max)
		{
			$ret = array($tmpWidth, $tmpHeight);
		}
		else
		{
			if ($tmpWidth >= $tmpHeight)
			{
				$aspectRatio = $tmpWidth / $max;
				$width = $max;
				$height = round($tmpHeight / $aspectRatio, 0);
			}
			else
			{
				$aspectRatio = $tmpHeight / $max;
				$width = round($tmpWidth / $aspectRatio, 0);
				$height = $max;
			}
			$ret = array($width, $height);
		}
		return $ret;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseCheckDir($path)
{
//	$err = '';
	$err = false;
	if (substr($path, -1) == '/')
	{
		$err = "Error: ".$path." The last charactor should not be '/'";
	}

	if (!is_dir($path))
	{
		$safeModeFlag = ini_get('safe_mode');
		if ($safeModeFlag)
		{
			$err = "Error: ".$path." You first have to create and chmod 777 directory by ftp or shell.";
		}
		else
		{
			if (!$rs = mkdir($path, 0777))
			{
				$err = "Error: ".$path." This is not a directory.";
			}
		}
	}

	if (!is_writable($path) || !is_readable($path))
	{
		$err = "Error: ".$path." This directory is not writable nor readable. You should change the permission of the directory to 777.";
	}
	return $err;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseFormatString()
{
	$arr = func_get_args();

	if(count($arr)==0) return null;

	$message = $arr[0];

	$variables = array();
	if (is_array($arr[1]))
	{
		$variables = $arr[1];
	}
	else
	{
		$variables = $arr;
		array_shift($variables);
	}

	for ($i = 0; $i < count($variables); $i++)
	{
		$message = str_replace("{" . ($i) . "}", $variables[$i], $message);

		// Temporary....
		$message = str_replace("{" . ($i) . ":ucFirst}", ucfirst($variables[$i]), $message);
		$message = str_replace("{" . ($i) . ":toLower}", strtolower($variables[$i]), $message);
		$message = str_replace("{" . ($i) . ":toUpper}", strtoupper($variables[$i]), $message);
	}

	return $message;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetUserAgent()
{
	if (stristr($_SERVER['HTTP_USER_AGENT'], 'Opera'))
	{
		$userAgent = 'Opera';
	}
	elseif (stristr($_SERVER['HTTP_USER_AGENT'], 'MSIE'))
	{
		$userAgent = 'IE';
	}
	elseif (stristr($_SERVER['HTTP_USER_AGENT'], 'Mozilla') && stristr($_SERVER['HTTP_USER_AGENT'], 'Safari'))
	{
		$userAgent = 'SAFARI';
	}
	elseif (stristr($_SERVER['HTTP_USER_AGENT'], 'Mozilla'))
	{
		$userAgent = 'MOZILLA';
	}
	else
	{
		$userAgent = 'OTHER';
	}
	return $userAgent;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseEncodName($filename, $ua = null)
{
	$str = str_replace(' ', '_', $filename);
	
	if (is_null($ua))
	{
		$ua = xdbaseGetUserAgent();
	}

	if (XOOPS_USE_MULTIBYTES == 1)
	{
		if (function_exists('mb_internal_encoding'))
		{
			$from_encoding = mb_internal_encoding();
		}
		else
		{
			$from_encoding = _CHARSET;
		}

		switch ($ua)
		{
			case 'MOZILLA':
				$to_encoding = 'UTF-8';
				break;
			case 'IE':
				$to_encoding = 'SJIS';
				break;
			case 'Opera':
				$to_encoding = 'UTF-8';
				break;
			case 'SAFARI':
				$to_encoding = 'UTF-8';
				break;
			default:
				$to_encoding = 'UTF-8';
				break;
		}

		if (function_exists('mb_convert_encoding'))
		{
//			return mb_convert_encoding($str, $to_encoding, $from_encoding);
			return mb_convert_encoding($str, $to_encoding, 'ASCII,JIS,UTF-8,EUC-JP,SJIS');
		}
		elseif (function_exists('iconv'))
		{
			return iconv($from_encoding, $to_encoding, $str);
		}
		else
		{
			return $str;
		}
	}
	else
	{
		return $str;
	}
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * substitution of xoops_template_touch()
 * 
 * @return bool
 */
function xdbaseTemplateTouch($tpl_id, $clear_old = true)
{
	if (defined('XOOPS_CUBE_LEGACY'))
	{
		// for Cube 2.1
		$result = null;
		XCube_DelegateUtils::call('Legacy.XoopsTpl.TemplateTouch', $tpl_id, $clear_old, new XCube_Ref($result));

		if ($result === null) {
			$tpl = new XoopsTpl();
			$tpl->force_compile = true;
			$tplfile_handler =& xoops_gethandler('tplfile');
			$tplfile =& $tplfile_handler->get($tpl_id);
			if ( is_object($tplfile) ) {
				$file = $tplfile->getVar('tpl_file');
				if ($clear_old) {
					$tpl->clear_cache('db:'.$file);
					$tpl->clear_compiled_tpl('db:'.$file);
				}
				// $tpl->fetch('db:'.$file);
				return true;
			}
			return false;
		} else {
			return $result;
		}
	}
	else
	{
		$tpl = new XoopsTpl();

		include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/handler/Data.class.php';
		include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_Controller.class.php';
		include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_PageNavigator.class.php';
		include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractFilterForm.class.php';
		include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_ActionForm.class.php';

		$objects = array();
		$object = new Xdbase_DataObject();
		$objects[0] = $object;
		$handler = new Xdbase_ObjectHandler($GLOBALS['xoopsDB']);
		$controller =& new Xdbase_Controller(_MD_XDBASE_CONST_MODULEDIRNAME);
		$url = '';
		$pageNavi = new Xdbase_PageNavigator($url);
		$filter = new Xdbase_AbstractFilterForm($controller);
		$actionForm = new Xdbase_ActionForm($controller);

		$tpl->assign('object', $object);
		$tpl->assign('objects', $objects);
		$tpl->assign('pageNavi', $pageNavi);
		$tpl->assign('filter', $filter);
		$tpl->assign('handler', $handler);
		$tpl->assign('catHandler', $handler);
		$tpl->assign('actionForm', $actionForm);

		$tpl->force_compile = true;
		$tplfile_handler =& xoops_gethandler('tplfile');
		$tplfile =& $tplfile_handler->get($tpl_id);
		if ( is_object($tplfile) ) {
			$file = $tplfile->getVar('tpl_file');
			if ($clear_old) {
				$tpl->clear_cache('db:'.$file);
				$tpl->clear_compiled_tpl('db:'.$file);
			}
			$tpl->fetch('db:'.$file);
//			@$tpl->fetch('db:'.$file);
			return true;
		}
		return false;
	}
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
// called from blocks
function xdbaseBlockRenderColSelect($i, $options, $showblank=false)
{
	$data_handler =& xdbaseGetModuleHandler('data', $options[0]);
	$key_array = $data_handler->getActiveKeyArray();

	$selectbox = '';
	$selectbox .= '<select name="options['.$i.']">';
	if ($showblank)
	{
		$selectbox .= '<option value=""></option>';
	}
	foreach ($key_array as $key)
	{
		$selected = '';
		if ($key == $options[$i])
		{
			$selected = ' selected="selected"';
		}
		$selectbox .= '<option value="'.$key.'"'.$selected.'>'.$data_handler->getShowName($key).'</option>';
	}
	$selectbox .= '</select>';
	return $selectbox;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseBlockRenderCatSelect($i, $options)
{
	$cat_handler =& xdbaseGetModuleHandler('cat', $options[0]);
	$cat_handler->setTree($cat_handler->getCriteria());
	$cat_option_array = $cat_handler->getCatOptionArray();

	$selectbox = '';
	$selectbox .= '<select name="options['.$i.']">';
	$selected = '';
//	if ('' == $options[$i])
//	{
//		$selected = ' selected="selected"';
//	}
//	$selectbox .= '<option value=""'.$selected.'> ---- </option>';
	foreach ($cat_option_array as $cat_option)
	{
		$cid = $cat_option['cid'];
		$title = $cat_option['title'];
		$selected = '';
		if ($cid == $options[$i])
		{
			$selected = ' selected="selected"';
		}
		$selectbox .= '<option value="'.$cid.'"'.$selected.'>'.$title.'</option>';
	}
	$selectbox .= '</select>';
	return $selectbox;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseBlockRenderOrderSelect($i, $options)
{
	$selectbox = '<select name="options['.$i.']">';
	$selected = '';
	if ($options[$i] == 0)
	{
		$selected = ' selected="selected"';
	}
	$selectbox .= '<option value="0"'.$selected.'>ASC</option>';
	$selected = '';
	if ($options[$i] == 1)
	{
		$selected = ' selected="selected"';
	}
	$selectbox .= '<option value="1"'.$selected.'>DESC</option>';
	$selectbox .= '</select>';
	return $selectbox;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseBlockRenderOperatorSelect($i, $options)
{
	$data_handler =& xdbaseGetModuleHandler('data', $options[0]);
	$operator_array = $data_handler->getOperatorArray();

	$selectbox = '';
	$selectbox .= '<select name="options['.$i.']">';
	$selected = '';
	foreach ($operator_array as $key => $operator)
	{
		$selected = '';
		if ($key == $options[$i])
		{
			$selected = ' selected="selected"';
		}
		$selectbox .= '<option value="'.$key.'"'.$selected.'>'.$operator.'</option>';
	}
	$selectbox .= '</select>';
	return $selectbox;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseBlockRenderConditionSelect($i, $options)
{
	$selectbox = '<select name="options['.$i.']">';
	$selected = '';
	if ($options[$i] == 0)
	{
		$selected = ' selected="selected"';
	}
	$selectbox .= '<option value="0"'.$selected.'>AND</option>';
	$selected = '';
	if ($options[$i] == 1)
	{
		$selected = ' selected="selected"';
	}
	$selectbox .= '<option value="1"'.$selected.'>OR</option>';
	$selectbox .= '</select>';
	return $selectbox;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseBlockRenderYesNoRadioButton($i, $options)
{
	$radiobutton = '';
	if ($options[$i] == 1)
	{
		$checked_yes = ' checked="checked"';
		$checked_no = '';
	}
	else
	{
		$checked_yes = '';
		$checked_no = ' checked="checked"';
	}
	$radiobutton .= '<input type="radio" name="options['.$i.']" value="1"'.$checked_yes.' />'._YES.'&nbsp;';
	$radiobutton .= '<input type="radio" name="options['.$i.']" value="0"'.$checked_no.' />'._NO;
	return $radiobutton;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseQuoteString($string)
{
	$db =& Database::getInstance();
	return $db->quoteString($string);
}


///////////////////////////////////////////////////////////////////////////////////////////////////////
function xdbaseGetMtype($ext)
{
	$mtypeArray = array(
		'123'=>'application/vnd.lotus-1-2-3',
		'3g2'=>'video/3gpp2',
		'3gp'=>'video/3gpp',
		'ai'=>'application/postscript',
		'aif'=>'audio/aiff',
		'aifc'=>'audio/aiff',
		'aiff'=>'audio/aiff',
		'ani'=>'application/x-navi-animation',
		'apr'=>'application/vnd.lotus-approach',
		'ar'=>'application/octet-stream',
		'art'=>'application/x-art',
		'asm'=>'text/plain',
		'asp'=>'application/x-asap',
		'au'=>'audio/basic',
		'avi'=>'video/x-msvideo',
		'avx'=>'video/x-rad-screenplay',
		'awe'=>'application/x-candleweb',
		'bas'=>'text/plain',
		'bin'=>'application/x-macbinary',
		'bmp'=>'image/bmp',
		'bny'=>'application/x-binaryii',
		'bqy'=>'application/x-binaryii',
		'bxy'=>'application/x-binaryii',
		'cdf'=>'application/x-netcdf',
		'cf'=>'text/plain',
		'cfg'=>'text/plain',
		'cgi'=>'application/x-httpd-cgi',
		'chat'=>'application/x-chat',
		'class'=>'application/octet-stream',
		'com'=>'application/octet-stream',
		'cpio'=>'application/x-cpio',
		'cpp'=>'text/plain',
		'crl'=>'application/x-pkcs7-crl',
		'csh'=>'application/x-csh',
		'csv'=>'application/csv',
		'dcr'=>'application/x-director',
		'dht'=>'text/html',
		'dhtml'=>'text/html',
		'dir'=>'appliaction/x-director',
		'dll'=>'application/octet-stream',
		'doc'=>'application/msword',
		'dot'=>'application/octet-stream',
		'dp'=>'application/x-commonground',
		'dsk'=>'application/octet-stream',
		'dvi'=>'application/x-dvi',
		'dxr'=>'application/x-director',
		'elm'=>'text/plain',
		'eml'=>'text/plain',
		'eps'=>'application/postscript',
		'epsf'=>'application/postscript',
		'epsi'=>'application/postscript',
		'etx'=>'text/x-setext',
		'euc'=>'text/plain',
		'exe'=>'application/octet-stream',
		'f77'=>'application/x-fortran77',
		'f90'=>'text/plain',
		'faif'=>'audio/x-aiff',
		'fif'=>'application/fractals',
		'fig'=>'application/x-xfig',
		'flc'=>'video/x-flc',
		'fli'=>'video/x-fli',
		'fm'=>'application/vnd.framemaker',
		'fmr'=>'application/x-fmr',
		'fn0'=>'application/octet-stream',
		'fn1'=>'application/octet-stream',
		'fna'=>'application/octet-stream',
		'fon'=>'application/octet-stream',
		'gif'=>'image/gif',
		'gtar'=>'application/x-gtar',
		'gz'=>'application/x-compressed',
		'hdf'=>'application/x-hdf',
		'hlp'=>'application/octet-stream',
		'hqx'=>'application/mac-binhex40',
		'htm'=>'text/html',
		'html'=>'text/html',
		'ice'=>'x-conference/x-cooltalk',
		'ico'=>'application/octet-stream',
		'ief'=>'image/ief',
		'it'=>'audio/x-mod',
		'jar'=>'application/java-archive',
		'jfif'=>'image/jpeg',
		'jis'=>'text/plain',
		'jpe'=>'image/jpeg',
		'jpeg'=>'image/jpeg',
		'jpg'=>'image/jpeg',
		'js'=>'application/x-javascript',
		'jsc'=>'application/x-javascript-config',
		'lam'=>'audio/x-liveaudio',
		'latex'=>'application/x-latex',
		'lha'=>'application/octet-stream',
		'ls'=>'application/x-javascript',
		'lwp'=>'application/vnd.lotus-wordpro',
		'lzh'=>'application/octet-stream',
		'm'=>'application/x-troff-man',
		'mac'=>'text/plain',
		'mag'=>'application/octet-stream',
		'mak'=>'text/plain',
		'man'=>'application/x-troff-man',
		'map'=>'application/x-navimap',
		'mc'=>'application/x-metacard',
		'mda'=>'application/vnd.ms-access',
		'mdb'=>'application/vnd.ms-access',
		'mde'=>'application/vnd.ms-access',
		'me'=>'application/x-troff-me',
		'mid'=>'audio/x-midi',
		'midi'=>'audio/x-midi',
		'mif'=>'application/x-mif',
		'mki'=>'application/octet-stream',
		'mml'=>'text/plain',
		'moc'=>'application/x-javascript',
		'mocha'=>'application/x-javascript',
		'mod'=>'audio/x-mod',
		'mov'=>'video/quicktime',
		'movie'=>'video/x-sgi-movie',
		'mp2'=>'video/mpeg',
		'mp2v'=>'video/mpeg',
		'mp3'=>'video/mpeg',
		'mpa'=>'video/mpeg',
		'mpc'=>'application/vnd.ms-project',
		'mpe'=>'video/mpeg',
		'mpeg'=>'video/mpeg',
		'mpega'=>'video/mpeg',
		'mpegv'=>'video/mpeg',
		'mpg'=>'video/mpeg',
		'mpp'=>'application/vnd.ms-project',
		'mpt'=>'application/vnd.ms-project',
		'mpv'=>'video/mpeg',
		'mpv2'=>'video/mpeg',
		'mpw'=>'application/vnd.ms-project',
		'mpx'=>'application/vnd.ms-project',
		'ms'=>'application/x-troff-ms',
		'mtm'=>'audio/x-mod',
		'nc'=>'application/x-netcdf',
		'nvd'=>'application/x-navidoc',
		'nvm'=>'application/x-navimap',
		'obj'=>'application/octet-stream',
		'oda'=>'application/oda',
		'or2'=>'application/vnd.lotus-organizer',
		'or3'=>'application/vnd.lotus-organizer',
		'org'=>'application/vnd.lotus-organizer',
		'ovl'=>'application/octet-stream',
		'p7c'=>'application/x-pkcs7-mime',
		'p7m'=>'application/x-pkcs7-mime',
		'p7s'=>'application/x-pkcs7-signature',
		'pac'=>'application/x-ns-proxy-autoconfig',
		'pas'=>'text/plain',
		'pbm'=>'image/x-portable-bitmap',
		'pcd'=>'image/x-photo-cd',
		'pdf'=>'application/pdf',
		'pgm'=>'application/x-portable-graymap',
		'pic'=>'image/pict',
		'pict'=>'image/pict',
		'pjp'=>'image/jpeg',
		'pjpeg'=>'image/jpeg',
		'pl'=>'application/x-perl',
		'pm'=>'application/x-perl',
		'png'=>'image/png',
		'pnm'=>'image/x-portable-anymap',
		'pot'=>'application/vnd.ms-powerpoint',
		'ppa'=>'application/vnd.ms-powerpoint',
		'ppm'=>'image/x-portable-anymap',
		'pps'=>'application/vnd.ms-powerpoint',
		'ppt'=>'application/vnd.ms-powerpoint',
		'pre'=>'application/vnd.lotus-freelance',
		'prz'=>'application/vnd.lotus-freelance',
		'ps'=>'application/postscript',
		'pwz'=>'application/vnd.ms-powerpoint',
		'q4'=>'image/x-q4',
		'qt'=>'video/quicktime',
		'ra'=>'audio/x-pn-realaudio',
		'ram'=>'audio/x-pn-realaudio',
		'rar'=>'application/x-rar',
		'ras'=>'image/x-cmu-raster',
		'readme'=>'text/plain',
		'rgb'=>'image/x-rgb',
		'rpm'=>'audio/x-pn-realaudio-plugin',
		'rtf'=>'application/rtf',
		'rtx'=>'text/richtext',
		's'=>'text/plain',
		's3m'=>'audio/x-mod',
		'sam'=>'application/vnd.lotus-wordpro',
		'sc2'=>'application/vnd.ms-schedule',
		'scd'=>'application/vnd.ms-schedule',
		'sch'=>'application/vnd.ms-schedule',
		'scm'=>'application/vnd.lotus-screencam',
		'sdk'=>'application/x-shrinkit',
		'sgm'=>'text/sgml',
		'sgml'=>'text/sgml',
		'shar'=>'application/x-shar',
		'shk'=>'application/x-shrinkit',
		'sht'=>'text/html',
		'shtml'=>'text/html',
		'sit'=>'application/x-stuffit',
		'sj'=>'text/html',
		'sjis'=>'text/html',
		'snd'=>'audio/basic',
		'sql'=>'application/x-sql',
		'src'=>'application/x-wais-source',
		'stl'=>'application/x-navistyle',
		'swf'=>'application/x-shockwave-flash',
		't'=>'application/x-troff',
		'tar'=>'application/x-tar',
		'tcl'=>'application/x-tcl',
		'texi'=>'application/x-texinfo',
		'texinfo'=>'application/x-texinfo',
		'text'=>'text/plain',
		'tsv'=>'text/tab-separated-value',
		'tgz'=>'application/x-compressed',
		'tif'=>'image/tiff',
		'tiff'=>'image/tiff',
		'tk'=>'application/x-tcl',
		'tki'=>'application/x-tkined',
		'tkined'=>'application/x-tkined',
		'tr'=>'application/x-troff',
		'tsv'=>'text/tab-separated-values',
		'txt'=>'text/plain',
		'ult'=>'audio/x-mod',
		'uni'=>'audio/x-mod',
		'vbs'=>'video/mpeg',
		'vcf'=>'text/x-vcard',
		'vcr'=>'video/x-sunvideo',
		'vdo'=>'video/vdo',
		'vew'=>'application/vnd.lotus-approach',
		'vf1'=>'application/octet-stream',
		'vf2'=>'application/octet-stream',
		'vrml'=>'x-world/x-vrml',
		'wav'=>'audio/x-wav',
		'wj2'=>'application/vnd.lotus-1-2-3',
		'wj3'=>'application/vnd.lotus-1-2-3',
		'wk1'=>'application/vnd.lotus-1-2-3',
		'wk3'=>'application/vnd.lotus-1-2-3',
		'wk4'=>'application/vnd.lotus-1-2-3',
		'wk5'=>'application/vnd.lotus-1-2-3',
		'wll'=>'application/msword',
		'wp6'=>'application/wordperfect5.1',
		'wpd'=>'application/wordperfect5.1',
		'wrl'=>'x-world/x-vrml',
		'xbm'=>'image/x-xbitmap',
		'xdm'=>'application/x-xdma',
		'xdma'=>'application/x-xdma',
		'xla'=>'application/vnd.ms-excel',
		'xlc'=>'application/vnd.ms-excel',
		'xld'=>'application/vnd.ms-excel',
		'xll'=>'application/vnd.ms-excel',
		'xlm'=>'application/vnd.ms-excel',
		'xls'=>'application/vnd.ms-excel',
		'xlt'=>'application/vnd.ms-excel',
		'xlw'=>'application/vnd.ms-excel',
		'xm'=>'audio/x-mod',
		'xml'=>'text/xml',
		'xpm'=>'image/x-xpicmap',
		'xwd'=>'image/x-xwindowdump',
		'z'=>'application/x-compressed',
		'zim'=>'image/x-zim',
		'zip'=>'application/x-zip-compressed',
		'zjg'=>'application/octet-stream',
		'zpt'=>'application/octet-stream',
	) ;
	$mtype = $mtypeArray[$ext];
	if (empty($mtype))
	{
		$mtype = 'application/force-download';
	}
	return $mtype;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////


?>
