<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Xdbase_AbstractFilterForm.class.php,v 1.8 2011/08/27 10:38:22 bluemelon Exp $
 */

class Xdbase_AbstractFilterForm
{
	var $mController = null;

	var $mSort = 0;
	var $mSortKeys = array();
	var $mNavi = null;
	var $_mHandler = null;
	var $_mCriteria = null;
	var $mObjectHandler = null;

	/**
	 * @protected
	 */
	function _getId()
	{
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
	}

	/**
	 * @protected
	 */
	function Xdbase_AbstractFilterForm($controller)
	{
		$this->mController =& $controller;
		$this->_mCriteria =& new Xdbase_CriteriaCompo();
	}

	/**
	 * @protected
	 */
	function prepare(&$navi, &$handler)
	{
		$this->mNavi =& $navi;
		$this->_mHandler =& $handler;
	}

	/**
	 * @protected
	 */
	function getTotalItems()
	{
		return $this->_mHandler->getCount($this->getCriteria());
	}

	/**
	 * @protected
	 */
	function fetchSort()
	{
		$this->mSort = intval(xdbaseGetRequest($this->mNavi->mPrefix . 'sort'));
	
		if (!isset($this->mSortKeys[abs($this->mSort)])) {
			$this->mSort = $this->getDefaultSortKey();
		}
	
		$this->mNavi->mSort[$this->mNavi->mPrefix . 'sort'] = $this->mSort;
	}

	/**
	 * @public
	 */
	function fetch()
	{
		$this->mNavi->fetch();
		$this->fetchSort();
	}

	/**
	 * @public
	 */
	function getSort()
	{
		$sortkey = abs($this->mSort);
		return $this->mSortKeys[$sortkey];
	}

	/**
	 * @public
	 */
	function getOrder()
	{
		return ($this->mSort < 0) ? 'DESC' : 'ASC';
	}

	/**
	 * @public
	 */
	function &getCriteria($start = null, $limit = null)
	{
		$t_start = ($start === null) ? $this->mNavi->getStart() : intval($start);
		$t_limit = ($limit === null) ? $this->mNavi->getPerpage() : intval($limit);
	
		$criteria = $this->_mCriteria;
	
		$criteria->setStart($t_start);
		$criteria->setLimit($t_limit);
		return $criteria;
	}

	function get($key=null)
	{
	}

	function getSyllableArray()
	{
	}

	function getPerpage()
	{
	}

	function getPerpageArray()
	{
	}

	function getCid()
	{
	}

	function getTagValue()
	{
	}

	function getTagCloudAjax()
	{
	}

	function getTagCloud()
	{
	}

	function getTotal()
	{
	}

	function getPrevYearUrl()
	{
	}

	function getNextYearUrl()
	{
	}

	function getPrevMonthUrl()
	{
	}

	function getNextMonthUrl()
	{
	}

	function getSelectMonthUrl()
	{
	}

	function getPrevWeekUrl()
	{
	}

	function getNextWeekUrl()
	{
	}

	function getPrevDayUrl()
	{
	}

	function getNextDayUrl()
	{
		return $ret;
	}

	function getSelectDayUrl()
	{
	}

	function getToDayUrl()
	{
	}

	function getYear()
	{
	}

	function getYearStr()
	{
	}

	function getMonth()
	{
	}

	function getMonthStr()
	{
	}

	function getWeek()
	{
	}

	function getDay()
	{
	}

	function getDateUnixTime($hour=0)
	{
	}

	function getYears()
	{
	}

	function getWeekArray()
	{
	}

	function getCalender()
	{
	}

	function getObjectsFromDate()
	{
	}

	function getObjectsFromTime()
	{
	}





}

?>
