<?php
/**
 * @file
 * @package xdbase
 * @version $Id: CatEditForm.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_ActionForm.class.php';

class Xdbase_Admin_CatEditForm extends Xdbase_ActionForm
{
	var $mFormImage = null;
	var $mOldImageName = null;

	/**
	 * @public
	 */
	function getTokenName()
	{
		return 'module.xdbase.Admin_CatEditForm.TOKEN';
	}

	/**
	 * @public
	 */
	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['cid'] =& new Xdbase_IntProperty('cid');
		$this->mFormProperties['pid'] =& new Xdbase_IntProperty('pid');
		$this->mFormProperties['title'] =& new Xdbase_StringProperty('title');
		$this->mFormProperties['description'] =& new Xdbase_TextProperty('description');
		$this->mFormProperties['img'] =& new Xdbase_ImageFileProperty('img');
		$this->mFormProperties['img_height'] =& new Xdbase_IntProperty('img_height');
		$this->mFormProperties['img_width'] =& new Xdbase_IntProperty('img_width');
		$this->mFormProperties['weight'] =& new Xdbase_IntProperty('weight');
		$this->mFormProperties['status'] =& new Xdbase_BoolProperty('status');
		$this->mFormProperties['access'] =& new Xdbase_IntProperty('access');
		$this->mFormProperties['groups'] =& new Xdbase_IntArrayProperty('groups');
		$this->mFormProperties['created_date'] =& new Xdbase_IntProperty('created_date');
		$this->mFormProperties['updated_date'] =& new Xdbase_IntProperty('updated_date');
		$this->mFormProperties['show_map'] =& new Xdbase_BoolProperty('show_map');
		$this->mFormProperties['latitude'] =& new Xdbase_FloatProperty('latitude');
		$this->mFormProperties['longitude'] =& new Xdbase_FloatProperty('longitude');
		$this->mFormProperties['zoom'] =& new Xdbase_IntProperty('zoom');
		$this->mFormProperties['icon'] =& new Xdbase_StringProperty('icon');
		$this->mFormProperties['icon_width'] =& new Xdbase_IntProperty('icon_width');
		$this->mFormProperties['icon_height'] =& new Xdbase_IntProperty('icon_height');
		$this->mFormProperties['int01'] =& new Xdbase_IntProperty('int01');
		$this->mFormProperties['int02'] =& new Xdbase_IntProperty('int02');
		$this->mFormProperties['int03'] =& new Xdbase_IntProperty('int03');

		$this->mFormProperties['delete_img'] =& new Xdbase_BoolProperty('delete_img');

		//
		// Set field properties
		//
		$this->mFieldProperties['cid'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['cid']->setDependsByArray(array('required'));
		$this->mFieldProperties['cid']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CAT_CID);
	
//		$this->mFieldProperties['pid'] =& new Xdbase_FieldProperty($this);
//		$this->mFieldProperties['pid']->setDependsByArray(array('required'));
//		$this->mFieldProperties['pid']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CAT_PID);
	
		$this->mFieldProperties['title'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['title']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['title']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CAT_TITLE, '255');
		$this->mFieldProperties['title']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_CAT_TITLE, '255');
		$this->mFieldProperties['title']->addVar('maxlength', '255');
	
		$this->mFieldProperties['img'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['img']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['img']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_CAT_IMG, '64');
		$this->mFieldProperties['img']->addVar('maxlength', '64');

//		$this->mFieldProperties['weight'] =& new Xdbase_FieldProperty($this);
//		$this->mFieldProperties['weight']->setDependsByArray(array('required'));
//		$this->mFieldProperties['weight']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CAT_WEIGHT);
	
//		$this->mFieldProperties['access'] =& new Xdbase_FieldProperty($this);
//		$this->mFieldProperties['access']->setDependsByArray(array('required'));
//		$this->mFieldProperties['access']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CAT_ACCESS);
	
//		$this->mFieldProperties['created_date'] =& new Xdbase_FieldProperty($this);
//		$this->mFieldProperties['created_date']->setDependsByArray(array('required'));
//		$this->mFieldProperties['created_date']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CAT_CREATED_DATE);
	
//		$this->mFieldProperties['updated_date'] =& new Xdbase_FieldProperty($this);
//		$this->mFieldProperties['updated_date']->setDependsByArray(array('required'));
//		$this->mFieldProperties['updated_date']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CAT_UPDATED_DATE);

		$this->mFieldProperties['icon'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['icon']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['icon']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_CAT_ICON, '100');
		$this->mFieldProperties['icon']->addVar('maxlength', '100');

	}
/*
	function validateGroups()
	{
		$groupHandler =& xoops_gethandler('group');
		foreach ($this->get('groups') as $gid)
		{
			$group =& $groupHandler->get($gid);
			if (!is_object($group))
			{
				$this->addErrorMessage(_MD_XDBASE_ERROR_GROUP_VALUE);
			}
		}
	}
*/
	/**
	 * @public
	 */
	function load(&$obj)
	{
		$this->set('cid', $obj->get('cid'));
		$this->set('pid', $obj->get('pid'));
		$this->set('title', $obj->get('title'));
		$this->set('description', $obj->get('description'));
//		$this->set('img', $obj->get('img'));
		$this->set('img_height', $obj->get('img_height'));
		$this->set('img_width', $obj->get('img_width'));
		$this->set('weight', $obj->get('weight'));
		$this->set('status', $obj->get('status'));
		$this->set('access', $obj->get('access'));
		$this->set('created_date', $obj->get('created_date'));
		$this->set('updated_date', $obj->get('updated_date'));
		$this->set('show_map', $obj->get('show_map'));
		$this->set('latitude', $obj->get('latitude'));
		$this->set('longitude', $obj->get('longitude'));
		$this->set('zoom', $obj->get('zoom'));
		$this->set('icon', $obj->get('icon'));
		$this->set('icon_width', $obj->get('icon_width'));
		$this->set('icon_height', $obj->get('icon_height'));
		$this->set('int01', $obj->get('int01'));
		$this->set('int02', $obj->get('int02'));
		$this->set('int03', $obj->get('int03'));

		$this->mOldImageName = $obj->get('img');

		if ($obj->isNew())
		{
			$groupHandler =& xoops_gethandler('group');
			$groups =& $groupHandler->getObjects(null, true);
			$i = 0;
			foreach ($groups as $gid => $group)
			{
				$this->set('groups', $i++, $gid);
			}

			// set Gmap default value
			$this->set('latitude', _MD_XDBASE_CONST_GMAPLATI);
			$this->set('longitude', _MD_XDBASE_CONST_GMAPLONGI);
			$this->set('zoom', _MD_XDBASE_CONST_GMAPZOOM);

		}
		else
		{
			$groupsArray = explode(',', $obj->get('groups'));
			if (is_array($groupsArray))
			{
				$i = 0;
				foreach ($groupsArray as $gid)
				{
					$this->set('groups', $i++, intval($gid));
				}
			}
		}
	}

	/**
	 * @public
	 */
	function update(&$obj)
	{
		$obj->set('cid', $this->get('cid'));
		$obj->set('pid', $this->get('pid'));
		$obj->set('title', $this->get('title'));
		$obj->set('description', $this->get('description'));
//		$obj->set('img', $this->get('img'));
//		$obj->set('img01_height', $this->get('img01_height'));
//		$obj->set('img01_width', $this->get('img01_width'));
		$obj->set('weight', $this->get('weight'));
		$obj->set('status', $this->get('status'));
		$obj->set('access', $this->get('access'));
//		$obj->set('groups', $this->get('groups'));
//		$obj->set('created_date', $this->get('created_date'));
//		$obj->set('updated_date', time());
		$obj->set('show_map', $this->get('show_map'));
		$obj->set('latitude', $this->get('latitude'));
		$obj->set('longitude', $this->get('longitude'));
		$obj->set('zoom', $this->get('zoom'));
		$obj->set('icon', $this->get('icon'));
//		$obj->set('icon_width', $this->get('icon_width'));
//		$obj->set('icon_height', $this->get('icon_height'));
		$obj->set('int01', $this->get('int01'));
		$obj->set('int02', $this->get('int02'));
		$obj->set('int03', $this->get('int03'));

		if ($obj->isNew())
		{
			$obj->set('created_date', time());
		}
		else
		{
			$obj->set('created_date', $obj->get('created_date'));
		}
		$obj->set('updated_date', time());

		// groups
		$groupsArray = $this->get('groups');
		$groups = '';
		if (count($groupsArray) > 0)
		{
			$groups = implode(',', $this->get('groups'));
		}
		$obj->set('groups', $groups);

		$iconPath = XOOPS_ROOT_PATH.'/modules/'._MD_XDBASE_CONST_MODULEDIRNAME.'/images/icon/'.$this->get('icon');
		$icon_width = 0;
		$icon_height = 0;
		if (is_file($iconPath))
		{
			list($icon_width,$icon_height,$type,$attr) = @getimagesize($iconPath);
		}
		$obj->set('icon_width', $icon_width);
		$obj->set('icon_height', $icon_height);

		// image file upload
		$this->mFormImage = $this->get('img');

		if ($this->mFormImage != null && is_object($this->mFormImage))
		{
			$this->mFormImage->setRandomToBodyName('xdbase');
			$imageName = $this->mFormImage->getBodyName();
			$this->mFormImage->setBodyName(substr($imageName, 0, 24));
			$obj->set('img', $this->mFormImage->getFileName());
			list($width, $height) = xdbaseCalcImageSize(_MD_XDBASE_CONST_MAXCATIMGSIZE, $this->mFormImage->getWidth(), $this->mFormImage->getHeight());
			$obj->set('img_width', $width);
			$obj->set('img_height', $height);
			$this->deleteImage($this->mOldImageName);
		}
		else
		{
			if ($this->get('delete_img') == true)
			{
				$obj->set('img', '');
				$this->deleteImage($this->mOldImageName);
			}
		}


	}

	function deleteImage($imageName)
	{
		if ($imageName != '')
		{
			if (file_exists(_MD_XDBASE_CONST_CATIMG_PATH.'/'.$imageName))
			{
				@unlink(_MD_XDBASE_CONST_CATIMG_PATH.'/'.$imageName);
			}
		}
	}

}

?>
