<?php
/**
 * @file
 * @package xdbase
 * @version $Id: CatDeleteForm.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_ActionForm.class.php';

class Xdbase_Admin_CatDeleteForm extends Xdbase_ActionForm
{
	var $mOldImageName = null;

	/**
	 * @public
	 */
	function getTokenName()
	{
		return 'module.xdbase.Admin_CatDeleteForm.TOKEN';
	}

	/**
	 * @public
	 */
	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['cid'] =& new Xdbase_IntProperty('cid');
	
		//
		// Set field properties
		//
		$this->mFieldProperties['cid'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['cid']->setDependsByArray(array('required'));
		$this->mFieldProperties['cid']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CAT_CID);
	}

	/**
	 * @public
	 */
	function load(&$obj)
	{
		$this->set('cid', $obj->get('cid'));
		$this->mOldImageName = $obj->get('img');
	}

	/**
	 * @public
	 */
	function update(&$obj)
	{
		$obj->set('cid', $this->get('cid'));

		if ($this->mOldImageName != '')
		{
			if (file_exists(_MD_XDBASE_CONST_CATIMG_PATH.'/'.$this->mOldImageName))
			{
				@unlink(_MD_XDBASE_CONST_CATIMG_PATH.'/'.$this->mOldImageName);
			}
		}
	}
}

?>
