<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attributeEditAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractEditAction.class.php';

class Xdbase_Admin_Data_attributeEditAction extends Xdbase_AbstractEditAction
{
	var $mAttributeActionForm = null;

	/**
	 * @protected
	 */
	function _getId()
	{
		return xdbaseGetRequest('aid');
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data_attribute');
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'admin.edit_data_attribute');
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('object', $this->mObject);
		$this->mTpl->assign('handler', $this->mObjectHandler);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/data_attribute_edit.html');
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeView&aid='.$this->mObject->getShow('aid'));
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=Data_attributeList', 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeList');
	}


	function _doExecute()
	{
		if ($this->mObjectHandler->insert($this->mObject))
		{
			return XDBASE_FRAME_VIEW_SUCCESS;
		}

		return XDBASE_FRAME_VIEW_ERROR;
	}

}

?>
