<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataDeleteAction.class.php,v 1.13 2011/08/27 10:38:22 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractDeleteAction.class.php';

class Xdbase_Admin_DataDeleteAction extends Xdbase_AbstractDeleteAction
{
	/**
	 * @protected
	 */
	function &_getId()
	{
		$ret = xdbaseGetRequest('did');
		return $ret;
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data');
		return $handler;
	}

	/**
	 * @protected
	 */
	function &_setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'admin.delete_data');
		$ret =& $this->mActionForm->prepare();
		return $ret;
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('object', $this->mObject);

		$handler =& $this->mController->load('handler', 'data');
		$this->mTpl->assign('handler', $handler);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/data_delete.html');
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeForward('./index.php?action=DataList');
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=DataList', 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=DataList');
	}

	/**
	 * @protected
	 */
	function _doExecute()
	{
		if ($this->mObjectHandler->delete($this->mObject))
		{
			xoops_comment_delete($this->mController->mXoopsModule->getVar('mid'), $this->_getId());
			xoops_notification_deletebyitem($this->mController->mXoopsModule->getVar('mid'), 'data', $this->_getId());
			return XDBASE_FRAME_VIEW_SUCCESS;
		}

		return XDBASE_FRAME_VIEW_ERROR;
	}

}

?>
