<?php
// $Id: weblinks_votedata_handler.php,v 1.1 2006/01/16 07:24:56 ohwada Exp $

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// 2004/01/14 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_votedata_handler') ) 
{

//=========================================================
// class weblinks_votedata_handler
//=========================================================
class weblinks_votedata_handler extends weblinks_module_base
{
// tablefield
  var $ratingid;
  var $lid;
  var $ratinguser;
  var $rating;
  var $ratinghostname;
  var $ratingtimestamp;

// local

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_votedata_handler( $dirname )
{
	$this->weblinks_module_base();
	$this->check_dirname( $dirname, 'weblinks_votedata_handler' );

	$this->table = $this->xoops_db->prefix( $dirname.'_votedata' );
}

//---------------------------------------------------------
// insert
// for ratelink.php
//---------------------------------------------------------
function insert($lid, $ratinguser, $rating, $ip)
{
	$time = time();

	$sql  = "INSERT INTO ".$this->table." ";
	$sql .= "(lid, ratinguser, rating, ratinghostname, ratingtimestamp) ";
	$sql .= "VALUES ";
	$sql .= "($lid, $ratinguser, $rating, '$ip', $time)";

    return  $this->query_false($sql);
}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
// for admin/votedata.php
function delete($rid)
{
	$sql = "DELETE FROM $this->table WHERE ratingid=$rid";
    return  $this->query_false($sql);
}

// for admin/category.php
function deleteByLid($lid)
{
	$sql = "DELETE FROM $this->table WHERE lid=$lid";
    return  $this->query_false($sql);
}

//---------------------------------------------------------
// update
//---------------------------------------------------------

//---------------------------------------------------------
// select
//---------------------------------------------------------
// for admin/link.php
function getNumByLid($lid)
{
	$sql = "SELECT count(*) FROM ".$this->table." WHERE lid=$lid";
	return $this->get_num_by_sql($sql);
}

// for ratelink.php
function getNumByLidIpTime($lid,$ip,$time)
{
// bugfix #2409: when anonymous users rate a link, sql error is displayed
	$sql = "SELECT count(*) FROM ".$this->table." WHERE lid=$lid AND ratinguser=0 AND ratinghostname='$ip' AND ratingtimestamp > $time";
	return $this->get_num_by_sql($sql);
}

// for admin/votedata.php
function getRowByRatingid($rid)
{
	$sql = "SELECT * FROM ".$this->table." WHERE ratingid=$rid";
	return $this->get_row_by_sql($sql);
}

// for ratelink.php
function getRowsByLid($lid,$limit=0,$start=0)
{
	$sql = "SELECT * FROM ".$this->table." WHERE lid=$lid";
	return $this->get_row_array_by_sql($sql,$limit,$start);
}

// for admin/link.php
function getRowsByLidUser($lid)
{
	$sql = "SELECT * FROM $this->table WHERE lid=$lid AND ratinguser>0 ORDER BY ratingtimestamp DESC";
	return $this->get_row_array_by_sql($sql);
}

// for admin/link.php
function getRowsByLidRatinguser($lid,$user)
{
	$sql = "SELECT * FROM $this->table WHERE lid=$lid AND ratinguser=$user ORDER BY ratingtimestamp DESC";
	return $this->get_row_array_by_sql($sql);
}

// for admin/link.php
function getRatingByRatinguser($user)
{
	$sql   = "SELECT * FROM $this->table WHERE ratinguser=$user";
	$rows  = $this->get_row_array_by_sql($sql);
	$votes = count($rows);

	if ($votes==0) return array(0,0);

	$total = 0;
	foreach ( $rows as $row ) 
	{	$total += $row['rating'];	}
	$total = $total/$votes;

	return array($votes,$total);
}


//---------------------------------------------------------
// display
//---------------------------------------------------------
// move from functions.php
// updaterating($sel_id)
// updates rating data in itemtable for a given item
// for ratelink.php
function getRating($lid)
{
	$records = $this->getRowsByLid($lid);
	$count   = count($records);

	if ($count == 0)  return array(0, 0);

	$totalrating = 0;
	foreach ($records as $record)
	{  $totalrating += $record['rating'];  }

	$finalrating = $totalrating / $count;
	$finalrating = number_format($finalrating, 4);

	return array($finalrating, $count);
}

// --- class end ---
}

// === class end ===
}

?>