<?php
// $Id: weblinks_template.php,v 1.1 2006/01/16 07:24:56 ohwada Exp $

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication
// move from include/functions

//================================================================
// WebLinks Module
// 2004/01/23 K.OHWADA
//================================================================

//---------------------------------------------------------
// TODO
// global $xoopsTpl, $xoopsModuleConfig;
// global $weblinksConfig;
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_template') ) 
{

//=========================================================
// class weblinks_template
//=========================================================
class weblinks_template
{
// handler
	var $tbl_link;
	var $tbl_category;
	var $tbl_atomfeed;

// constant
	var $_MODULE_NAME_DEFAULT = "Web Links";

// dirname
	var $_module_url;
	var $_template_header;
	var $_template_link_single;

// system variable
	var $_module_name;
	var $_language;
	var $_country;
	var $_happy_linux_url;

// local variable
	var $_time_start = 0;
	var $_time_prev  = 0;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_template( $dirname )
{
// handler
	$this->tbl_link     =& weblinks_get_handler( 'link',     $dirname );
	$this->tbl_category =& weblinks_get_handler( 'category', $dirname );
	$this->tbl_atomfeed =& weblinks_get_handler( 'atomfeed', $dirname );

// module name
	$this->_module_name = $this->_get_module_name();
	$this->_module_url  = XOOPS_URL."/modules/".$dirname;

// system
	$lang =& weblinks_language_convert::getInstance();
	$this->_country         = $lang->get_country();
	$this->_happy_linux_url = $lang->get_happy_linux_url();

	$this->_language = $this->_get_language();

// template
	$this->_template_header      = 'db:'.$dirname.'_header.html';
	$this->_template_link_single = 'db:'.$dirname.'_link_single.html';
	$this->_template_links_list  = 'db:'.$dirname.'_links_list.html';
}

//-------------------------------------------------------------------
// assign template
//-------------------------------------------------------------------
function assignIndex()
{
	global $xoopsTpl;
	$this->_assign_header_common( $xoopsTpl );
}

function assignDisplayLink()
{
	global $xoopsTpl;
	$this->_assign_link_common( $xoopsTpl );
}

function fetch_header()
{
	$tpl = new XoopsTpl();
	$this->_assign_header_common( $tpl );
	return $tpl->fetch( $this->_template_header );

}

function fetch_link_single( $link )
{
	$tpl = new XoopsTpl();
	$this->_assign_link_common( $tpl );
	$tpl->assign('link', $link);
	return $tpl->fetch( $this->_template_link_single );
}

function fetch_links_full( $links )
{
	$text = '';
	foreach ($links as $link) 
	{
		$text .= $this->fetch_link_single( $link );
	}
	return $text;
}

function fetch_links_list( $links )
{
	$tpl = new XoopsTpl();
	$this->_assign_link_common( $tpl );

	foreach ($links as $link) 
	{
		$tpl->append('links', $link);
	}

	return $tpl->fetch( $this->_template_links_list );
}

//=========================================================
// private
//=========================================================
function _get_module_name()
{
	global $xoopsModule;
	if ( is_object($xoopsModule) )
	{
		$module_name = $xoopsModule->getVar('name');
	}
	else
	{
		$module_name = $this->_MODULE_NAME_DEFAULT;
	}
	return $module_name;
}

function _get_language()
{
	global $xoopsConfig;
	if ( isset($xoopsConfig['language']) )
	{
		return $xoopsConfig['language'];
	}
	return false;
}

function _is_user()
{
	global $xoopsUser;
	if ( is_object($xoopsUser) )
	{
		return true;
	}
	return false;
}

function _assign_header_common( &$tpl )
{
	global $xoopsModuleConfig;
	$TOPTEN_LINKS = intval($xoopsModuleConfig['topten_links']);

	$tpl->assign('logoshow',       $xoopsModuleConfig['logoshow']);
	$tpl->assign('titleshow',      $xoopsModuleConfig['titleshow']);

	$tpl->assign('xoops_language', $this->_language );
	$tpl->assign('module_name',    $this->_module_name );
	$tpl->assign('module_url',     $this->_module_url );
	$tpl->assign('happy_linux_url',  $this->_happy_linux_url );

// total count
	$total_site_recommend = $this->tbl_link->getNumByMark('recommend');
	$total_site_mutual    = $this->tbl_link->getNumByMark('mutual');
	$total_site_rss       = $this->tbl_link->getNumRssFlag();
	$total_atomfeed       = $this->tbl_atomfeed->getNumAll();

	$tpl->assign('total_site_recommend', $total_site_recommend);
	$tpl->assign('total_site_mutual',    $total_site_mutual);
	$tpl->assign('total_site_rss',       $total_site_rss);
	$tpl->assign('total_atomfeed',       $total_atomfeed);

// BUG 3111: timeout occurs in popular site if many top categories
	$tpl->assign('total_site_topten', "top".$TOPTEN_LINKS);

// search
	$and = "selected='selected'";
	$tpl->assign('search_and',     $and);
	$tpl->assign('search_or',      '');
	$tpl->assign('search_exact',   '');
	$tpl->assign('search_query',   '');

// REQ 3110: Add in this category
	if ( isset($_GET['cid']) )
	{
		$tpl->assign('cid', intval($_GET['cid']) );
	}

// --- lang ---
	$tpl->assign('lang_search',   _WLS_SEARCH);
	$tpl->assign('lang_all',      _SR_ALL);
	$tpl->assign('lang_any',      _SR_ANY);
	$tpl->assign('lang_exact',    _SR_EXACT);
	$tpl->assign('lang_nomatch',  _WLS_NOMATCH);

// guidance bar
	$tpl->assign('lang_main',           _WLS_MAIN);
	$tpl->assign('lang_submitlink',     _WLS_SUBMIT_NEW_LINK);
	$tpl->assign('lang_site_popular',   _WLS_SITE_POPULAR);	
	$tpl->assign('lang_site_highrate',  _WLS_SITE_HIGHRATE);
	$tpl->assign('lang_site_recommend', _WLS_SITE_RECOMMEND);
	$tpl->assign('lang_site_mutual',    _WLS_SITE_MUTUAL);

// second guidance bar
	$tpl->assign('lang_catlist',        _WLS_CATLIST);
	$tpl->assign('lang_site_rss',       _WLS_SITE_RSS);
	$tpl->assign('lang_atomfeed',       _WLS_ATOMFEED);
	$tpl->assign('lang_site_random',    _WLS_SITE_RANDOM);

// index.php
	$tpl->assign('lang_new_sitelist',   _WLS_NEW_SITELIST);
	$tpl->assign('lang_new_atomfeed',   _WLS_NEW_ATOMFEED);

}

function _assign_link_common( &$tpl )
{
	$tpl->assign('module_url', $this->_module_url);

// index
	$tpl->assign('lang_lastupdate',      _WLS_LASTUPDATE);
	$tpl->assign('lang_hits',            _WLS_HITS);
	$tpl->assign('lang_rating',          _WLS_RATING);
	$tpl->assign('lang_more',            _WLS_MORE);
	$tpl->assign('lang_image_new',       _WLS_SITE_NEW);
	$tpl->assign('lang_image_update',    _WLS_SITE_UPDATE);
	$tpl->assign('lang_image_popular',   _WLS_SITE_POPULAR);
	$tpl->assign('lang_image_recommend', _WLS_SITE_RECOMMEND);
	$tpl->assign('lang_image_mutual',    _WLS_SITE_MUTUAL);

// singlelink
	$tpl->assign('lang_visit' ,          _WLS_VISIT);
	$tpl->assign('lang_category' ,       _WLS_CATEGORY);
	$tpl->assign('lang_promoter',        _WLS_PROMOTER);
	$tpl->assign('lang_zip',             _WLS_ZIP);
	$tpl->assign('lang_addr',            _WLS_ADDR);
	$tpl->assign('lang_tel',             _WLS_TEL);
	$tpl->assign('lang_fax',             _WLS_FAX);
	$tpl->assign('lang_description',     _WLS_DESCRIPTION);
	$tpl->assign('lang_admincommnet',    _WLS_ADMINCOMMENT);
	$tpl->assign('lang_modify',          _WLS_MODIFY);
	$tpl->assign('lang_editthislink' ,   _WLS_EDITTHISLINK);
	$tpl->assign('lang_ratethissite',    _WLS_RATETHISSITE);
	$tpl->assign('lang_reportbroken',    _WLS_REPORTBROKEN);
	$tpl->assign('lang_tellafriend',     _WLS_TELLAFRIEND);
	$tpl->assign('lang_comments' ,       _COMMENTS);

//	$tpl->assign('lang_latestlistings' , _WLS_LATESTLIST);

// use_ratelink
	global $weblinksConfig;
	if ( $weblinksConfig['is_auth_ratelink'] )
	{
		$tpl->assign('ratelink_show', 1 );
		$tpl->assign('ratelink_post', $weblinksConfig['is_auth_ratelink'] );
	}
	else
	{
		$tpl->assign('ratelink_show', 0);
		$tpl->assign('ratelink_post', 0);
	}

// language
	$tpl->assign('xoops_language', $this->_language );
	$tpl->assign('country',        $this->_country );

// banner
	global $xoopsModuleConfig;
	$tpl->assign('link_image_use', $xoopsModuleConfig['linkimage_use']);
	$tpl->assign('list_image_use', $xoopsModuleConfig['listimage_use']);

}

// --- class end ---
}

// === class end ===
}

?>