<?php
// $Id: weblinks_remote_image.php,v 1.1 2006/01/16 07:24:56 ohwada Exp $

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_remote_image') ) 
{

//---------------------------------------------------------
// define constant
//---------------------------------------------------------
define('WEBLINKS_REMOTE_E_NOT_WRITABLE', 200);

//=========================================================
// class weblinks_remote_image
//=========================================================
class weblinks_remote_image extends weblinks_remote_file
{
// class instance
	var $_image_size;

// local
	var $_dir_work;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_remote_image()
{
	$this->weblinks_remote_file();

// class instance
	$this->_image_size  =& weblinks_image_size::getInstance();

// work directory
	$dirname = $this->_get_dirname();
	$this->_dir_work = XOOPS_ROOT_PATH."/modules/".$dirname."/cache";
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_remote_image();
	}

	return $instance;
}

//=========================================================
// public
//=========================================================
//---------------------------------------------------------
//  get_image_size
//---------------------------------------------------------
function get_image_size($url)
{
	$this->_error_code = 0;

	if ( empty($url) )
	{
		$this->_error_code = WEBLINKS_REMOTE_E_EMPTY_URL;
		return false;
	}

// allow_url_fopen
	if ( $this->_flag_allow_url_fopen )
	{
		return $this->_image_size->get_size($url);
	}
// not allow_url_fopen
	else
	{
		return $this->_get_image_size_local($url);
	}

}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_dir_work($value)
{
	$this->_dir_work = $value;
}

//=========================================================
// private
//=========================================================
function _get_image_size_local($url)
{
	if ( !is_writable($this->_dir_work) )
	{
		$this->_error_code = WEBLINKS_REMOTE_E_NOT_WRITABLE;
		return false;
	}

	$data = $this->_read_file_remote( $url );
	if ( !$data )
	{
		return false;
	}

	$file = tempnam($this->_dir_work, "image");

	if ( !$this->_fwrite_file( $file, $data ) )
	{
		return false;
	}

	$ret2 = $this->_image_size->get_size($file);

	unlink($file);

	return $ret2;

}

function _get_dirname()
{
	global $xoopsModule;
	if ( is_object($xoopsModule) )
	{
		$dirname = $xoopsModule->dirname();
	}
	else
	{
		$dirname = basename( dirname( dirname( __FILE__ ) ) );
	}
	return $dirname;
}

// --- class end ---
}

// === class end ===
}

?>