<?php
// $Id: weblinks_config_handler.php,v 1.1 2006/01/16 07:24:56 ohwada Exp $

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication


//=========================================================
// WebLinks Module
// class table_config
// 2004-12-05 K.OHWADA
//=========================================================

//---------------------------------------------------------
// TODO
// use link_hanlder in check_rss_url
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_config_handler') ) 
{

//=========================================================
// class weblinks_config_handler
//=========================================================
class weblinks_config_handler extends weblinks_module_base
{

// tablefield
	var $auth_submit;
	var $auth_submit_auto;
	var $auth_modify;
	var $auth_modify_auto;
	var $auth_ratelink;
	var $use_passwd;
	var $use_ratelink;
	var $rss_mode_auto;
	var $rss_mode_title;
	var $rss_mode_content;
	var $rss_mode_data;
	var $rss_cache_time;
	var $rss_limit;
	var $rss_new;
	var $rss_perpage;
	var $rss_num_content;
	var $rss_max_content;
	var $rss_max_summary;
	var $rss_site;
	var $rss_black;
	var $rss_white;
	var $cat_sel;
	var $cat_sub;
	var $cat_img_mode;
	var $cat_img_width;
	var $cat_img_height;

// tablefield for link_table
	var $post_title;	// no use
	var $post_category;	// no use
	var $post_url;
	var $post_desc;
	var $post_banner;
	var $post_rss_url;
	var $post_name;
	var $post_mail;
	var $post_company;
	var $post_zip;
	var $post_state;
	var $post_city;
	var $post_addr;
	var $post_addr2;
	var $post_tel;
	var $post_fax;
//	var $post_rss_url;  // deleted
	var $post_passwd;	// no use
	var $post_usercomment;
	var $type_desc;
	var $check_double;

// array value
	var $auth_submit_arr;
	var $auth_submit_auto_arr;
	var $auth_modify_arr;
	var $auth_modify_auto_arr;
	var $auth_ratelink_arr;
	var $rss_black_arr;
	var $rss_white_arr;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config_handler( $dirname )
{
	$this->weblinks_module_base();
	$this->check_dirname( $dirname, 'weblinks_config_handler' );

	$this->table = $this->xoops_db->prefix( $dirname.'_config' );
	$this->module_dirname = $dirname;

}

//---------------------------------------------------------
// insert
//---------------------------------------------------------

//---------------------------------------------------------
// delete
//---------------------------------------------------------

//---------------------------------------------------------
// update
//---------------------------------------------------------
function update_auth()
{
	$sql  = "UPDATE $this->table SET ";
	$sql .= "auth_submit='$this->auth_submit', ";
	$sql .= "auth_submit_auto='$this->auth_submit_auto', ";
	$sql .= "auth_modify='$this->auth_modify', ";
	$sql .= "auth_modify_auto='$this->auth_modify_auto', ";
	$sql .= "auth_ratelink='$this->auth_ratelink', ";
	$sql .= "use_passwd=$this->use_passwd, ";
	$sql .= "use_ratelink=$this->use_ratelink ";
	return $this->query_false($sql);
}

function update_rss()
{
	$sql  = "UPDATE $this->table SET ";
	$sql .= "rss_mode_auto=$this->rss_mode_auto, ";
	$sql .= "rss_mode_data=$this->rss_mode_data, ";
	$sql .= "rss_cache_time=$this->rss_cache_time, ";
	$sql .= "rss_limit=$this->rss_limit, ";
	$sql .= "rss_site='$this->rss_site', ";
	$sql .= "rss_black='$this->rss_black', ";
	$sql .= "rss_white='$this->rss_white' ";

	return $this->query_false($sql);
}

function update_rss_view()
{
	$sql  = "UPDATE $this->table SET ";
	$sql .= "rss_mode_title=$this->rss_mode_title, ";
	$sql .= "rss_mode_content=$this->rss_mode_content, ";
	$sql .= "rss_new=$this->rss_new, ";
	$sql .= "rss_perpage=$this->rss_perpage, ";
	$sql .= "rss_num_content=$this->rss_num_content, ";
	$sql .= "rss_max_content=$this->rss_max_content, ";
	$sql .= "rss_max_summary=$this->rss_max_summary ";

	return $this->query_false($sql);
}

function update_post()
{
	$sql  = "UPDATE $this->table SET ";
	$sql .= "post_url=$this->post_url, ";
	$sql .= "post_banner=$this->post_banner, ";
	$sql .= "post_rss_url=$this->post_rss_url, ";
	$sql .= "post_name=$this->post_name, ";
	$sql .= "post_mail=$this->post_mail, ";
	$sql .= "post_company=$this->post_company, ";
	$sql .= "post_zip=$this->post_zip, ";
	$sql .= "post_state=$this->post_state, ";
	$sql .= "post_city=$this->post_city, ";
	$sql .= "post_addr=$this->post_addr, ";
	$sql .= "post_addr2=$this->post_addr2, ";
	$sql .= "post_tel=$this->post_tel, ";
	$sql .= "post_fax=$this->post_fax, ";
	$sql .= "post_desc=$this->post_desc, ";
	$sql .= "post_passwd=$this->post_passwd, ";
	$sql .= "post_usercomment=$this->post_usercomment, ";
	$sql .= "type_desc=$this->type_desc, ";
	$sql .= "check_double=$this->check_double ";
	return $this->query_false($sql);
}

function update_category()
{
	$sql  = "UPDATE $this->table SET ";
	$sql .= "cat_sel=$this->cat_sel, ";
	$sql .= "cat_sub=$this->cat_sub, ";
	$sql .= "cat_img_mode=$this->cat_img_mode, ";
	$sql .= "cat_img_width=$this->cat_img_width, ";
	$sql .= "cat_img_height=$this->cat_img_height ";
	return $this->query_false($sql);
}

//---------------------------------------------------------
// select
//---------------------------------------------------------
function get_row_all()
{
	$sql = "SELECT * FROM ".$this->table." ";
	return $this->get_row_by_sql($sql);
}

function get_config()
{
	$arr = array();

	$row = $this->get_row_all();

	foreach($row as $key => $value)
	{
		$arr[$key] = $value;
	}

	$this->auth_submit_arr      = $this->get_field_array( 'auth_submit' );
	$this->auth_submit_auto_arr = $this->get_field_array( 'auth_submit_auto' );
	$this->auth_modify_arr      = $this->get_field_array( 'auth_modify' );
	$this->auth_modify_auto_arr = $this->get_field_array( 'auth_modify_auto' );
	$this->auth_ratelink_arr    = $this->get_field_array( 'auth_ratelink' );
	$this->rss_site_arr         = $this->get_field_array( 'rss_site', "\n" );
	$this->rss_black_arr        = $this->get_field_array( 'rss_black', "\n" );
	$this->rss_white_arr        = $this->get_field_array( 'rss_white', "\n" );

	$arr['auth_submit_arr']      = $this->auth_submit_arr;
	$arr['auth_submit_auto_arr'] = $this->auth_submit_auto_arr;
	$arr['auth_modify_arr']      = $this->auth_modify_arr;
	$arr['auth_modify_auto_arr'] = $this->auth_modify_auto_arr;
	$arr['auth_ratelink_arr']    = $this->auth_ratelink_arr;
	$arr['rss_site_arr']         = $this->rss_site_arr;
	$arr['rss_black_arr']        = $this->rss_black_arr;
	$arr['rss_white_arr']        = $this->rss_white_arr;

	$arr['is_auth_submit']       = $this->check_is_auth( 'auth_submit' );
	$arr['is_auth_submit_auto']  = $this->check_is_auth( 'auth_submit_auto' );
	$arr['is_auth_modify']       = $this->check_is_auth( 'auth_modify' );
	$arr['is_auth_modify_auto']  = $this->check_is_auth( 'auth_modify_auto' );
	$arr['is_auth_ratelink']     = $this->check_is_auth( 'auth_ratelink' );

	return $arr;
}

//---------------------------------------------------------
// save auth
//---------------------------------------------------------
function save_auth( $arr )
{
	$this->clear_items(); 
	$this->set_items( $arr );
	$this->make_data_4_save();

	return $this->update_auth();
}

function clear_items()
{
	$default = '&'.XOOPS_GROUP_ADMIN.'&';

	$this->auth_submit      = $default;
	$this->auth_submit_auto = $default;
	$this->auth_modify      = $default;
	$this->auth_modify_auto = $default;
	$this->auth_ratelink    = $default;

	$this->use_passwd    = 0;
	$this->use_ratelink  = 0;

	$this->auth_submit_arr      = '';
	$this->auth_submit_auto_arr = '';
	$this->auth_modify_arr      = '';
	$this->auth_modify_auto_arr = '';
	$this->auth_ratelink_arr    = '';

	$this->rss_mode_auto    = 0;
	$this->rss_mode_title   = 0;
	$this->rss_mode_content = 0;
	$this->rss_mode_data    = 0;
	$this->rss_cache_time   = 0;
	$this->rss_limit        = 0;
	$this->rss_new          = 0;
	$this->rss_perpage      = 0;
	$this->rss_num_content  = 0;
	$this->rss_max_content  = 0;
	$this->rss_max_summary  = 0;
	$this->rss_site         = '';
	$this->rss_black        = '';
	$this->rss_white        = '';

	$this->post_title    = 0;
	$this->post_category = 0;
	$this->post_url      = 0;
	$this->post_banner   = 0;
	$this->post_rss_url  = 0;
	$this->post_name     = 0;
	$this->post_mail     = 0;
	$this->post_company  = 0;
	$this->post_zip      = 0;
	$this->post_state    = 0;
	$this->post_city     = 0;
	$this->post_addr     = 0;
	$this->post_addr2    = 0;
	$this->post_tel      = 0;
	$this->post_fax      = 0;
	$this->post_desc     = 0;
	$this->post_passwd   = 0;
	$this->post_usercomment = 0;
	$this->type_desc     = 0;
	$this->check_double  = 0;

	$this->cat_sel        = 0;
	$this->cat_sub        = 0;
	$this->cat_img_mode    = 0;
	$this->cat_img_width  = 0;
	$this->cat_img_height = 0;

}


function set_items($arr)
{
	$this->set_field_value($arr, 'auth_submit_arr');
	$this->set_field_value($arr, 'auth_submit_auto_arr');
	$this->set_field_value($arr, 'auth_modify_arr');
	$this->set_field_value($arr, 'auth_modify_auto_arr');
	$this->set_field_value($arr, 'auth_ratelink_arr');

	$this->set_field_value_intval($arr, 'use_passwd');
	$this->set_field_value_intval($arr, 'use_ratelink');

	$this->set_field_value_intval($arr, 'rss_mode_auto');
	$this->set_field_value_intval($arr, 'rss_mode_title');
	$this->set_field_value_intval($arr, 'rss_mode_content');
	$this->set_field_value_intval($arr, 'rss_mode_data');
	$this->set_field_value_intval($arr, 'rss_cache_time');
	$this->set_field_value_intval($arr, 'rss_limit');
	$this->set_field_value_intval($arr, 'rss_new');
	$this->set_field_value_intval($arr, 'rss_perpage');
	$this->set_field_value_intval($arr, 'rss_num_content');
	$this->set_field_value_intval($arr, 'rss_max_content');
	$this->set_field_value_intval($arr, 'rss_max_summary');

	$this->set_field_value($arr, 'rss_site');
	$this->set_field_value($arr, 'rss_black');
	$this->set_field_value($arr, 'rss_white');

	$this->set_field_value_intval($arr, 'post_title');
	$this->set_field_value_intval($arr, 'post_category');
	$this->set_field_value_intval($arr, 'post_url');
	$this->set_field_value_intval($arr, 'post_banner');
	$this->set_field_value_intval($arr, 'post_rss_url');
	$this->set_field_value_intval($arr, 'post_name');
	$this->set_field_value_intval($arr, 'post_mail');
	$this->set_field_value_intval($arr, 'post_company');
	$this->set_field_value_intval($arr, 'post_zip');
	$this->set_field_value_intval($arr, 'post_state');
	$this->set_field_value_intval($arr, 'post_city');
	$this->set_field_value_intval($arr, 'post_addr');
	$this->set_field_value_intval($arr, 'post_addr2');
	$this->set_field_value_intval($arr, 'post_tel');
	$this->set_field_value_intval($arr, 'post_fax');
	$this->set_field_value_intval($arr, 'post_desc');
	$this->set_field_value_intval($arr, 'post_passwd');
	$this->set_field_value_intval($arr, 'post_usercomment');
	$this->set_field_value_intval($arr, 'type_desc');
	$this->set_field_value_intval($arr, 'check_double');

	$this->set_field_value_intval($arr, 'cat_sel');
	$this->set_field_value_intval($arr, 'cat_sub');
	$this->set_field_value_intval($arr, 'cat_img_mode');
	$this->set_field_value_intval($arr, 'cat_img_width');
	$this->set_field_value_intval($arr, 'cat_img_height');

}

function make_data_4_save()
{
	$this->auth_submit      = $this->convert_array_to_list($this->auth_submit_arr);
	$this->auth_submit_auto = $this->convert_array_to_list($this->auth_submit_auto_arr);
	$this->auth_modify      = $this->convert_array_to_list($this->auth_modify_arr);
	$this->auth_modify_auto = $this->convert_array_to_list($this->auth_modify_auto_arr);
	$this->auth_ratelink    = $this->convert_array_to_list($this->auth_ratelink_arr);

	$this->rss_site  = $this->xoops_myts->makeTareaData4Save($this->rss_site);
	$this->rss_black = $this->xoops_myts->makeTareaData4Save($this->rss_black);
	$this->rss_white = $this->xoops_myts->makeTareaData4Save($this->rss_white);

}

//---------------------------------------------------------
// save rss
//---------------------------------------------------------
function save_rss( $arr )
{
	$this->clear_items(); 
	$this->set_items( $arr );
	$this->make_data_4_save();

	return $this->update_rss();
}


//---------------------------------------------------------
// check_rss_url
//---------------------------------------------------------
function check_rss_url( $post )
{
//	$tbl_link =& table_link::getInstance();
	$tbl_link =& weblinks_get_handler( 'link', $this->module_dirname );

	$white_arr = array();

	$rss_black = $post['rss_black'];
	$rss_white = $post['rss_white'];

	$this->rss_black_arr = $this->convert_list_to_array( $rss_black, "\n" );
	$this->rss_white_arr = $this->convert_list_to_array( $rss_white, "\n" );

	$lid_array = $tbl_link->getLidArrayAll();

	foreach($lid_array as $lid)
	{
		$tbl_link->getRowByLid($lid);
		$url   = $tbl_link->url;

		$ret = $this->check_black($url);
		if ( $ret )
		{
			$white_arr[] = $url;
		}

	}

	$count = count($white_arr);

	if ($count == 0)  return false;

	return $white_arr;
}

function check_black($url)
{
	if ( count($this->rss_black_arr) == 0 )
	{	return false;	}

	foreach ($this->rss_black_arr as $black)
	{
		$black = str_replace("|", '\|', $black);

		if ( preg_match("|$black|i", $url) )
		{
			$ret = $this->check_white($url);
			if ( !$ret )
			{
//				echo "<font color='red'>".$url."</font><br />\n";
				return true;
			}
		}
	}

	return false;
}

function check_white($url)
{
	if ( count($this->rss_white_arr) == 0 )
	{	return false;	}

	foreach ($this->rss_white_arr as $white)
	{
		$white = str_replace("|", '\|', $white);

		if ( preg_match("|$white|i", $url) )
		{
//			echo "<font color='blue'>".$url."</font><br />\n";
			return true;
		}
	}

	return false;
}


//---------------------------------------------------------
// save rss_view
//---------------------------------------------------------
function save_rss_view( $arr )
{
	$this->clear_items(); 
	$this->set_items( $arr );
	$this->make_data_4_save();

	return $this->update_rss_view();
}

//---------------------------------------------------------
// save use
//---------------------------------------------------------
function save_post( $arr )
{
	$this->clear_items(); 
	$this->set_items( $arr );
	$this->make_data_4_save();

	return $this->update_post();
}

//---------------------------------------------------------
// save category
//---------------------------------------------------------
function save_category( $arr )
{
	$this->clear_items(); 
	$this->set_items( $arr );

	return $this->update_category();
}


//---------------------------------------------------------
// check property
//---------------------------------------------------------
function check_is_auth($value)
{
	if ( !isset($this->$value) )  return 0;

	$auth_arr = $this->convert_list_to_array( $this->$value, '&' );

	if ( $this->is_xoops_user_admin )
	{	return 1;	}

	if ( array_intersect( $auth_arr, $this->xoops_user_groups ) )
	{	return 1;	}

	return 0;
}

function check_in_array($value_check, $value)
{
	if ( !isset($this->$value) )  return false;

	if ( in_array( $value_check, $this->$value) )
	{
		return true;
	}

	return false;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function get_field_array($value, $pattern='&')
{
	if ( !isset($this->$value) )  return false;

	return $this->convert_list_to_array( $this->$value, $pattern );
}

// --- class end ---
}

// === class end ===
}

?>