<?php
// $Id: topten.php,v 1.5 2006/01/16 07:20:54 ohwada Exp $

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// view top ten
// use class weblinksCategory, weblinksLink
// 2004/01/23 K.OHWADA
//================================================================

include "header.php";

// enable to install this module two or more. 

$weblinks_topten_error = '';

$TOPTEN_STYLE = intval($xoopsModuleConfig['topten_style']);
$MAX_LINKS    = intval($xoopsModuleConfig['topten_links']);

if ( $TOPTEN_STYLE )
{
	$xoopsOption['template_main'] = $MODULE_DIRNAME."_topten_mixed.html";
}
else
{
	$xoopsOption['template_main'] = $MODULE_DIRNAME."_topten.html";
}

include XOOPS_ROOT_PATH."/header.php";

// BUG 2932: dont work correctly when register_long_arrays = off
$rate = $post->get_get_int('rate');

//generates top 10 charts by rating and hits for each main category
if( $rate == 1 )
{
	$title  = _WLS_SITE_HIGHRATE;
	$sort   = _WLS_RATING;
	$sortDB = "rating";
}
else
{
	$title  = _WLS_SITE_POPULAR;
	$sort   = _WLS_HITS;
	$sortDB = "hits";
}

//assignIndex();
//assignDisplayLink();
$template->assignIndex();
$header = $template->fetch_header();
$xoopsTpl->assign('weblinks_header', $header);
$template->assignDisplayLink();

$topten_title = sprintf(_WLS_TOPTEN_TITLE, $title, $MAX_LINKS);

$xoopsTpl->assign('lang_topten_title', $topten_title);
$xoopsTpl->assign('lang_sortby',       $sort);

if ( $TOPTEN_STYLE )
{
	$links_list = get_rankings_mixed($sortDB);
	$xoopsTpl->assign('weblinks_links_list', $links_list);
}
else
{
	$rankings = get_rankings_each($sortDB);
	$xoopsTpl->assign('rankings', $rankings);
}

//$xoopsTpl->assign('rankings', $rankings);

if ( $weblinks_topten_error )
{
	$xoopsTpl->assign('lang_topten_error', $weblinks_topten_error);
}

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---


function get_rankings_each($sortDB)
{
	global $xoopsModuleConfig;
	$MAX_CATS  = intval($xoopsModuleConfig['topten_cats']);
	$MAX_LINKS = intval($xoopsModuleConfig['topten_links']);

	global $tbl_link, $tbl_category;
	global $weblinks_topten_error;

	$i = 0;
	$arr      = array();
	$rankings = array();

	$tbl_category->getAll();
	$cid_arr = $tbl_category->getCidArrayByPid(0);

	$weblinks_topten_error = '';
	if ( count($cid_arr) > $MAX_CATS )
	{
		$weblinks_topten_error = sprintf(_WLS_TOPTEN_ERROR, $MAX_CATS);
	}

	foreach ($cid_arr as $cid)
	{
		$ctitle  = $tbl_category->getValueByCid($cid, 'title', 'S');

		$rankings[$i]['cid']   = $cid;
		$rankings[$i]['title'] = sprintf(_WLS_TOPTEN_TITLE, $ctitle, $MAX_LINKS);

// get all child cat ids for a given cat id
		$rank = 1;

		$array = array_merge(array($cid), $tbl_category->getAllChildId($cid));

		$orderby = "$sortDB DESC";
		$lid_arr = $tbl_link->getLidArrayByCidArray($array, $orderby, $MAX_LINKS, 0);

//		foreach ($lid_arr as $lid) 
//		{
//			$record2 = $tbl_link->getRowByLid($lid);
//			$rankings[$i]['links'][] = $tbl_link->makeDisplay($record2);
//		}

		global $template;

		$links = array();
		foreach ($lid_arr as $lid) 
		{
			$record2 = $tbl_link->getRowByLid($lid);
			$links[] = $tbl_link->makeDisplay($record2);
		}
		$rankings[$i]['links_list'] = $template->fetch_links_list( $links );

		$i++;
		if ($i >= $MAX_CATS ) break;
	}

	return $rankings;
}

function get_rankings_mixed($sortDB)
{
	global $xoopsModuleConfig;
	$MAX_LINKS = intval($xoopsModuleConfig['topten_links']);

	global $tbl_link;

//	$rankings = array();

	$orderby = "$sortDB DESC";
	$records = $tbl_link->getRowsByOrderby($orderby, $MAX_LINKS, 0);

//	foreach ($records as $record) 
//	{
//		$rankings[] = $tbl_link->makeDisplay($record);
//	}

	global $template;

	$links = array();
	foreach ($records as $record) 
	{
		$links[] = $tbl_link->makeDisplay($record);
	}
	$links_list = $template->fetch_links_list( $links );

//	return $rankings;
	return $links_list;
}

?>